/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.gui.table.component;

import java.util.ArrayList;
import java.util.List;
import javax.el.ValueExpression;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.component.html.HtmlCommandLink;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;
import org.ajax4jsf.event.AjaxEvent;
import org.ajax4jsf.event.AjaxListener;
import org.ajax4jsf.event.AjaxSource;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.gui.table.model.PagedListDataModel;
import org.rhq.core.gui.util.FacesComponentUtility;

public class SortableColumnHeaderComponent
extends HtmlCommandLink
implements AjaxSource {
    public static final String COMPONENT_TYPE = "org.rhq.SortableColumnHeader";
    public static final String COMPONENT_FAMILY = "org.rhq.SortableColumnHeader";
    private String sortBy;
    private List<AjaxListener> ajaxListeners;
    private Object[] values;

    public SortableColumnHeaderComponent() {
        SortableColumnHeaderListener listener = new SortableColumnHeaderListener();
        this.addActionListener(listener);
        this.ajaxListeners = new ArrayList<AjaxListener>(1);
        this.addAjaxListener(listener);
    }

    public String getSortBy() {
        ValueExpression valueExp = this.getValueExpression("sortBy");
        if (valueExp != null) {
            this.sortBy = (String)valueExp.getValue(this.getFacesContext().getELContext());
        }
        return this.sortBy;
    }

    public void setSortBy(String sortBy) {
        this.sortBy = sortBy;
    }

    public String getFamily() {
        return "org.rhq.SortableColumnHeader";
    }

    public void addAjaxListener(AjaxListener listener) {
        this.ajaxListeners.add(listener);
    }

    public AjaxListener[] getAjaxListeners() {
        return this.ajaxListeners.toArray(new AjaxListener[this.ajaxListeners.size()]);
    }

    public void removeAjaxListener(AjaxListener listener) {
        this.ajaxListeners.remove(listener);
    }

    public Object saveState(FacesContext context) {
        for (ActionListener listener : this.getActionListeners()) {
            this.removeActionListener(listener);
        }
        if (this.values == null) {
            this.values = new Object[2];
        }
        this.values[0] = super.saveState(context);
        this.values[1] = this.sortBy;
        return this.values;
    }

    public void restoreState(FacesContext context, Object state) {
        this.values = (Object[])state;
        super.restoreState(context, this.values[0]);
        this.sortBy = (String)this.values[1];
    }

    public class SortableColumnHeaderListener
    implements ActionListener,
    AjaxListener {
        public void processAction(ActionEvent event) throws AbortProcessingException {
            SortableColumnHeaderComponent sortableColumnHeader = (SortableColumnHeaderComponent)event.getComponent();
            this.sort(sortableColumnHeader);
        }

        public void processAjax(AjaxEvent event) {
            SortableColumnHeaderComponent sortableColumnHeader = (SortableColumnHeaderComponent)event.getComponent();
            this.sort(sortableColumnHeader);
        }

        private void sort(SortableColumnHeaderComponent sortableColumnHeader) {
            String sortBy = sortableColumnHeader.getSortBy();
            UIData data = FacesComponentUtility.getAncestorOfType((UIComponent)sortableColumnHeader, UIData.class);
            PagedListDataModel model = (PagedListDataModel)((Object)data.getValue());
            PageControl pageControl = model.getPageControl();
            pageControl.sortBy(sortBy);
            model.setPageControl(pageControl);
        }
    }
}

