/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.handler;

import java.util.Vector;
import org.apache.juddi.datatype.RegistryObject;
import org.apache.juddi.datatype.request.AuthInfo;
import org.apache.juddi.datatype.request.DeleteSubscription;
import org.apache.juddi.datatype.subscription.SubscriptionKey;
import org.apache.juddi.handler.AbstractHandler;
import org.apache.juddi.handler.HandlerMaker;
import org.apache.juddi.util.xml.XMLUtils;
import org.w3c.dom.Element;

public class DeleteSubscriptionHandler
extends AbstractHandler {
    public static final String TAG_NAME = "delete_subscription";
    private HandlerMaker maker = null;

    protected DeleteSubscriptionHandler(HandlerMaker maker) {
        this.maker = maker;
    }

    public RegistryObject unmarshal(Element element) {
        DeleteSubscription obj = new DeleteSubscription();
        Vector nodeList = null;
        AbstractHandler handler = null;
        String generic = element.getAttribute("generic");
        if (generic != null && generic.trim().length() > 0) {
            obj.setGeneric(generic);
        }
        if ((nodeList = XMLUtils.getChildElementsByTagName(element, "authInfo")).size() > 0) {
            handler = this.maker.lookup("authInfo");
            obj.setAuthInfo((AuthInfo)handler.unmarshal((Element)nodeList.elementAt(0)));
        }
        nodeList = XMLUtils.getChildElementsByTagName(element, "subscriptionKey");
        for (int i = 0; i < nodeList.size(); ++i) {
            handler = this.maker.lookup("subscriptionKey");
            obj.addSubscriptionKey((SubscriptionKey)handler.unmarshal((Element)nodeList.elementAt(i)));
        }
        return obj;
    }

    public void marshal(RegistryObject object, Element parent) {
        Vector keyVector;
        AuthInfo authInfo;
        DeleteSubscription request = (DeleteSubscription)object;
        Element element = parent.getOwnerDocument().createElementNS(null, TAG_NAME);
        AbstractHandler handler = null;
        String generic = request.getGeneric();
        if (generic != null) {
            element.setAttribute("generic", generic);
        }
        if ((authInfo = request.getAuthInfo()) != null) {
            handler = this.maker.lookup("authInfo");
            handler.marshal(authInfo, element);
        }
        if ((keyVector = request.getSubscriptionKeyVector()) != null && keyVector.size() > 0) {
            handler = this.maker.lookup("subscriptionKey");
            for (int i = 0; i < keyVector.size(); ++i) {
                handler.marshal(new SubscriptionKey((String)keyVector.elementAt(i)), element);
            }
        }
        parent.appendChild(element);
    }

    public static void main(String[] args) throws Exception {
        HandlerMaker maker = HandlerMaker.getInstance();
        AbstractHandler handler = maker.lookup(TAG_NAME);
        Element parent = XMLUtils.newRootElement();
        Element child = null;
        AuthInfo authInfo = new AuthInfo();
        authInfo.setValue("6f157513-844e-4a95-a856-d257e6ba9726");
        DeleteSubscription service = new DeleteSubscription();
        service.setAuthInfo(authInfo);
        service.addSubscriptionKey("1bd50f65-9671-41ae-8d13-b3b5a5afcda0");
        service.addSubscriptionKey(new SubscriptionKey("1fbe67e6-f8b5-4743-a23f-9c13e4273d9f"));
        System.out.println();
        RegistryObject regObject = service;
        handler.marshal(regObject, parent);
        child = (Element)parent.getFirstChild();
        parent.removeChild(child);
        XMLUtils.writeXML(child, System.out);
        System.out.println();
        regObject = handler.unmarshal(child);
        handler.marshal(regObject, parent);
        child = (Element)parent.getFirstChild();
        parent.removeChild(child);
        XMLUtils.writeXML(child, System.out);
    }
}

