/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.async.deployer;

import java.util.concurrent.ExecutorService;
import org.jboss.beans.metadata.api.annotations.Inject;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.helpers.AbstractDeployer;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.ejb3.async.spi.AttachmentNames;
import org.jboss.logging.Logger;
import org.jboss.metadata.ejb.jboss.JBossMetaData;

public class AsyncExecutorServiceDeployer
extends AbstractDeployer {
    private static final Logger log = Logger.getLogger(AsyncExecutorServiceDeployer.class);
    private final ExecutorService asyncExecutorService;
    static String KEY_OUTPUT = AsyncExecutorServiceDeployer.class.getSimpleName();

    public AsyncExecutorServiceDeployer(@Inject ExecutorService asyncExecutorService) {
        this.asyncExecutorService = asyncExecutorService;
        this.setInput(JBossMetaData.class);
        this.addOutput(KEY_OUTPUT);
    }

    public void deploy(DeploymentUnit unit) throws DeploymentException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Processing: " + unit));
        }
        if (!this.isEjb3Deployment(unit)) {
            return;
        }
        if (this.asyncExecutorService == null) {
            throw new IllegalStateException(ExecutorService.class.getSimpleName() + " implemenentation was not injected");
        }
        unit.addAttachment(AttachmentNames.ASYNC_INVOCATION_PROCESSOR, (Object)this.asyncExecutorService);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Using async  " + ExecutorService.class.getSimpleName() + " " + this.asyncExecutorService + " for " + unit));
        }
        unit.addAttachment(KEY_OUTPUT, (Object)Boolean.TRUE);
    }

    boolean isEjb3Deployment(DeploymentUnit unit) {
        JBossMetaData md = (JBossMetaData)unit.getAttachment(JBossMetaData.class);
        if (md == null) {
            return false;
        }
        return md.isEJB3x();
    }
}

