/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.deployment;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javassist.bytecode.ClassFile;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.deployment.AbstractDeploymentHandler;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentDeploymentHandler
extends AbstractDeploymentHandler {
    public static final String NAME = "org.jboss.seam.deployment.ComponentDeploymentHandler";
    private static final LogProvider log = Logging.getLogProvider(ComponentDeploymentHandler.class);
    protected Set<Class<Object>> classes = new HashSet<Class<Object>>();

    public Set<Class<Object>> getClasses() {
        return Collections.unmodifiableSet(this.classes);
    }

    @Override
    public void handle(String name, ClassLoader classLoader) {
        if (name.endsWith(".class")) {
            String classname = ComponentDeploymentHandler.filenameToClassname(name);
            String filename = ComponentDeploymentHandler.componentFilename(name);
            try {
                boolean installable;
                ClassFile classFile = this.getClassFile(name, classLoader);
                boolean bl = installable = (this.hasAnnotation(classFile, Name.class) || classLoader.getResources(filename).hasMoreElements()) && !"false".equals(this.getAnnotationValue(classFile, Install.class, "value"));
                if (installable) {
                    log.trace("found component class: " + name);
                    this.classes.add(classLoader.loadClass(classname));
                }
            }
            catch (ClassNotFoundException cnfe) {
                log.debug("could not load class: " + classname, cnfe);
            }
            catch (NoClassDefFoundError ncdfe) {
                log.debug("could not load class (missing dependency): " + classname, ncdfe);
            }
            catch (IOException ioe) {
                log.debug("could not load classfile: " + classname, ioe);
            }
        }
    }

    private static String componentFilename(String name) {
        return name.substring(0, name.lastIndexOf(".class")) + ".component.xml";
    }

    @Override
    public String getName() {
        return NAME;
    }
}

