/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.core;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.jboss.seam.core.ConversationEntries;
import org.jboss.seam.core.Manager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConversationEntry
implements Serializable,
Comparable<ConversationEntry> {
    private static final long serialVersionUID = 3624635335271963568L;
    private long lastRequestTime;
    private String description;
    private String id;
    private Date startDatetime;
    private Date lastDatetime;
    private String viewId;
    private List<String> conversationIdStack;
    private Integer timeout;
    private Integer concurrentRequestTimeout;
    private boolean removeAfterRedirect;
    private boolean ended;
    private ConversationEntries entries;
    private ReentrantLock lock;

    public ConversationEntry(String id, List<String> stack, ConversationEntries entries) {
        this.id = id;
        if (stack == null) {
            throw new IllegalArgumentException("Stack must not be null");
        }
        if (id == null) {
            throw new IllegalArgumentException("id must not be null");
        }
        this.conversationIdStack = stack;
        this.startDatetime = new Date();
        this.entries = entries;
        this.lock = this.conversationIdStack.size() > 1 ? entries.getConversationEntry((String)this.conversationIdStack.get((int)(this.conversationIdStack.size() - 1))).lock : new ReentrantLock(true);
        this.touch();
    }

    public String getDescription() {
        return this.description;
    }

    void setDescription(String description) {
        this.entries.setDirty(this.description, description);
        this.description = description;
    }

    public synchronized long getLastRequestTime() {
        return this.lastRequestTime;
    }

    synchronized void touch() {
        this.entries.setDirty();
        this.lastRequestTime = System.currentTimeMillis();
        this.lastDatetime = new Date();
    }

    public String getId() {
        return this.id;
    }

    public Date getStartDatetime() {
        return this.startDatetime;
    }

    public void destroy() {
        boolean success = Manager.instance().switchConversation(this.getId());
        if (success) {
            Manager.instance().endConversation(false);
        }
    }

    public void select() {
        this.redirect();
    }

    public boolean redirect() {
        String viewId = this.getViewId();
        if (viewId == null) {
            return false;
        }
        Manager.instance().redirect(viewId, this.getId());
        return true;
    }

    void setViewId(String viewId) {
        this.entries.setDirty(this.viewId, viewId);
        this.viewId = viewId;
    }

    public String getViewId() {
        return this.viewId;
    }

    public synchronized Date getLastDatetime() {
        return this.lastDatetime;
    }

    public List<String> getConversationIdStack() {
        return this.conversationIdStack;
    }

    public boolean isDisplayable() {
        return !this.isEnded() && !this.isRemoveAfterRedirect() && this.getDescription() != null;
    }

    public boolean isCurrent() {
        Manager manager = Manager.instance();
        if (manager.isLongRunningConversation()) {
            return this.id.equals(manager.getCurrentConversationId());
        }
        if (manager.isNestedConversation()) {
            return this.id.equals(manager.getParentConversationId());
        }
        return false;
    }

    @Override
    public int compareTo(ConversationEntry entry) {
        int result = new Long(this.getLastRequestTime()).compareTo(entry.getLastRequestTime());
        return -(result == 0 ? this.getId().compareTo(entry.getId()) : result);
    }

    public int getTimeout() {
        return this.timeout == null ? Manager.instance().getConversationTimeout() : this.timeout.intValue();
    }

    void setTimeout(int conversationTimeout) {
        this.entries.setDirty(this.timeout, this.timeout);
        this.timeout = conversationTimeout;
    }

    public Integer getConcurrentRequestTimeout() {
        return this.concurrentRequestTimeout == null ? Manager.instance().getConcurrentRequestTimeout() : this.concurrentRequestTimeout.intValue();
    }

    void setConcurrentRequestTimeout(Integer concurrentRequestTimeout) {
        this.entries.setDirty(this.concurrentRequestTimeout, concurrentRequestTimeout);
        this.concurrentRequestTimeout = concurrentRequestTimeout;
    }

    public boolean isRemoveAfterRedirect() {
        return this.removeAfterRedirect;
    }

    public void setRemoveAfterRedirect(boolean removeAfterRedirect) {
        this.entries.setDirty();
        this.removeAfterRedirect = removeAfterRedirect;
    }

    void setId(String id) {
        this.id = id;
    }

    public boolean lockNoWait() {
        return this.lock.tryLock();
    }

    public boolean lock() {
        try {
            return this.lock.tryLock(this.getConcurrentRequestTimeout().intValue(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException ie) {
            throw new RuntimeException(ie);
        }
    }

    public void unlock() {
        this.lock.unlock();
    }

    public boolean isLockedByCurrentThread() {
        return this.lock.isHeldByCurrentThread();
    }

    public void end() {
        this.ended = true;
    }

    public boolean isEnded() {
        return this.ended;
    }

    public boolean isNested() {
        return this.conversationIdStack.size() > 1;
    }

    public String toString() {
        return "ConversationEntry(" + this.id + ")";
    }
}

