/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.integration.hornetq.jopr;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jboss.as.integration.hornetq.jopr.JMSComponent;
import org.jboss.as.integration.hornetq.jopr.util.ManagementSupport;
import org.jboss.as.integration.hornetq.jopr.util.Operation;
import org.jboss.deployers.spi.management.ManagementView;
import org.jboss.managed.api.ComponentType;
import org.jboss.managed.api.ManagedOperation;
import org.jboss.metatype.api.types.ArrayMetaType;
import org.jboss.metatype.api.types.ImmutableCompositeMetaType;
import org.jboss.metatype.api.types.SimpleMetaType;
import org.jboss.metatype.api.values.ArrayValueSupport;
import org.jboss.metatype.api.values.CollectionValueSupport;
import org.jboss.metatype.api.values.CompositeValueSupport;
import org.jboss.metatype.api.values.MetaValue;
import org.jboss.metatype.api.values.SimpleValueSupport;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyList;
import org.rhq.core.domain.configuration.PropertyMap;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.configuration.definition.PropertyDefinition;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.DataType;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.core.domain.measurement.MeasurementDataTrait;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.pluginapi.configuration.ConfigurationFacet;
import org.rhq.core.pluginapi.inventory.DeleteResourceFacet;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.measurement.MeasurementFacet;
import org.rhq.core.pluginapi.operation.OperationFacet;
import org.rhq.core.pluginapi.operation.OperationResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JMSResourceComponent
implements ResourceComponent,
MeasurementFacet,
OperationFacet,
ConfigurationFacet,
JMSComponent,
DeleteResourceFacet {
    protected ResourceContext resourceContext;
    protected JMSComponent jmsComponent;

    public AvailabilityType getAvailability() {
        return AvailabilityType.UP;
    }

    public void deleteResource() throws Exception {
        ManagementView view = this.getProfileService();
        ManagedOperation operation = ManagementSupport.getOperation(view, this.getComponentName(), this.getDeleteOperationName(), this.getComponentType());
        operation.invoke(new MetaValue[]{new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)((Object)this.resourceContext.getResourceKey()))});
    }

    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> measurementScheduleRequests) throws Exception {
        ArrayValueSupport support = new ArrayValueSupport(new ArrayMetaType(SimpleMetaType.STRING, false));
        SimpleValueSupport[] valueSupports = new SimpleValueSupport[measurementScheduleRequests.size()];
        Iterator<MeasurementScheduleRequest> it = measurementScheduleRequests.iterator();
        int valueSupportsLength = valueSupports.length;
        for (int i = 0; i < valueSupportsLength; ++i) {
            valueSupports[i] = new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)((Object)it.next().getName()));
        }
        support.setValue((Object)valueSupports);
        ManagementView view = this.getProfileService();
        ManagedOperation operation = ManagementSupport.getOperation(view, this.getComponentName(), this.getMeasurementsOperationName(), this.getComponentType());
        ArrayValueSupport vals = (ArrayValueSupport)operation.invoke(new MetaValue[]{new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)((Object)this.resourceContext.getResourceKey())), support});
        it = measurementScheduleRequests.iterator();
        int valueSupportsLength2 = valueSupports.length;
        for (int i = 0; i < valueSupportsLength2; ++i) {
            MeasurementScheduleRequest request = it.next();
            SimpleValueSupport simpleValueSupport = (SimpleValueSupport)vals.getValue(i);
            simpleValueSupport.getValue();
            if (request.getDataType().equals((Object)DataType.MEASUREMENT)) {
                report.addData(new MeasurementDataNumeric(request, Double.valueOf(simpleValueSupport.getValue().toString())));
                continue;
            }
            if (!request.getDataType().equals((Object)DataType.TRAIT)) continue;
            report.addData(new MeasurementDataTrait(request, simpleValueSupport.getValue().toString()));
        }
    }

    public Configuration loadResourceConfiguration() throws Exception {
        Configuration config = new Configuration();
        ManagementView view = this.getProfileService();
        ManagedOperation operation = ManagementSupport.getOperation(view, this.getComponentName(), this.getConfigurationOperationName(), this.getComponentType());
        CompositeValueSupport val = (CompositeValueSupport)operation.invoke(new MetaValue[]{new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)((Object)this.resourceContext.getResourceKey()))});
        ConfigurationDefinition configDef = this.resourceContext.getResourceType().getResourceConfigurationDefinition();
        List propertyDefinitionList = configDef.getPropertiesInGroup("HornetQCustomProperties");
        for (PropertyDefinition definition : propertyDefinitionList) {
            MetaValue[] msgs;
            String name = definition.getName();
            if (!val.containsKey(name)) continue;
            MetaValue mv = val.get(name);
            if (mv instanceof SimpleValueSupport) {
                SimpleValueSupport attr = (SimpleValueSupport)mv;
                PropertySimple simple = new PropertySimple(name, (Object)attr.getValue());
                config.put((Property)simple);
                continue;
            }
            if (!(mv instanceof CollectionValueSupport)) continue;
            PropertyList property = new PropertyList("roles");
            CollectionValueSupport valueSupport = (CollectionValueSupport)mv;
            for (MetaValue mv2 : msgs = valueSupport.getElements()) {
                CompositeValueSupport msg = (CompositeValueSupport)mv2;
                PropertyMap p1 = new PropertyMap("role");
                property.add((Property)p1);
                ImmutableCompositeMetaType metaType = (ImmutableCompositeMetaType)msg.getMetaType();
                Set keys = metaType.keySet();
                for (String key : keys) {
                    SimpleValueSupport sattr = (SimpleValueSupport)msg.get(key);
                    if (sattr == null) continue;
                    p1.put((Property)new PropertySimple(key, (Object)sattr.getValue()));
                }
            }
            config.put((Property)property);
        }
        return config;
    }

    public OperationResult invokeOperation(String s, Configuration configuration) throws InterruptedException, Exception {
        Operation oper = Operation.getOperation(s);
        Collection<PropertySimple> props = configuration.getSimpleProperties().values();
        SimpleValueSupport[] params = new SimpleValueSupport[props.size()];
        SimpleValueSupport[] signature = new SimpleValueSupport[props.size()];
        this.populateParams(props, params, signature);
        ArrayValueSupport param = new ArrayValueSupport(new ArrayMetaType(SimpleMetaType.STRING, false));
        param.setValue((Object)params);
        ArrayValueSupport sig = new ArrayValueSupport(new ArrayMetaType(SimpleMetaType.STRING, false));
        sig.setValue((Object)signature);
        SimpleValueSupport queueName = new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)((Object)this.resourceContext.getResourceKey()));
        SimpleValueSupport methodName = new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)((Object)oper.getOperationName()));
        ManagementView view = this.getProfileService();
        String methodOperation = this.getInvokeOperation();
        if ("JMSMessage".equalsIgnoreCase(oper.getResultsType())) {
            methodOperation = this.getInvokeOperationJMSMessage();
        } else if ("SubscriptionInfo".equalsIgnoreCase(oper.getResultsType())) {
            methodOperation = this.getInvokeOperationSubscriptionMessage();
        }
        ManagedOperation operation = ManagementSupport.getOperation(view, this.getComponentName(), methodOperation, this.getComponentType());
        MetaValue result = null;
        result = operation.invoke(new MetaValue[]{queueName, methodName, param, sig});
        if (result == null) {
            return null;
        }
        return this.formatResults(result, oper.getResultsType());
    }

    public void start(ResourceContext resourceContext) throws InvalidPluginConfigurationException, Exception {
        this.resourceContext = resourceContext;
        this.jmsComponent = (JMSComponent)resourceContext.getParentResourceComponent();
    }

    public void stop() {
        this.resourceContext = null;
    }

    protected abstract String getInvokeOperationSubscriptionMessage();

    protected abstract String getInvokeOperationJMSMessage();

    protected abstract String getInvokeOperation();

    abstract String getComponentName();

    abstract ComponentType getComponentType();

    abstract String getConfigurationOperationName();

    abstract String getMeasurementsOperationName();

    abstract String getDeleteOperationName();

    private void populateParams(Collection<PropertySimple> props, SimpleValueSupport[] params, SimpleValueSupport[] signature) {
        int pos = 0;
        for (PropertySimple prop : props) {
            String[] val = prop.getName().split(":");
            if (val.length == 1) {
                params[pos] = new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)((Object)this.getStringValue(prop.getStringValue())));
                signature[pos] = new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)((Object)"java.lang.String"));
            } else if (val[0].equals("Boolean")) {
                params[pos] = new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)((Object)this.getStringValue(prop.getBooleanValue())));
                signature[pos] = new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)((Object)"java.lang.Boolean"));
            } else if (val[0].equals("boolean")) {
                params[pos] = new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)((Object)this.getStringValue(prop.getBooleanValue())));
                signature[pos] = new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)((Object)"boolean"));
            } else if (val[0].equals("String")) {
                params[pos] = new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)((Object)this.getStringValue(prop.getStringValue())));
                signature[pos] = new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)((Object)"java.lang.String"));
            } else if (val[0].equals("Long")) {
                params[pos] = new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)((Object)this.getStringValue(prop.getLongValue())));
                signature[pos] = new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)((Object)"java.lang.Long"));
            } else if (val[0].equals("long")) {
                params[pos] = new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)((Object)this.getStringValue(prop.getLongValue())));
                signature[pos] = new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)((Object)"long"));
            } else if (val[0].equals("Integer")) {
                params[pos] = new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)((Object)this.getStringValue(prop.getIntegerValue())));
                signature[pos] = new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)((Object)"java.lang.Integer"));
            } else if (val[0].equals("int")) {
                params[pos] = new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)((Object)this.getStringValue(prop.getIntegerValue())));
                signature[pos] = new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)((Object)"int"));
            } else if (val[0].equals("Double")) {
                params[pos] = new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)((Object)this.getStringValue(prop.getDoubleValue())));
                signature[pos] = new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)((Object)"java.lang.Double"));
            } else if (val[0].equals("double")) {
                params[pos] = new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)((Object)this.getStringValue(prop.getDoubleValue())));
                signature[pos] = new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)((Object)"double"));
            }
            ++pos;
        }
    }

    private String getStringValue(Object o) {
        return o == null ? "null" : o.toString();
    }

    private OperationResult formatResults(Object val, String type) throws Exception {
        if (type == null) {
            SimpleValueSupport valueSupport = (SimpleValueSupport)val;
            return new OperationResult(valueSupport.getValue().toString());
        }
        if (type.equalsIgnoreCase("String")) {
            SimpleValueSupport valueSupport = (SimpleValueSupport)val;
            return new OperationResult(valueSupport.getValue().toString());
        }
        if (type.equalsIgnoreCase("String[]")) {
            OperationResult operationResult = new OperationResult();
            Configuration c = operationResult.getComplexResults();
            PropertyList property = new PropertyList("result");
            ArrayValueSupport support = (ArrayValueSupport)val;
            for (int i = 0; i < support.getLength(); ++i) {
                PropertyMap p1 = new PropertyMap("element");
                property.add((Property)p1);
                SimpleValueSupport svs = (SimpleValueSupport)((ArrayValueSupport)val).getValue(i);
                if (svs == null) continue;
                p1.put((Property)new PropertySimple("value", (Object)svs.getValue()));
            }
            c.put((Property)property);
            return operationResult;
        }
        if (type.equalsIgnoreCase("JMSMessage") || type.equalsIgnoreCase("SubscriptionInfo")) {
            MetaValue[] msgs;
            OperationResult operationResult = new OperationResult();
            Configuration c = operationResult.getComplexResults();
            PropertyList property = new PropertyList("result");
            CollectionValueSupport valueSupport = (CollectionValueSupport)val;
            for (MetaValue mv : msgs = valueSupport.getElements()) {
                CompositeValueSupport msg = (CompositeValueSupport)mv;
                PropertyMap p1 = new PropertyMap("element");
                property.add((Property)p1);
                ImmutableCompositeMetaType metaType = (ImmutableCompositeMetaType)msg.getMetaType();
                Set keys = metaType.keySet();
                for (String key : keys) {
                    SimpleValueSupport sattr = (SimpleValueSupport)msg.get(key);
                    if (sattr == null) continue;
                    p1.put((Property)new PropertySimple(key, (Object)sattr.getValue()));
                }
            }
            c.put((Property)property);
            return operationResult;
        }
        if (val instanceof CompositeValueSupport) {
            CompositeValueSupport valueSupport = (CompositeValueSupport)val;
            if (valueSupport.containsKey("cause")) {
                CompositeValueSupport cause = (CompositeValueSupport)valueSupport.get("cause");
                SimpleValueSupport message = (SimpleValueSupport)cause.get("message");
                Exception exception = new Exception(message.toString());
                throw exception;
            }
            return new OperationResult("not yet");
        }
        return new OperationResult("not yet");
    }

    @Override
    public ManagementView getProfileService() throws Exception {
        return this.jmsComponent.getProfileService();
    }
}

