/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ha.ispn.invoker;

import org.infinispan.Cache;
import org.infinispan.context.Flag;
import org.infinispan.remoting.transport.jgroups.SuspectException;
import org.infinispan.util.concurrent.TimeoutException;
import org.jboss.ha.ispn.invoker.CacheInvoker;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RetryingCacheInvoker
implements CacheInvoker {
    private static final Logger log = Logger.getLogger(RetryingCacheInvoker.class);
    private final int[] backOffIntervals;
    private volatile boolean forceSynchronous = false;

    public RetryingCacheInvoker(int ... backOffIntervals) {
        this.backOffIntervals = backOffIntervals;
    }

    @Override
    public <K, V, R> R invoke(Cache<K, V> cache, CacheInvoker.Operation<K, V, R> operation) {
        Throwable exception = null;
        for (int i = 0; i <= this.backOffIntervals.length; ++i) {
            if (this.forceSynchronous) {
                cache.getAdvancedCache().withFlags(new Flag[]{Flag.FORCE_SYNCHRONOUS});
            }
            try {
                return operation.invoke(cache);
            }
            catch (TimeoutException e) {
                exception = e;
            }
            catch (SuspectException e) {
                exception = e;
            }
            if (i >= this.backOffIntervals.length) continue;
            int delay = this.backOffIntervals[i];
            try {
                if (log.isTraceEnabled()) {
                    log.trace((Object)String.format("Cache operation failed.  Retrying in %d ms", delay), exception);
                }
                Thread.sleep(delay);
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        throw new RuntimeException(String.format("Aborting cache operation after %d retries.", this.backOffIntervals.length + 1), exception);
    }

    @Override
    public void setForceSynchronous(boolean forceSynchronous) {
        this.forceSynchronous = forceSynchronous;
    }
}

