/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.singleton.impl.resolver;

import java.util.List;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.ejb3.common.deployers.spi.AttachmentNames;
import org.jboss.logging.Logger;
import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeanMetaData;
import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeansMetaData;
import org.jboss.metadata.ejb.jboss.JBossMetaData;

public class EjbLinkResolver {
    private static Logger logger = Logger.getLogger(EjbLinkResolver.class);

    public JBossEnterpriseBeanMetaData resolveEJB(String ejbLink, DeploymentUnit deploymentUnit) {
        DeploymentUnit topLevelDeploymentUnit = deploymentUnit.getTopLevel();
        return this.resolveEjbWithinChildDeploymentUnits(ejbLink, topLevelDeploymentUnit);
    }

    private JBossEnterpriseBeanMetaData resolveEjbWithinChildDeploymentUnits(String ejbLink, DeploymentUnit deploymentUnit) {
        JBossMetaData jbossMetaData = this.getMetaData(deploymentUnit);
        JBossEnterpriseBeanMetaData bean = this.getEjbMetaData(ejbLink, jbossMetaData, deploymentUnit);
        if (bean == null) {
            List childUnits = deploymentUnit.getChildren();
            if (childUnits == null) {
                return null;
            }
            for (DeploymentUnit childUnit : childUnits) {
                bean = this.resolveEjbWithinChildDeploymentUnits(ejbLink, childUnit);
                if (bean == null) continue;
                logger.debug((Object)("Resolved container name: " + bean.getContainerName() + " for ejb-link: " + ejbLink + " in unit " + childUnit));
                return bean;
            }
        }
        return bean;
    }

    protected JBossEnterpriseBeanMetaData getEjbMetaData(String ejbLink, JBossMetaData jbossMetaData, DeploymentUnit unit) {
        if (jbossMetaData == null) {
            return null;
        }
        JBossEnterpriseBeansMetaData enterpriseBeans = jbossMetaData.getEnterpriseBeans();
        if (enterpriseBeans == null || enterpriseBeans.isEmpty()) {
            return null;
        }
        int hashIndex = ejbLink.indexOf(35);
        String moduleName = null;
        String ejbName = null;
        if (hashIndex != -1) {
            moduleName = ejbLink.substring(0, hashIndex);
            ejbName = ejbLink.substring(hashIndex + 1);
        } else {
            ejbName = ejbLink;
        }
        for (JBossEnterpriseBeanMetaData enterpriseBean : enterpriseBeans) {
            String potentialMatchEjbName = enterpriseBean.getName();
            if (!ejbName.equals(potentialMatchEjbName) || moduleName != null && !moduleName.equals(unit.getSimpleName())) continue;
            return enterpriseBean;
        }
        return null;
    }

    protected JBossMetaData getMetaData(DeploymentUnit du) {
        return (JBossMetaData)du.getAttachment(AttachmentNames.PROCESSED_METADATA, JBossMetaData.class);
    }
}

