/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profileservice.repository.virtual;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.logging.Logger;
import org.jboss.profileservice.Hack;
import org.jboss.profileservice.spi.NoSuchDeploymentException;
import org.jboss.profileservice.spi.Profile;
import org.jboss.profileservice.spi.ProfileDeployment;
import org.jboss.profileservice.spi.ProfileKey;
import org.jboss.profileservice.spi.VirtualDeploymentRepository;
import org.jboss.profileservice.spi.metadata.ProfileDeploymentMetaData;
import org.jboss.profileservice.spi.virtual.VirtualDeploymentMetaData;

public class VirtualDeploymentProfile
implements Profile {
    private static final Logger log = Logger.getLogger(VirtualDeploymentProfile.class);
    private final ProfileKey key;
    private final Collection<ProfileDeploymentMetaData> deploymentMetaData;
    private final VirtualDeploymentRepository repository;
    private List<ProfileDeployment> deployments = Collections.emptyList();
    private Map<String, ProfileDeployment> deploymentsByName = Collections.emptyMap();
    private final long lastModified;

    public VirtualDeploymentProfile(ProfileKey key, Collection<ProfileDeploymentMetaData> virtual, VirtualDeploymentRepository repository) {
        if (key == null) {
            throw new IllegalArgumentException("null profile key");
        }
        if (repository == null) {
            throw new IllegalArgumentException("null virtual deployment repository");
        }
        this.key = key;
        this.deploymentMetaData = virtual;
        this.repository = repository;
        this.lastModified = System.currentTimeMillis();
    }

    public void create() throws Exception {
        if (this.deploymentMetaData != null && !this.deploymentMetaData.isEmpty()) {
            this.deployments = new ArrayList<ProfileDeployment>();
            this.deploymentsByName = new HashMap<String, ProfileDeployment>();
            for (ProfileDeploymentMetaData virtual : this.deploymentMetaData) {
                try {
                    ProfileDeployment deployment = this.createDeployment(virtual);
                    this.deploymentsByName.put(deployment.getName(), deployment);
                    this.deployments.add(deployment);
                }
                catch (Exception e) {
                    if (!Hack.ignoreHack()) {
                        throw e;
                    }
                    log.error((Object)("failed to create deployment " + virtual.getName()));
                }
            }
        }
    }

    public void destroy() {
        if (this.deployments != null && !this.deployments.isEmpty()) {
            for (ProfileDeployment deployment : this.deployments) {
                try {
                    deployment.cleanup();
                }
                catch (Exception e) {
                    log.debug((Object)("failed to clean up deployment " + deployment));
                }
            }
            this.deployments = Collections.emptyList();
            this.deploymentsByName = Collections.emptyMap();
        }
    }

    public ProfileDeployment getDeployment(String name) throws NoSuchDeploymentException {
        return this.deploymentsByName.get(name);
    }

    public Set<String> getDeploymentNames() {
        return this.deploymentsByName.keySet();
    }

    public List<ProfileDeployment> getDeployments() {
        return Collections.unmodifiableList(this.deployments);
    }

    public ProfileKey getKey() {
        return this.key;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public boolean hasDeployment(String name) {
        return this.deploymentsByName.containsKey(name);
    }

    public boolean isMutable() {
        return false;
    }

    protected ProfileDeployment createDeployment(ProfileDeploymentMetaData deployment) throws Exception {
        return this.getRepository().createDeployment((VirtualDeploymentMetaData)deployment);
    }

    public VirtualDeploymentRepository getRepository() {
        return this.repository;
    }
}

