/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profileservice.repository.legacy;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import org.jboss.profileservice.deployment.hotdeploy.ProfileDeploymentModificationChecker;
import org.jboss.profileservice.repository.artifact.file.FileArtifactId;
import org.jboss.profileservice.repository.legacy.LegacyDeploymentRepository;
import org.jboss.profileservice.spi.ModificationInfo;
import org.jboss.profileservice.spi.ProfileDeployment;
import org.jboss.profileservice.spi.ProfileKey;
import org.jboss.profileservice.spi.VirtualDeploymentRepository;
import org.jboss.profileservice.spi.deployment.ProfileDeploymentFlag;
import org.jboss.profileservice.spi.deployment.ProfileDeploymentInfo;
import org.jboss.profileservice.spi.repository.artifact.ArtifactId;
import org.jboss.vfs.VirtualFile;

public class LegacyHDScanningRepository
extends LegacyDeploymentRepository {
    private ProfileDeploymentModificationChecker modificationChecker;

    public LegacyHDScanningRepository(ProfileKey key, VirtualDeploymentRepository repository) {
        super(key, repository);
    }

    public ProfileDeploymentModificationChecker getModificationChecker() {
        return this.modificationChecker;
    }

    public void setModificationChecker(ProfileDeploymentModificationChecker modificationChecker) {
        this.modificationChecker = modificationChecker;
    }

    protected boolean isModified(ProfileDeployment deployment, FileArtifactId artifactId) throws IOException {
        VirtualFile repositoryFile = this.getArtifactRepository().getArtifactFile((ArtifactId)artifactId);
        return this.modificationChecker != null && this.modificationChecker.isDeploymentModified(deployment, repositoryFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<ModificationInfo> getModifiedDeployments() throws Exception {
        if (!this.isModificationCheckEnabled()) {
            return Collections.emptySet();
        }
        HashMap<String, ModificationInfo> modifications = new HashMap<String, ModificationInfo>();
        this.lockRead();
        try {
            long lastModified = System.currentTimeMillis();
            for (ProfileDeployment deployment : this.getDeployments()) {
                ModificationInfo modification;
                ProfileDeploymentInfo info = deployment.getDeploymentInfo();
                if (info.isLocked()) continue;
                String deploymentName = deployment.getName();
                FileArtifactId artifactId = this.getArtifactMetaData(deployment);
                if (!this.getArtifactRepository().containsArtifact((ArtifactId)artifactId)) {
                    this.internalRemoveDeployment(deploymentName);
                    modification = new ModificationInfo(deployment, lastModified, ModificationInfo.ModifyStatus.REMOVED);
                    modifications.put(deploymentName, modification);
                    continue;
                }
                if (!info.hasFlag(ProfileDeploymentFlag.MODIFIED) && !this.isModified(deployment, artifactId)) continue;
                modification = new ModificationInfo(deployment, lastModified, ModificationInfo.ModifyStatus.MODIFIED);
                modifications.put(deploymentName, modification);
            }
            Collection<ProfileDeployment> additions = this.scanRepository();
            if (additions != null && !additions.isEmpty()) {
                for (ProfileDeployment deployment : additions) {
                    ModificationInfo modification = new ModificationInfo(deployment, lastModified, ModificationInfo.ModifyStatus.ADDED);
                    modifications.put(deployment.getName(), modification);
                }
            }
            if (modifications.size() > 0) {
                this.updateLastModified();
            }
        }
        finally {
            this.unlockRead();
        }
        return modifications.values();
    }
}

