/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profileservice.deployment.hotdeploy;

import org.jboss.beans.info.spi.BeanInfo;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.plugins.registry.BeanKernelRegistryEntry;
import org.jboss.kernel.spi.config.KernelConfig;
import org.jboss.kernel.spi.registry.KernelRegistry;
import org.jboss.kernel.spi.registry.KernelRegistryEntry;
import org.jboss.profileservice.dependency.plugin.ProfileLifeCycleCallbackAction;
import org.jboss.profileservice.deployment.hotdeploy.HDScannerFactory;
import org.jboss.profileservice.deployment.hotdeploy.Scanner;
import org.jboss.profileservice.deployment.hotdeploy.ScannerConfiguration;
import org.jboss.profileservice.spi.MutableProfile;
import org.jboss.profileservice.spi.Profile;

public class HDScannerLifeCycleCallback
implements ProfileLifeCycleCallbackAction<ScannerConfiguration> {
    private static final Class<ScannerConfiguration> namespace = ScannerConfiguration.class;
    private final HDScannerFactory hdScannerFactory;
    private Kernel kernel;

    public HDScannerLifeCycleCallback(HDScannerFactory hdScannerFactory) {
        if (hdScannerFactory == null) {
            throw new IllegalArgumentException("null HDScanner factory");
        }
        this.hdScannerFactory = hdScannerFactory;
    }

    @Override
    public Class<ScannerConfiguration> getFeatureType() {
        return namespace;
    }

    @Override
    public void install(Profile profile, ScannerConfiguration configuration) {
        if (profile.isMutable() && profile instanceof MutableProfile) {
            Scanner scanner = this.hdScannerFactory.registerScanner(profile.getKey(), configuration);
        }
    }

    @Override
    public void uninstall(Profile profile, ScannerConfiguration configuration) {
        if (profile.isMutable() && profile instanceof MutableProfile) {
            this.hdScannerFactory.unregisterScanner(profile.getKey());
        }
    }

    protected void register(Object name, Object object) throws Throwable {
        this.register(this.kernel, name, object);
    }

    protected void register(Kernel kernel, Object name, Object object) throws Throwable {
        KernelRegistryEntry entry = this.createKernelRegistryEntry(kernel, object);
        KernelRegistry registry = kernel.getRegistry();
        registry.registerEntry(name, entry);
    }

    protected KernelRegistryEntry createKernelRegistryEntry(Kernel kernel, Object object) throws Throwable {
        KernelConfig config = kernel.getConfig();
        BeanInfo info = config.getBeanInfo(object.getClass());
        return new BeanKernelRegistryEntry(object, info);
    }
}

