/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profileservice.deployment.hotdeploy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.logging.Logger;
import org.jboss.profileservice.deployment.hotdeploy.HDScanner;
import org.jboss.profileservice.deployment.hotdeploy.HDScannerFactory;
import org.jboss.profileservice.deployment.hotdeploy.Scanner;
import org.jboss.profileservice.deployment.hotdeploy.ScannerConfiguration;
import org.jboss.profileservice.spi.ProfileKey;
import org.jboss.profileservice.spi.action.ActionController;

abstract class AbstractHDScannerFactory
implements HDScannerFactory {
    protected static final Logger log = Logger.getLogger(HDScannerFactory.class);
    private ConcurrentMap<ProfileKey, ScannerWrapper> registeredScans = new ConcurrentHashMap<ProfileKey, ScannerWrapper>();
    private final ActionController actionController;
    private final AtomicBoolean enabled = new AtomicBoolean(false);

    protected AbstractHDScannerFactory(ActionController actionController) {
        if (actionController == null) {
            throw new IllegalArgumentException("null action controller");
        }
        this.actionController = actionController;
    }

    abstract <T extends Runnable> ScheduledFuture<Void> schedule(T var1, int var2, TimeUnit var3);

    public void stop() {
        this.enabled.set(false);
        for (ProfileKey key : this.registeredScans.keySet()) {
            this.unregisterScanner(key, true);
        }
    }

    @Override
    public Scanner registerScanner(ProfileKey key, ScannerConfiguration configuration) {
        if (key == null) {
            throw new IllegalArgumentException("null profile key");
        }
        if (configuration == null) {
            throw new IllegalArgumentException("null scanner configuration.");
        }
        if (this.registeredScans.containsKey(key)) {
            throw new IllegalArgumentException("scanner already registered for profile " + key);
        }
        HDScanner scanner = this.createHDScannerRunnable(key, this.actionController);
        ScannerWrapper wrapper = this.createScannerWrapper(key, scanner, configuration);
        if (wrapper.isStartAutomatically() && this.enabled.get()) {
            wrapper.start();
        }
        return wrapper;
    }

    @Override
    public Scanner getScanner(ProfileKey key) {
        return (Scanner)this.registeredScans.get(key);
    }

    @Override
    public Collection<Scanner> getRegisteredScanners() {
        return new ArrayList<Scanner>(this.registeredScans.values());
    }

    @Override
    public void activateScanner(ProfileKey key) {
        Scanner scanner = (Scanner)this.registeredScans.get(key);
        if (scanner != null) {
            scanner.start();
        }
    }

    @Override
    public void stopScanner(ProfileKey key) {
        Scanner scanner = (Scanner)this.registeredScans.get(key);
        if (scanner != null) {
            scanner.stop();
        }
    }

    @Override
    public Scanner unregisterScanner(ProfileKey key) {
        return this.unregisterScanner(key, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enableScanning() {
        if (!this.enabled.getAndSet(true)) {
            ConcurrentMap<ProfileKey, ScannerWrapper> concurrentMap = this.registeredScans;
            synchronized (concurrentMap) {
                for (ScannerWrapper wrapper : this.registeredScans.values()) {
                    if (!wrapper.isStartAutomatically()) continue;
                    wrapper.start();
                }
            }
        }
    }

    @Override
    public void disabledScanning() {
        if (this.enabled.getAndSet(false)) {
            for (ProfileKey key : this.registeredScans.keySet()) {
                this.stopScanner(key);
            }
        }
    }

    protected ScheduledFuture<Void> schedule(HDScanner scanner, ScannerConfiguration configuration) {
        if (!this.enabled.get()) {
            throw new IllegalStateException("scanning is disabled");
        }
        if (!this.registeredScans.containsKey(scanner.getKey())) {
            throw new IllegalStateException("Scanner unregistered " + scanner.getKey());
        }
        return this.schedule(scanner, configuration.getScanPeriod(), configuration.getTimeUnit());
    }

    protected Scanner unregisterScanner(ProfileKey key, boolean mayInterruptIfRunning) {
        ScannerWrapper wrapper = (ScannerWrapper)this.registeredScans.remove(key);
        if (wrapper != null) {
            wrapper.stop(mayInterruptIfRunning);
        }
        return wrapper;
    }

    protected ScannerWrapper createScannerWrapper(ProfileKey key, HDScanner scanner, ScannerConfiguration configuration) {
        ScannerWrapper wrapper = new ScannerWrapper(scanner, configuration);
        this.registeredScans.put(key, wrapper);
        return wrapper;
    }

    protected HDScanner createHDScannerRunnable(ProfileKey key, ActionController controller) {
        return new HDScanner(key, controller);
    }

    class ScannerWrapper
    implements Scanner,
    ScannerConfiguration {
        private final ScannerConfiguration configuration;
        private final HDScanner scanner;
        private ScheduledFuture<Void> activeScan;

        public ScannerWrapper(HDScanner scanner, ScannerConfiguration configuration) {
            this.scanner = scanner;
            this.configuration = configuration;
        }

        @Override
        public ProfileKey getKey() {
            return this.scanner.getKey();
        }

        @Override
        public int getScanPeriod() {
            return this.configuration.getScanPeriod();
        }

        @Override
        public TimeUnit getTimeUnit() {
            return this.configuration.getTimeUnit();
        }

        @Override
        public boolean isStartAutomatically() {
            return this.configuration.isStartAutomatically();
        }

        @Override
        public int getScanCount() {
            return this.scanner.getScanCount();
        }

        @Override
        public boolean isScheduled() {
            return this.activeScan != null;
        }

        @Override
        public synchronized void start() {
            if (this.activeScan == null) {
                this.activeScan = AbstractHDScannerFactory.this.schedule(this.scanner, this.configuration);
            }
        }

        @Override
        public synchronized void scan() throws Exception {
            this.scanner.scan();
        }

        @Override
        public synchronized void stop() {
            if (this.activeScan != null) {
                this.activeScan.cancel(false);
                try {
                    this.activeScan.get();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.activeScan = null;
            }
        }

        protected synchronized void stop(boolean mayInterruptIfRunning) {
            if (this.activeScan != null) {
                this.activeScan.cancel(mayInterruptIfRunning);
                this.activeScan = null;
            }
        }
    }
}

