/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.managed.bean.metadata.jbmeta.annotation.processor;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import javax.interceptor.ExcludeClassInterceptors;
import javax.interceptor.ExcludeDefaultInterceptors;
import javax.interceptor.Interceptors;
import org.jboss.interceptor.reader.cache.DefaultMetadataCachingReader;
import org.jboss.interceptor.spi.metadata.InterceptorMetadata;
import org.jboss.managed.bean.metadata.jbmeta.InterceptorBindingMetaData;
import org.jboss.managed.bean.metadata.jbmeta.ManagedBeanMetaDataImpl;
import org.jboss.managed.bean.metadata.jbmeta.MethodMetadataImpl;
import org.jboss.metadata.annotation.creator.AbstractFinderUser;
import org.jboss.metadata.annotation.creator.Processor;
import org.jboss.metadata.annotation.finder.AnnotationFinder;

public class InterceptorsProcessor<T extends AnnotatedElement>
extends AbstractFinderUser
implements Processor<ManagedBeanMetaDataImpl, T> {
    private static final Collection<Class<? extends Annotation>> PROCESSABLE_ANNOTATION_TYPES = new HashSet<Class<? extends Annotation>>(1);

    public InterceptorsProcessor(AnnotationFinder<AnnotatedElement> finder) {
        super(finder);
    }

    public Collection<Class<? extends Annotation>> getAnnotationTypes() {
        return PROCESSABLE_ANNOTATION_TYPES;
    }

    public void process(ManagedBeanMetaDataImpl managedBean, T annotatedElement) {
        ExcludeClassInterceptors excludeClass;
        Interceptors interceptors = annotatedElement.getAnnotation(Interceptors.class);
        if (interceptors == null) {
            return;
        }
        ArrayList interceptorsMetadata = new ArrayList();
        for (Class interceptor : interceptors.value()) {
            InterceptorMetadata interceptorMetaData = new DefaultMetadataCachingReader().getInterceptorMetadata(interceptor);
            interceptorsMetadata.add(interceptorMetaData);
        }
        InterceptorBindingMetaData interceptorBinding = new InterceptorBindingMetaData(interceptorsMetadata);
        if (annotatedElement instanceof Method) {
            Method method = (Method)annotatedElement;
            MethodMetadataImpl methodMetadata = new MethodMetadataImpl(method);
            interceptorBinding.setMethod(methodMetadata);
        }
        interceptorBinding.setExcludeClassInterceptors((excludeClass = (ExcludeClassInterceptors)this.finder.getAnnotation(annotatedElement, ExcludeClassInterceptors.class)) != null);
        ExcludeDefaultInterceptors excludeDefaults = (ExcludeDefaultInterceptors)this.finder.getAnnotation(annotatedElement, ExcludeDefaultInterceptors.class);
        interceptorBinding.setExcludeDefaultInterceptors(excludeDefaults != null);
        managedBean.addInterceptorBinding(interceptorBinding);
    }

    static {
        PROCESSABLE_ANNOTATION_TYPES.add(Interceptors.class);
    }
}

