/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.jsp;

import java.io.IOException;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.jstl.core.Config;
import org.apache.myfaces.application.jsp.ServletViewResponseWrapper;
import org.apache.myfaces.shared_impl.view.JspViewDeclarationLanguageBase;
import org.apache.myfaces.view.jsp.FaceletsOnlyException;

public class JspViewDeclarationLanguage
extends JspViewDeclarationLanguageBase {
    public static final Logger log = Logger.getLogger(JspViewDeclarationLanguage.class.getName());
    public static final String[] FACELETS_ONLY_F_TAGS = new String[]{"ajax", "event", "metadata"};
    public static final String[] FACELETS_ONLY_H_TAGS = new String[]{"outputScript", "outputStylesheet", "head", "body", "button", "link"};

    public JspViewDeclarationLanguage() {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("New JspViewDeclarationLanguage instance created");
        }
    }

    public void buildView(FacesContext context, UIViewRoot view) throws IOException {
        boolean errorResponse;
        super.buildView(context, view);
        ExternalContext externalContext = context.getExternalContext();
        ServletResponse response = (ServletResponse)externalContext.getResponse();
        ServletRequest request = (ServletRequest)externalContext.getRequest();
        Locale locale = view.getLocale();
        response.setLocale(locale);
        Config.set((ServletRequest)request, (String)"javax.servlet.jsp.jstl.fmt.locale", (Object)context.getViewRoot().getLocale());
        String viewId = view.getViewId();
        ServletViewResponseWrapper wrappedResponse = new ServletViewResponseWrapper((HttpServletResponse)response);
        externalContext.setResponse((Object)wrappedResponse);
        try {
            externalContext.dispatch(viewId);
        }
        catch (FacesException e) {
            String message = e.getMessage();
            if (message != null) {
                if (message.contains("\"f\"") || message.contains("\"http://java.sun.com/jsf/core\"")) {
                    for (String tag : FACELETS_ONLY_F_TAGS) {
                        if (!message.contains("\"" + tag + "\"")) continue;
                        String exceptionMessage = "The tag f:" + tag + " is only available on facelets.";
                        throw new FacesException(exceptionMessage, (Throwable)new FaceletsOnlyException(exceptionMessage, e.getCause()));
                    }
                } else if (message.contains("\"h\"") || message.contains("\"http://java.sun.com/jsf/html\"")) {
                    for (String tag : FACELETS_ONLY_H_TAGS) {
                        if (!message.contains("\"" + tag + "\"")) continue;
                        String exceptionMessage = "The tag h:" + tag + " is only available on facelets.";
                        throw new FacesException(exceptionMessage, (Throwable)new FaceletsOnlyException(exceptionMessage, e.getCause()));
                    }
                } else {
                    String namespace = null;
                    if (message.contains("http://java.sun.com/jsf/facelets")) {
                        namespace = "http://java.sun.com/jsf/facelets";
                    } else if (message.contains("http://java.sun.com/jsf/composite")) {
                        namespace = "http://java.sun.com/jsf/composite";
                    }
                    if (namespace != null) {
                        String exceptionMessage = "All tags with namespace " + namespace + " are only available on facelets.";
                        throw new FacesException(exceptionMessage, (Throwable)new FaceletsOnlyException(exceptionMessage, e.getCause()));
                    }
                }
            }
            throw e;
        }
        finally {
            externalContext.setResponse((Object)response);
        }
        boolean bl = errorResponse = wrappedResponse.getStatus() < 200 || wrappedResponse.getStatus() > 299;
        if (errorResponse) {
            wrappedResponse.flushToWrappedResponse();
            return;
        }
        if (!context.getPartialViewContext().isPartialRequest()) {
            this.setAfterViewTagResponseWrapper(externalContext, wrappedResponse);
        }
    }

    protected void sendSourceNotFound(FacesContext context, String message) {
        HttpServletResponse response = (HttpServletResponse)context.getExternalContext().getResponse();
        try {
            context.responseComplete();
            response.sendError(404, message);
        }
        catch (IOException ioe) {
            throw new FacesException((Throwable)ioe);
        }
    }
}

