/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.server.impl;

import org.hornetq.api.core.SimpleString;
import org.hornetq.core.filter.Filter;
import org.hornetq.core.logging.Logger;
import org.hornetq.core.persistence.StorageManager;
import org.hornetq.core.postoffice.PostOffice;
import org.hornetq.core.server.Divert;
import org.hornetq.core.server.RoutingContext;
import org.hornetq.core.server.ServerMessage;
import org.hornetq.core.server.cluster.Transformer;

public class DivertImpl
implements Divert {
    private static final Logger log = Logger.getLogger(DivertImpl.class);
    private final PostOffice postOffice;
    private final SimpleString forwardAddress;
    private final SimpleString uniqueName;
    private final SimpleString routingName;
    private final boolean exclusive;
    private final Filter filter;
    private final Transformer transformer;
    private final StorageManager storageManager;

    public DivertImpl(SimpleString forwardAddress, SimpleString uniqueName, SimpleString routingName, boolean exclusive, Filter filter, Transformer transformer, PostOffice postOffice, StorageManager storageManager) {
        this.forwardAddress = forwardAddress;
        this.uniqueName = uniqueName;
        this.routingName = routingName;
        this.exclusive = exclusive;
        this.filter = filter;
        this.transformer = transformer;
        this.postOffice = postOffice;
        this.storageManager = storageManager;
    }

    @Override
    public void route(ServerMessage message, RoutingContext context) throws Exception {
        long id = this.storageManager.generateUniqueID();
        ServerMessage copy = message.copy(id);
        copy.setOriginalHeaders(message, false);
        copy.setAddress(this.forwardAddress);
        if (this.transformer != null) {
            copy = this.transformer.transform(copy);
        }
        this.postOffice.route(copy, context.getTransaction(), false);
    }

    @Override
    public SimpleString getRoutingName() {
        return this.routingName;
    }

    @Override
    public SimpleString getUniqueName() {
        return this.uniqueName;
    }

    @Override
    public boolean isExclusive() {
        return this.exclusive;
    }

    @Override
    public Filter getFilter() {
        return this.filter;
    }

    public String toString() {
        return "DivertImpl [routingName=" + this.routingName + ", uniqueName=" + this.uniqueName + ", forwardAddress=" + this.forwardAddress + ", exclusive=" + this.exclusive + ", filter=" + this.filter + ", transformer=" + this.transformer + "]";
    }
}

