/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.metadata;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import javax.management.Description;
import javax.management.IntrospectionException;
import javax.management.MBean;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanFeatureInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.ManagedAttribute;
import javax.management.ManagedOperation;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationBroadcaster;
import javax.management.NotificationInfo;
import javax.management.NotificationInfos;
import org.jboss.mx.metadata.AbstractBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandardMetaData
extends AbstractBuilder {
    private Object mbeanInstance = null;
    private Class<?> mbeanClass = null;
    private Class<?> mbeanInterface = null;

    public static Class<?> findStandardInterface(Class<?> mbeanClass) {
        Class<?> stdInterface = null;
        for (Class<?> concrete = mbeanClass; null != concrete; concrete = concrete.getSuperclass()) {
            stdInterface = StandardMetaData.findStandardInterface(concrete, concrete.getInterfaces());
            if (null == stdInterface) continue;
            return stdInterface;
        }
        return null;
    }

    private static Class<?> findStandardInterface(Class<?> concrete, Class<?>[] interfaces) {
        String stdName = concrete.getName() + "MBean";
        Class<?> retval = null;
        for (int i = 0; i < interfaces.length; ++i) {
            if (!interfaces[i].getName().equals(stdName)) continue;
            retval = interfaces[i];
            break;
        }
        return retval;
    }

    public StandardMetaData(Object mbeanInstance) throws NotCompliantMBeanException {
        this(mbeanInstance.getClass());
        this.mbeanInstance = mbeanInstance;
    }

    public StandardMetaData(Class<?> mbeanClass) throws NotCompliantMBeanException {
        this.mbeanClass = mbeanClass;
        this.mbeanInterface = StandardMetaData.findStandardInterface(mbeanClass);
        if (this.mbeanInterface == null && !mbeanClass.isAnnotationPresent(MBean.class)) {
            throw new NotCompliantMBeanException("Cannot obtain management interface for: " + mbeanClass);
        }
    }

    public StandardMetaData(Object mbInstance, Class<?> mbInterface) throws NotCompliantMBeanException {
        this.mbeanInstance = mbInstance;
        this.mbeanClass = mbInstance.getClass();
        this.mbeanInterface = mbInterface;
        if (this.mbeanInterface == null) {
            this.mbeanInterface = StandardMetaData.findStandardInterface(this.mbeanClass);
        }
        if (this.mbeanInterface == null) {
            throw new NotCompliantMBeanException("Cannot obtain management interface for: " + this.mbeanClass);
        }
        if (!this.mbeanInterface.isInterface()) {
            throw new NotCompliantMBeanException("Management interface is not an interface: " + this.mbeanInterface);
        }
    }

    public Class<?> getMBeanInterface() {
        return this.mbeanInterface;
    }

    @Override
    public MBeanInfo build() throws NotCompliantMBeanException {
        if (this.mbeanClass.isAnnotationPresent(MBean.class)) {
            return this.buildFromAnnotations();
        }
        try {
            MBeanFeatureInfo info;
            if (this.mbeanInterface == null) {
                throw new NotCompliantMBeanException("The mbean does not implement a management interface");
            }
            if (this.mbeanInstance != null && !this.mbeanInterface.isInstance(this.mbeanInstance)) {
                throw new NotCompliantMBeanException("The mbean does not implement its management interface " + this.mbeanInterface.getName());
            }
            Constructor<?>[] constructors = this.mbeanClass.getConstructors();
            MBeanConstructorInfo[] constructorInfo = new MBeanConstructorInfo[constructors.length];
            for (int i = 0; i < constructors.length; ++i) {
                constructorInfo[i] = new MBeanConstructorInfo("MBean Constructor.", constructors[i]);
            }
            Method[] methods = this.mbeanInterface.getMethods();
            HashMap<String, Method> getters = new HashMap<String, Method>();
            HashMap<String, Method> setters = new HashMap<String, Method>();
            HashMap<String, MBeanAttributeInfo> operInfo = new HashMap<String, MBeanAttributeInfo>();
            ArrayList<MBeanAttributeInfo> attrInfo = new ArrayList<MBeanAttributeInfo>();
            for (int i = 0; i < methods.length; ++i) {
                Method getter;
                String key;
                String methodName = methods[i].getName();
                Class<?>[] signature = methods[i].getParameterTypes();
                Class<?> returnType = methods[i].getReturnType();
                if (methodName.startsWith("set") && methodName.length() > 3 && signature.length == 1 && returnType == Void.TYPE) {
                    key = methodName.substring(3, methodName.length());
                    Method setter = (Method)setters.get(key);
                    if (setter != null && !setter.getParameterTypes()[0].equals(signature[0])) {
                        throw new IntrospectionException("overloaded type for attribute set: " + key);
                    }
                    setters.put(key, methods[i]);
                    continue;
                }
                if (methodName.startsWith("get") && methodName.length() > 3 && signature.length == 0 && returnType != Void.TYPE) {
                    key = methodName.substring(3, methodName.length());
                    getter = (Method)getters.get(key);
                    if (getter != null && getter.getName().startsWith("is")) {
                        throw new IntrospectionException("mixed use of get/is for attribute " + key);
                    }
                    getters.put(key, methods[i]);
                    continue;
                }
                if (methodName.startsWith("is") && methodName.length() > 2 && signature.length == 0 && this.isBooleanReturn(returnType)) {
                    key = methodName.substring(2, methodName.length());
                    getter = (Method)getters.get(key);
                    if (getter != null && getter.getName().startsWith("get")) {
                        throw new IntrospectionException("mixed use of get/is for attribute " + key);
                    }
                    getters.put(key, methods[i]);
                    continue;
                }
                info = new MBeanOperationInfo("MBean Operation.", methods[i]);
                operInfo.put(this.getSignatureString(methods[i]), (MBeanAttributeInfo)info);
            }
            Object[] keys = getters.keySet().toArray();
            for (int i = 0; i < keys.length; ++i) {
                String attrName = (String)keys[i];
                Method getter = (Method)getters.remove(attrName);
                Method setter = (Method)setters.remove(attrName);
                MBeanAttributeInfo info2 = new MBeanAttributeInfo(attrName, "MBean Attribute.", getter, setter);
                attrInfo.add(info2);
            }
            for (String attrName : setters.keySet()) {
                Method setter = (Method)setters.get(attrName);
                info = new MBeanAttributeInfo(attrName, "MBean Attribute.", null, setter);
                attrInfo.add((MBeanAttributeInfo)info);
            }
            MBeanAttributeInfo[] attributeInfo = attrInfo.toArray(new MBeanAttributeInfo[0]);
            MBeanOperationInfo[] operationInfo = operInfo.values().toArray(new MBeanOperationInfo[0]);
            MBeanNotificationInfo[] notifications = null;
            notifications = this.mbeanInstance instanceof NotificationBroadcaster ? ((NotificationBroadcaster)this.mbeanInstance).getNotificationInfo() : new MBeanNotificationInfo[]{};
            return new MBeanInfo(this.mbeanClass.getName(), "Management Bean.", attributeInfo, constructorInfo, operationInfo, notifications);
        }
        catch (IntrospectionException e) {
            throw new NotCompliantMBeanException(e.getMessage());
        }
    }

    public MBeanInfo buildFromAnnotations() throws NotCompliantMBeanException {
        try {
            MBeanFeatureInfo info;
            Constructor<?>[] constructors = this.mbeanClass.getConstructors();
            MBeanConstructorInfo[] constructorInfo = new MBeanConstructorInfo[constructors.length];
            for (int i = 0; i < constructors.length; ++i) {
                String desc = "MBean Constructor.";
                Description description = constructors[i].getAnnotation(Description.class);
                if (description != null) {
                    desc = description.value();
                }
                MBeanParameterInfo[] signature = this.getSignature(constructors[i]);
                constructorInfo[i] = new MBeanConstructorInfo(desc, desc, signature);
            }
            Method[] methods = this.mbeanClass.getMethods();
            HashMap<String, Method> getters = new HashMap<String, Method>();
            HashMap<String, Method> setters = new HashMap<String, Method>();
            HashMap<String, MBeanAttributeInfo> operInfo = new HashMap<String, MBeanAttributeInfo>();
            ArrayList<MBeanAttributeInfo> attrInfo = new ArrayList<MBeanAttributeInfo>();
            for (int i = 0; i < methods.length; ++i) {
                ManagedOperation operation;
                if (methods[i].isAnnotationPresent(ManagedAttribute.class)) {
                    Method getter;
                    String methodName = methods[i].getName();
                    Class<?>[] signature = methods[i].getParameterTypes();
                    Class<?> returnType = methods[i].getReturnType();
                    if (methodName.startsWith("set") && methodName.length() > 3 && signature.length == 1 && returnType == Void.TYPE) {
                        String key = methodName.substring(3, methodName.length());
                        Method setter = (Method)setters.get(key);
                        if (setter != null && !setter.getParameterTypes()[0].equals(signature[0])) {
                            throw new IntrospectionException("overloaded type for attribute set: " + key);
                        }
                        setters.put(key, methods[i]);
                    } else if (methodName.startsWith("get") && methodName.length() > 3 && signature.length == 0 && returnType != Void.TYPE) {
                        String key = methodName.substring(3, methodName.length());
                        getter = (Method)getters.get(key);
                        if (getter != null && getter.getName().startsWith("is")) {
                            throw new IntrospectionException("mixed use of get/is for attribute " + key);
                        }
                        getters.put(key, methods[i]);
                    } else if (methodName.startsWith("is") && methodName.length() > 2 && signature.length == 0 && this.isBooleanReturn(returnType)) {
                        String key = methodName.substring(2, methodName.length());
                        getter = (Method)getters.get(key);
                        if (getter != null && getter.getName().startsWith("get")) {
                            throw new IntrospectionException("mixed use of get/is for attribute " + key);
                        }
                        getters.put(key, methods[i]);
                    }
                }
                if ((operation = methods[i].getAnnotation(ManagedOperation.class)) == null) continue;
                String desc = "MBean Operation.";
                Description description = methods[i].getAnnotation(Description.class);
                if (description != null) {
                    desc = description.value();
                }
                int impact = operation.impact().getCode();
                MBeanParameterInfo[] sign = this.getSignature(methods[i]);
                info = new MBeanOperationInfo(methods[i].getName(), desc, sign, methods[i].getReturnType().getName(), impact);
                operInfo.put(this.getSignatureString(methods[i]), (MBeanAttributeInfo)info);
            }
            String[] keys = getters.keySet().toArray(new String[0]);
            for (int i = 0; i < keys.length; ++i) {
                String attrName = keys[i];
                Method getter = (Method)getters.remove(attrName);
                Method setter = (Method)setters.remove(attrName);
                String desc = "MBean Attribute.";
                Description description = getter.getAnnotation(Description.class);
                if (description != null) {
                    desc = description.value();
                } else if (setter != null && (description = setter.getAnnotation(Description.class)) != null) {
                    desc = description.value();
                }
                MBeanAttributeInfo info2 = new MBeanAttributeInfo(attrName, desc, getter, setter);
                attrInfo.add(info2);
            }
            for (String attrName : setters.keySet()) {
                Method setter = (Method)setters.get(attrName);
                String desc = "MBean Attribute.";
                Description description = setter.getAnnotation(Description.class);
                if (description != null) {
                    desc = description.value();
                }
                info = new MBeanAttributeInfo(attrName, desc, null, setter);
                attrInfo.add((MBeanAttributeInfo)info);
            }
            MBeanAttributeInfo[] attributeInfo = attrInfo.toArray(new MBeanAttributeInfo[0]);
            MBeanOperationInfo[] operationInfo = operInfo.values().toArray(new MBeanOperationInfo[0]);
            NotificationInfo[] notifs = null;
            NotificationInfos notifInfos = this.mbeanClass.getAnnotation(NotificationInfos.class);
            if (notifInfos != null) {
                notifs = notifInfos.value();
            } else {
                NotificationInfo notifInfo = this.mbeanClass.getAnnotation(NotificationInfo.class);
                if (notifInfo != null) {
                    notifs = new NotificationInfo[]{notifInfo};
                }
            }
            MBeanNotificationInfo[] notifications = null;
            if (notifs == null) {
                notifications = new MBeanNotificationInfo[]{};
            } else {
                notifications = new MBeanNotificationInfo[notifs.length];
                for (int i = 0; i < notifs.length; ++i) {
                    String desc = "MBean Notification.";
                    String description = notifs[i].description().value();
                    if (description.length() > 0) {
                        desc = description;
                    }
                    notifications[i] = new MBeanNotificationInfo(notifs[i].types(), notifs[i].notificationClass().getName(), desc);
                }
            }
            String desc = "Management Bean.";
            Description description = this.mbeanClass.getAnnotation(Description.class);
            if (description != null) {
                desc = description.value();
            }
            return new MBeanInfo(this.mbeanClass.getName(), desc, attributeInfo, constructorInfo, operationInfo, notifications);
        }
        catch (IntrospectionException e) {
            throw new NotCompliantMBeanException(e.getMessage());
        }
    }

    private boolean isBooleanReturn(Class<?> returnType) {
        return returnType == Boolean.TYPE;
    }

    protected MBeanParameterInfo[] getSignature(Constructor<?> constructor) {
        return this.getSignature(constructor.getParameterTypes(), constructor.getParameterAnnotations());
    }

    protected MBeanParameterInfo[] getSignature(Method method) {
        return this.getSignature(method.getParameterTypes(), method.getParameterAnnotations());
    }

    protected MBeanParameterInfo[] getSignature(Class<?>[] parameterTypes, Annotation[][] annotations) {
        MBeanParameterInfo[] result = new MBeanParameterInfo[parameterTypes.length];
        for (int i = 0; i < result.length; ++i) {
            String name;
            String desc = name = "p" + i;
            for (Annotation annotation : annotations[i]) {
                if (annotation.annotationType() != Description.class) continue;
                Description description = (Description)annotation;
                desc = description.value();
            }
            result[i] = new MBeanParameterInfo(name, parameterTypes[i].getName(), desc);
        }
        return result;
    }

    protected String getSignatureString(Method method) {
        String name = method.getName();
        Class<?>[] signature = method.getParameterTypes();
        StringBuffer buffer = new StringBuffer(512);
        buffer.append(name);
        buffer.append("(");
        if (signature != null) {
            for (int i = 0; i < signature.length; ++i) {
                buffer.append(signature[i].getName());
                if (i >= signature.length - 1) continue;
                buffer.append(",");
            }
        }
        buffer.append(")");
        return buffer.toString();
    }
}

