/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.verifier.strategy;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Iterator;
import org.jboss.metadata.BeanMetaData;
import org.jboss.metadata.EntityMetaData;
import org.jboss.metadata.SessionMetaData;
import org.jboss.verifier.Section;
import org.jboss.verifier.strategy.AbstractVerifier;
import org.jboss.verifier.strategy.VerificationContext;

public class EJBVerifier11
extends AbstractVerifier {
    public EJBVerifier11(VerificationContext context) {
        super(context);
    }

    public String getMessageBundle() {
        return "EJB11Messages.properties";
    }

    public void checkSession(SessionMetaData session) {
        boolean beanVerified = false;
        boolean homeVerified = false;
        boolean remoteVerified = false;
        beanVerified = this.verifySessionBean(session);
        homeVerified = this.verifySessionHome(session);
        remoteVerified = this.verifySessionRemote(session);
        if (beanVerified && homeVerified && remoteVerified) {
            this.fireBeanVerifiedEvent((BeanMetaData)session);
        }
    }

    public void checkEntity(EntityMetaData entity) {
        boolean pkVerified = false;
        boolean beanVerified = false;
        boolean homeVerified = false;
        boolean remoteVerified = false;
        beanVerified = this.verifyEntityBean(entity);
        homeVerified = this.verifyEntityHome(entity);
        remoteVerified = this.verifyEntityRemote(entity);
        pkVerified = this.verifyPrimaryKey(entity);
        if (beanVerified && homeVerified && remoteVerified && pkVerified) {
            this.fireBeanVerifiedEvent((BeanMetaData)entity);
        }
    }

    public boolean isCreateMethod(Method m) {
        return m.getName().equals("create");
    }

    public boolean isEjbCreateMethod(Method m) {
        return m.getName().equals("ejbCreate");
    }

    private boolean verifySessionHome(SessionMetaData session) {
        boolean status = true;
        String name = session.getHome();
        if (name == null) {
            return false;
        }
        try {
            Class<?> home = this.classloader.loadClass(name);
            if (session.isStateless()) {
                if (!this.hasDefaultCreateMethod(home)) {
                    this.fireSpecViolationEvent((BeanMetaData)session, new Section("6.8.a"));
                    status = false;
                } else {
                    Method create = this.getDefaultCreateMethod(home);
                    if (!this.hasRemoteReturnType((BeanMetaData)session, create)) {
                        this.fireSpecViolationEvent((BeanMetaData)session, create, new Section("6.8.b"));
                        status = false;
                    }
                    if (this.hasMoreThanOneCreateMethods(home)) {
                        this.fireSpecViolationEvent((BeanMetaData)session, new Section("6.8.c"));
                        status = false;
                    }
                }
            }
            if (!this.hasEJBHomeInterface(home)) {
                this.fireSpecViolationEvent((BeanMetaData)session, new Section("6.10.6.a"));
                status = false;
            }
            for (Method method : Arrays.asList(home.getMethods())) {
                if (!this.hasLegalRMIIIOPArguments(method)) {
                    this.fireSpecViolationEvent((BeanMetaData)session, method, new Section("6.10.6.b"));
                    status = false;
                }
                if (!this.hasLegalRMIIIOPReturnType(method)) {
                    this.fireSpecViolationEvent((BeanMetaData)session, method, new Section("6.10.6.c"));
                    status = false;
                }
                if (this.throwsRemoteException(method)) continue;
                this.fireSpecViolationEvent((BeanMetaData)session, method, new Section("6.10.6.d"));
                status = false;
            }
            if (!this.hasCreateMethod(home)) {
                this.fireSpecViolationEvent((BeanMetaData)session, new Section("6.10.6.e"));
                status = false;
            }
            Iterator createMethods = this.getCreateMethods(home);
            try {
                String beanClass = session.getEjbClass();
                Class<?> bean = this.classloader.loadClass(beanClass);
                while (createMethods.hasNext()) {
                    Method ejbCreate;
                    Method create = (Method)createMethods.next();
                    if (!this.hasMatchingEJBCreate(bean, create)) {
                        this.fireSpecViolationEvent((BeanMetaData)session, create, new Section("6.10.6.f"));
                        status = false;
                    }
                    if (!this.hasRemoteReturnType((BeanMetaData)session, create)) {
                        this.fireSpecViolationEvent((BeanMetaData)session, create, new Section("6.10.6.g"));
                        status = false;
                    }
                    if (this.hasMatchingEJBCreate(bean, create) && !this.hasMatchingExceptions(ejbCreate = this.getMatchingEJBCreate(bean, create), create)) {
                        this.fireSpecViolationEvent((BeanMetaData)session, create, new Section("6.10.6.h"));
                        status = false;
                    }
                    if (this.throwsCreateException(create)) continue;
                    this.fireSpecViolationEvent((BeanMetaData)session, create, new Section("6.10.6.i"));
                    status = false;
                }
            }
            catch (ClassNotFoundException ignored) {
            }
        }
        catch (ClassNotFoundException e) {
            this.fireSpecViolationEvent((BeanMetaData)session, new Section("16.2.c"));
            status = false;
        }
        return status;
    }

    private boolean verifySessionRemote(SessionMetaData session) {
        boolean status = true;
        String name = session.getRemote();
        if (name == null) {
            return false;
        }
        try {
            Class<?> remote = this.classloader.loadClass(name);
            if (!this.hasEJBObjectInterface(remote)) {
                this.fireSpecViolationEvent((BeanMetaData)session, new Section("6.10.5.a"));
                status = false;
            }
            for (Method method : Arrays.asList(remote.getMethods())) {
                if (!this.hasLegalRMIIIOPArguments(method)) {
                    this.fireSpecViolationEvent((BeanMetaData)session, method, new Section("6.10.5.b"));
                    status = false;
                }
                if (!this.hasLegalRMIIIOPReturnType(method)) {
                    this.fireSpecViolationEvent((BeanMetaData)session, method, new Section("6.10.5.c"));
                    status = false;
                }
                if (this.throwsRemoteException(method)) continue;
                this.fireSpecViolationEvent((BeanMetaData)session, method, new Section("6.10.5.d"));
                status = false;
            }
            String beanName = session.getEjbClass();
            Class<?> bean = this.classloader.loadClass(beanName);
            for (Method remoteMethod : Arrays.asList(remote.getDeclaredMethods())) {
                if (!this.hasMatchingMethod(bean, remoteMethod)) {
                    this.fireSpecViolationEvent((BeanMetaData)session, remoteMethod, new Section("6.10.5.e"));
                    status = false;
                }
                if (!this.hasMatchingMethod(bean, remoteMethod)) continue;
                try {
                    Method beanMethod = bean.getMethod(remoteMethod.getName(), remoteMethod.getParameterTypes());
                    if (!this.hasMatchingReturnType(remoteMethod, beanMethod)) {
                        this.fireSpecViolationEvent((BeanMetaData)session, remoteMethod, new Section("6.10.5.f"));
                        status = false;
                    }
                    if (this.hasMatchingExceptions(beanMethod, remoteMethod)) continue;
                    this.fireSpecViolationEvent((BeanMetaData)session, remoteMethod, new Section("6.10.5.g"));
                    status = false;
                }
                catch (NoSuchMethodException ignored) {}
            }
        }
        catch (ClassNotFoundException e) {
            this.fireSpecViolationEvent((BeanMetaData)session, new Section("16.2.d"));
            status = false;
        }
        return status;
    }

    private boolean verifySessionBean(SessionMetaData session) {
        boolean status = true;
        String name = session.getEjbClass();
        try {
            Class<?> bean = this.classloader.loadClass(name);
            if (!this.hasSessionBeanInterface(bean)) {
                this.fireSpecViolationEvent((BeanMetaData)session, new Section("6.5.1"));
                status = false;
            }
            if (this.hasSessionSynchronizationInterface(bean)) {
                if (session.isStateless()) {
                    this.fireSpecViolationEvent((BeanMetaData)session, new Section("6.5.3.a"));
                    status = false;
                }
                if (session.isBeanManagedTx()) {
                    this.fireSpecViolationEvent((BeanMetaData)session, new Section("6.5.3.b"));
                    status = false;
                }
            }
            if (!this.hasEJBCreateMethod(bean, true)) {
                this.fireSpecViolationEvent((BeanMetaData)session, new Section("6.5.5"));
                status = false;
            }
            if (this.hasSessionSynchronizationInterface(bean) && session.isBeanManagedTx()) {
                this.fireSpecViolationEvent((BeanMetaData)session, new Section("6.6.1"));
                status = false;
            }
            if (!this.isPublic(bean)) {
                this.fireSpecViolationEvent((BeanMetaData)session, new Section("6.10.2.a"));
                status = false;
            }
            if (this.isFinal(bean)) {
                this.fireSpecViolationEvent((BeanMetaData)session, new Section("6.10.2.b"));
                status = false;
            }
            if (this.isAbstract(bean)) {
                this.fireSpecViolationEvent((BeanMetaData)session, new Section("6.10.2.c"));
                status = false;
            }
            if (!this.hasDefaultConstructor(bean)) {
                this.fireSpecViolationEvent((BeanMetaData)session, new Section("6.10.2.d"));
                status = false;
            }
            if (this.hasFinalizer(bean)) {
                this.fireSpecViolationEvent((BeanMetaData)session, new Section("6.10.2.e"));
                status = false;
            }
            if (this.hasEJBCreateMethod(bean, true)) {
                Iterator it = this.getEJBCreateMethods(bean);
                while (it.hasNext()) {
                    Method ejbCreate = (Method)it.next();
                    if (!this.isPublic(ejbCreate)) {
                        this.fireSpecViolationEvent((BeanMetaData)session, ejbCreate, new Section("6.10.3.a"));
                        status = false;
                    }
                    if (this.isFinal(ejbCreate) || this.isStatic(ejbCreate)) {
                        this.fireSpecViolationEvent((BeanMetaData)session, ejbCreate, new Section("6.10.3.b"));
                        status = false;
                    }
                    if (!this.hasVoidReturnType(ejbCreate)) {
                        this.fireSpecViolationEvent((BeanMetaData)session, ejbCreate, new Section("6.10.3.c"));
                        status = false;
                    }
                    if (this.hasLegalRMIIIOPArguments(ejbCreate)) continue;
                    this.fireSpecViolationEvent((BeanMetaData)session, ejbCreate, new Section("6.10.3.d"));
                    status = false;
                }
            }
        }
        catch (ClassNotFoundException e) {
            this.fireSpecViolationEvent((BeanMetaData)session, new Section("16.2.b"));
            status = false;
        }
        return status;
    }

    private boolean verifyEntityHome(EntityMetaData entity) {
        boolean status = true;
        String name = entity.getHome();
        if (name == null) {
            return false;
        }
        try {
            Class<?> bean;
            String beanClass;
            Class<?> home = this.classloader.loadClass(name);
            if (!this.hasEJBHomeInterface(home)) {
                this.fireSpecViolationEvent((BeanMetaData)entity, new Section("9.2.8.a"));
                status = false;
            }
            for (Method method : Arrays.asList(home.getMethods())) {
                if (!this.hasLegalRMIIIOPArguments(method)) {
                    this.fireSpecViolationEvent((BeanMetaData)entity, method, new Section("9.2.8.b"));
                    status = false;
                }
                if (!this.hasLegalRMIIIOPReturnType(method)) {
                    this.fireSpecViolationEvent((BeanMetaData)entity, method, new Section("9.2.8.c"));
                    status = false;
                }
                if (this.throwsRemoteException(method)) continue;
                this.fireSpecViolationEvent((BeanMetaData)entity, method, new Section("9.2.8.d"));
                status = false;
            }
            for (Method method : Arrays.asList(home.getMethods())) {
                if (method.getDeclaringClass().getName().equals("javax.ejb.EJBHome") || this.isCreateMethod(method) || this.isFinderMethod(method)) continue;
                this.fireSpecViolationEvent((BeanMetaData)entity, method, new Section("9.2.8.e"));
                status = false;
            }
            try {
                beanClass = entity.getEjbClass();
                bean = this.classloader.loadClass(beanClass);
                Iterator createMethods = this.getCreateMethods(home);
                while (createMethods.hasNext()) {
                    Method create = (Method)createMethods.next();
                    if (!this.hasMatchingEJBCreate(bean, create)) {
                        this.fireSpecViolationEvent((BeanMetaData)entity, create, new Section("9.2.8.f"));
                        status = false;
                    }
                    if (!this.hasRemoteReturnType((BeanMetaData)entity, create)) {
                        this.fireSpecViolationEvent((BeanMetaData)entity, create, new Section("9.2.8.g"));
                        status = false;
                    }
                    if (this.hasMatchingEJBCreate(bean, create) && this.hasMatchingEJBPostCreate(bean, create)) {
                        Method ejbCreate = this.getMatchingEJBCreate(bean, create);
                        Method ejbPostCreate = this.getMatchingEJBPostCreate(bean, create);
                        if (!this.hasMatchingExceptions(ejbCreate, create) || !this.hasMatchingExceptions(ejbPostCreate, create)) {
                            this.fireSpecViolationEvent((BeanMetaData)entity, create, new Section("9.2.8.h"));
                            status = false;
                        }
                    }
                    if (this.throwsCreateException(create)) continue;
                    this.fireSpecViolationEvent((BeanMetaData)entity, create, new Section("9.2.8.i"));
                    status = false;
                }
            }
            catch (ClassNotFoundException ignored) {
                // empty catch block
            }
            try {
                beanClass = entity.getEjbClass();
                bean = this.classloader.loadClass(beanClass);
                Iterator finderMethods = this.getFinderMethods(home);
                while (finderMethods.hasNext()) {
                    Method ejbFind;
                    Method finder = (Method)finderMethods.next();
                    if (entity.isBMP() && !this.hasMatchingEJBFind(bean, finder)) {
                        this.fireSpecViolationEvent((BeanMetaData)entity, finder, new Section("9.2.8.j"));
                        status = false;
                    }
                    if (!this.hasRemoteReturnType((BeanMetaData)entity, finder) && !this.isMultiObjectFinder(finder)) {
                        this.fireSpecViolationEvent((BeanMetaData)entity, finder, new Section("9.2.8.k"));
                        status = false;
                    }
                    if (entity.isBMP() && this.hasMatchingEJBFind(bean, finder) && !this.hasMatchingExceptions(ejbFind = this.getMatchingEJBFind(bean, finder), finder)) {
                        this.fireSpecViolationEvent((BeanMetaData)entity, finder, new Section("9.2.8.l"));
                        status = false;
                    }
                    if (this.throwsFinderException(finder)) continue;
                    this.fireSpecViolationEvent((BeanMetaData)entity, finder, new Section("9.2.8.m"));
                    status = false;
                }
            }
            catch (ClassNotFoundException ignored) {
            }
        }
        catch (ClassNotFoundException e) {
            this.fireSpecViolationEvent((BeanMetaData)entity, new Section("16.2.c"));
            status = false;
        }
        return status;
    }

    private boolean verifyEntityRemote(EntityMetaData entity) {
        boolean status = true;
        String name = entity.getRemote();
        if (name == null) {
            return false;
        }
        try {
            Class<?> remote = this.classloader.loadClass(name);
            if (!this.hasEJBObjectInterface(remote)) {
                this.fireSpecViolationEvent((BeanMetaData)entity, new Section("9.2.7.a"));
                status = false;
            }
            for (Method method : Arrays.asList(remote.getMethods())) {
                if (!this.hasLegalRMIIIOPArguments(method)) {
                    this.fireSpecViolationEvent((BeanMetaData)entity, method, new Section("9.2.7.b"));
                    status = false;
                }
                if (!this.hasLegalRMIIIOPReturnType(method)) {
                    this.fireSpecViolationEvent((BeanMetaData)entity, method, new Section("9.2.7.c"));
                    status = false;
                }
                if (!this.hasLegalRMIIIOPExceptionTypes(method)) {
                    this.fireSpecViolationEvent((BeanMetaData)entity, method, new Section("9.2.7.h"));
                    status = false;
                }
                if (this.throwsRemoteException(method)) continue;
                this.fireSpecViolationEvent((BeanMetaData)entity, method, new Section("9.2.7.d"));
                status = false;
            }
            try {
                String beanClass = entity.getEjbClass();
                Class<?> bean = this.classloader.loadClass(beanClass);
                for (Method method : Arrays.asList(remote.getMethods())) {
                    if (method.getDeclaringClass().getName().equals("javax.ejb.EJBObject")) continue;
                    if (!this.hasMatchingMethod(bean, method)) {
                        this.fireSpecViolationEvent((BeanMetaData)entity, method, new Section("9.2.7.e"));
                        status = false;
                    }
                    if (!this.hasMatchingMethod(bean, method)) continue;
                    try {
                        Method beanMethod = bean.getMethod(method.getName(), method.getParameterTypes());
                        if (!this.hasMatchingReturnType(beanMethod, method)) {
                            this.fireSpecViolationEvent((BeanMetaData)entity, method, new Section("9.2.7.f"));
                            status = false;
                        }
                        if (this.hasMatchingExceptions(beanMethod, method)) continue;
                        this.fireSpecViolationEvent((BeanMetaData)entity, method, new Section("9.2.7.g"));
                        status = false;
                    }
                    catch (NoSuchMethodException ignored) {}
                }
            }
            catch (ClassNotFoundException ignored) {
            }
        }
        catch (ClassNotFoundException e) {
            this.fireSpecViolationEvent((BeanMetaData)entity, new Section("16.2.d"));
            status = false;
        }
        return status;
    }

    private boolean verifyEntityBean(EntityMetaData entity) {
        boolean status = true;
        String name = entity.getEjbClass();
        try {
            Method ejbCreate;
            Iterator it;
            Class<?> bean = this.classloader.loadClass(name);
            if (!this.hasEntityBeanInterface(bean)) {
                this.fireSpecViolationEvent((BeanMetaData)entity, new Section("9.2.2.a"));
                status = false;
            }
            if (!this.isPublic(bean)) {
                this.fireSpecViolationEvent((BeanMetaData)entity, new Section("9.2.2.b"));
                status = false;
            }
            if (this.isAbstract(bean)) {
                this.fireSpecViolationEvent((BeanMetaData)entity, new Section("9.2.2.c"));
                status = false;
            }
            if (this.isFinal(bean)) {
                this.fireSpecViolationEvent((BeanMetaData)entity, new Section("9.2.2.d"));
                status = false;
            }
            if (!this.hasDefaultConstructor(bean)) {
                this.fireSpecViolationEvent((BeanMetaData)entity, new Section("9.2.2.e"));
                status = false;
            }
            if (this.hasFinalizer(bean)) {
                this.fireSpecViolationEvent((BeanMetaData)entity, new Section("9.2.2.f"));
                status = false;
            }
            if (this.hasEJBCreateMethod(bean, false)) {
                it = this.getEJBCreateMethods(bean);
                while (it.hasNext()) {
                    ejbCreate = (Method)it.next();
                    if (!this.isPublic(ejbCreate)) {
                        this.fireSpecViolationEvent((BeanMetaData)entity, ejbCreate, new Section("9.2.3.a"));
                        status = false;
                    }
                    if (this.isFinal(ejbCreate) || this.isStatic(ejbCreate)) {
                        this.fireSpecViolationEvent((BeanMetaData)entity, ejbCreate, new Section("9.2.3.b"));
                        status = false;
                    }
                    if (!this.hasPrimaryKeyReturnType(entity, ejbCreate)) {
                        this.fireSpecViolationEvent((BeanMetaData)entity, ejbCreate, new Section("9.2.3.c"));
                        status = false;
                    }
                    if (!this.hasLegalRMIIIOPArguments(ejbCreate)) {
                        this.fireSpecViolationEvent((BeanMetaData)entity, ejbCreate, new Section("9.2.3.d"));
                        status = false;
                    }
                    if (this.hasLegalRMIIIOPReturnType(ejbCreate)) continue;
                    this.fireSpecViolationEvent((BeanMetaData)entity, ejbCreate, new Section("9.2.3.e"));
                    status = false;
                }
            }
            if (this.hasEJBCreateMethod(bean, false)) {
                it = this.getEJBCreateMethods(bean);
                while (it.hasNext()) {
                    ejbCreate = (Method)it.next();
                    if (!this.hasMatchingEJBPostCreate(bean, ejbCreate)) {
                        this.fireSpecViolationEvent((BeanMetaData)entity, ejbCreate, new Section("9.2.4.a"));
                        status = false;
                    }
                    if (!this.hasMatchingEJBPostCreate(bean, ejbCreate)) continue;
                    Method ejbPostCreate = this.getMatchingEJBPostCreate(bean, ejbCreate);
                    if (!this.isPublic(ejbPostCreate)) {
                        this.fireSpecViolationEvent((BeanMetaData)entity, ejbPostCreate, new Section("9.2.4.b"));
                        status = false;
                    }
                    if (this.isStatic(ejbPostCreate)) {
                        this.fireSpecViolationEvent((BeanMetaData)entity, ejbPostCreate, new Section("9.2.4.c"));
                        status = false;
                    }
                    if (this.isFinal(ejbPostCreate)) {
                        this.fireSpecViolationEvent((BeanMetaData)entity, ejbPostCreate, new Section("9.2.4.d"));
                        status = false;
                    }
                    if (this.hasVoidReturnType(ejbPostCreate)) continue;
                    this.fireSpecViolationEvent((BeanMetaData)entity, ejbPostCreate, new Section("9.2.4.e"));
                    status = false;
                }
            }
            if (entity.isBMP() && !this.hasEJBFindByPrimaryKey(bean)) {
                this.fireSpecViolationEvent((BeanMetaData)entity, new Section("9.2.5.a"));
                status = false;
            }
            if (this.hasEJBFindByPrimaryKey(bean)) {
                Method ejbFindByPrimaryKey = this.getEJBFindByPrimaryKey(bean);
                if (!this.hasPrimaryKeyReturnType(entity, ejbFindByPrimaryKey)) {
                    this.fireSpecViolationEvent((BeanMetaData)entity, ejbFindByPrimaryKey, new Section("9.2.5.b"));
                    status = false;
                }
                if (!this.isSingleObjectFinder(entity, ejbFindByPrimaryKey)) {
                    this.fireSpecViolationEvent((BeanMetaData)entity, ejbFindByPrimaryKey, new Section("9.2.5.c"));
                    status = false;
                }
            }
            if (this.hasFinderMethod(bean)) {
                it = this.getEJBFindMethods(bean);
                while (it.hasNext()) {
                    Method finder = (Method)it.next();
                    if (!this.isPublic(finder)) {
                        this.fireSpecViolationEvent((BeanMetaData)entity, finder, new Section("9.2.5.d"));
                        status = false;
                    }
                    if (this.isFinal(finder)) {
                        this.fireSpecViolationEvent((BeanMetaData)entity, finder, new Section("9.2.5.e"));
                        status = false;
                    }
                    if (this.isStatic(finder)) {
                        this.fireSpecViolationEvent((BeanMetaData)entity, finder, new Section("9.2.5.f"));
                        status = false;
                    }
                    if (!this.hasLegalRMIIIOPArguments(finder)) {
                        this.fireSpecViolationEvent((BeanMetaData)entity, finder, new Section("9.2.5.g"));
                        status = false;
                    }
                    if (this.isSingleObjectFinder(entity, finder) || this.isMultiObjectFinder(finder)) continue;
                    this.fireSpecViolationEvent((BeanMetaData)entity, finder, new Section("9.2.5.h"));
                    status = false;
                }
            }
        }
        catch (ClassNotFoundException e) {
            this.fireSpecViolationEvent((BeanMetaData)entity, new Section("16.2.b"));
            status = false;
        }
        return status;
    }

    private boolean verifyPrimaryKey(EntityMetaData entity) {
        boolean status;
        block26: {
            status = true;
            if (entity.getPrimaryKeyClass() == null || entity.getPrimaryKeyClass().length() == 0) {
                this.fireSpecViolationEvent((BeanMetaData)entity, new Section("16.5.a"));
                return false;
            }
            if (entity.getPrimKeyField() == null || entity.getPrimKeyField().length() == 0) {
                Class<?> cls = null;
                try {
                    cls = this.classloader.loadClass(entity.getPrimaryKeyClass());
                    if (entity.isCMP()) {
                        if (!this.isPublic(cls)) {
                            this.fireSpecViolationEvent((BeanMetaData)entity, new Section("9.4.7.2.a"));
                            status = false;
                        }
                        if (!this.isAllFieldsPublic(cls)) {
                            this.fireSpecViolationEvent((BeanMetaData)entity, new Section("9.4.7.2.b"));
                            status = false;
                        }
                        if (!this.hasANonStaticField(cls)) {
                            this.fireSpecViolationEvent((BeanMetaData)entity, new Section("9.4.7.2.c"));
                            status = false;
                        }
                    }
                    if (cls.getName().equals("java.lang.Object")) break block26;
                    try {
                        Object one = cls.newInstance();
                        Object two = cls.newInstance();
                        try {
                            if (!one.equals(two)) {
                                this.fireSpecViolationEvent((BeanMetaData)entity, new Section("9.2.9.b"));
                                status = false;
                            }
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                        try {
                            if (one.hashCode() != two.hashCode()) {
                                this.fireSpecViolationEvent((BeanMetaData)entity, new Section("9.2.9.c"));
                                status = false;
                            }
                        }
                        catch (NullPointerException e) {}
                    }
                    catch (IllegalAccessException e) {
                    }
                    catch (InstantiationException e) {
                    }
                }
                catch (ClassNotFoundException e) {
                    this.fireSpecViolationEvent((BeanMetaData)entity, new Section("16.2.e"));
                    status = false;
                }
            } else {
                if (entity.isBMP()) {
                    this.fireSpecViolationEvent((BeanMetaData)entity, new Section("9.4.7.1.a"));
                    status = false;
                }
                try {
                    Class<?> fieldClass = this.classloader.loadClass(entity.getEjbClass());
                    Field field = null;
                    try {
                        field = fieldClass.getField(entity.getPrimKeyField());
                        if (!entity.getPrimaryKeyClass().equals(field.getType().getName())) {
                            this.fireSpecViolationEvent((BeanMetaData)entity, new Section("9.4.7.1.c"));
                            status = false;
                        }
                        Iterator it = entity.getCMPFields();
                        boolean found = false;
                        while (it.hasNext()) {
                            String fieldName = (String)it.next();
                            if (!fieldName.equals(entity.getPrimKeyField())) continue;
                            found = true;
                            break;
                        }
                        if (!found) {
                            this.fireSpecViolationEvent((BeanMetaData)entity, new Section("9.4.7.1.d"));
                            status = false;
                        }
                    }
                    catch (NoSuchFieldException e) {
                        this.fireSpecViolationEvent((BeanMetaData)entity, new Section("9.4.7.1.b"));
                        status = false;
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
        }
        return status;
    }
}

