/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins;

import java.lang.reflect.Method;
import java.rmi.RemoteException;
import javax.ejb.EJBException;
import javax.ejb.TimedObject;
import javax.ejb.Timer;
import org.jboss.ejb.AllowedOperationsAssociation;
import org.jboss.ejb.EnterpriseContext;
import org.jboss.ejb.InstancePool;
import org.jboss.ejb.MessageDrivenContainer;
import org.jboss.ejb.plugins.AbstractInterceptor;
import org.jboss.ejb.plugins.EnterpriseBeanPolicyContextHandler;
import org.jboss.invocation.Invocation;

public class MessageDrivenInstanceInterceptor
extends AbstractInterceptor {
    protected static final Method ejbTimeout;

    public Object invokeHome(Invocation mi) throws Exception {
        throw new Error("Not valid for MessageDriven beans");
    }

    public Object invoke(Invocation mi) throws Exception {
        MessageDrivenContainer mdc = (MessageDrivenContainer)this.container;
        InstancePool pool = mdc.getInstancePool();
        EnterpriseContext ctx = null;
        try {
            ctx = pool.get();
        }
        catch (EJBException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EJBException("Unable to get an instance from the pool", e);
        }
        ctx.setPrincipal(mi.getPrincipal());
        mi.setEnterpriseContext(ctx);
        EnterpriseBeanPolicyContextHandler.setEnterpriseBean(ctx.getInstance());
        if (ejbTimeout.equals(mi.getMethod())) {
            AllowedOperationsAssociation.pushInMethodFlag(IN_EJB_TIMEOUT);
        } else {
            AllowedOperationsAssociation.pushInMethodFlag(IN_BUSINESS_METHOD);
        }
        try {
            Object obj;
            Object object = obj = this.getNext().invoke(mi);
            return object;
        }
        catch (RuntimeException e) {
            mi.setEnterpriseContext(null);
            throw e;
        }
        catch (RemoteException e) {
            mi.setEnterpriseContext(null);
            throw e;
        }
        catch (Error e) {
            mi.setEnterpriseContext(null);
            throw e;
        }
        finally {
            AllowedOperationsAssociation.popInMethodFlag();
            EnterpriseBeanPolicyContextHandler.setEnterpriseBean(null);
            if (mi.getEnterpriseContext() != null) {
                pool.free((EnterpriseContext)mi.getEnterpriseContext());
            } else {
                pool.discard(ctx);
            }
        }
    }

    static {
        try {
            ejbTimeout = TimedObject.class.getMethod("ejbTimeout", Timer.class);
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

