/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.rmi.ServerException;
import javax.ejb.EJBException;
import javax.ejb.NoSuchEntityException;
import javax.ejb.NoSuchObjectLocalException;
import javax.ejb.TimedObject;
import javax.ejb.Timer;
import javax.ejb.TransactionRolledbackLocalException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionRolledbackException;
import org.jboss.ejb.plugins.AbstractInterceptor;
import org.jboss.invocation.Invocation;
import org.jboss.invocation.InvocationType;
import org.jboss.tm.TxUtils;

abstract class AbstractTxInterceptor
extends AbstractInterceptor {
    protected static final Method ejbTimeout;
    protected TransactionManager tm;

    AbstractTxInterceptor() {
    }

    public void create() throws Exception {
        super.create();
        this.tm = this.getContainer().getTransactionManager();
    }

    protected Object invokeNext(Invocation invocation, boolean inheritedTx) throws Exception {
        InvocationType type = invocation.getType();
        try {
            if (type == InvocationType.REMOTE || type == InvocationType.LOCAL || type == InvocationType.SERVICE_ENDPOINT) {
                if (ejbTimeout.equals(invocation.getMethod())) {
                    this.registerTimer(invocation);
                }
                return this.getNext().invoke(invocation);
            }
            return this.getNext().invokeHome(invocation);
        }
        catch (Throwable e) {
            Throwable cause;
            boolean isLocal;
            if (e instanceof Exception && !(e instanceof RuntimeException) && !(e instanceof RemoteException)) {
                throw (Exception)e;
            }
            Transaction tx = invocation.getTransaction();
            if (tx == null) {
                try {
                    tx = this.tm.getTransaction();
                    if (!TxUtils.isActive((Transaction)tx)) {
                        tx = null;
                    }
                }
                catch (Exception ex) {
                    this.log.warn((Object)"Unable to determine transaction context", (Throwable)ex);
                }
            }
            if (tx != null) {
                try {
                    tx.setRollbackOnly();
                }
                catch (SystemException ex) {
                    this.log.error((Object)"SystemException while setting transaction for rollback only", (Throwable)ex);
                }
                catch (IllegalStateException ex) {
                    this.log.error((Object)"IllegalStateException while setting transaction for rollback only", (Throwable)ex);
                }
            }
            boolean bl = isLocal = type == InvocationType.LOCAL || type == InvocationType.LOCALHOME;
            if (!inheritedTx) {
                if (e instanceof Exception) {
                    throw (Exception)e;
                }
                if (e instanceof Error) {
                    throw (Error)e;
                }
                if (isLocal) {
                    String msg = this.formatException("Unexpected Throwable", e);
                    throw new EJBException(msg);
                }
                ServerException ex = new ServerException("Unexpected Throwable");
                ex.detail = e;
                throw ex;
            }
            if (e instanceof NoSuchEntityException) {
                NoSuchEntityException nsee = (NoSuchEntityException)e;
                if (isLocal) {
                    cause = new NoSuchObjectLocalException(nsee.getMessage(), nsee.getCausedByException());
                } else {
                    cause = new NoSuchObjectException(nsee.getMessage());
                    ((NoSuchObjectException)cause).detail = nsee.getCausedByException();
                }
            } else if (isLocal) {
                String msg;
                if (e instanceof Exception) {
                    cause = e;
                } else if (e instanceof Error) {
                    msg = this.formatException("Unexpected Error", e);
                    cause = new EJBException(msg);
                } else {
                    msg = this.formatException("Unexpected Throwable", e);
                    cause = new EJBException(msg);
                }
            } else {
                cause = e;
            }
            if (isLocal) {
                if (cause instanceof TransactionRolledbackLocalException) {
                    throw (TransactionRolledbackLocalException)cause;
                }
                throw new TransactionRolledbackLocalException(cause.getMessage(), (Exception)cause);
            }
            if (cause instanceof TransactionRolledbackException) {
                throw (TransactionRolledbackException)cause;
            }
            TransactionRolledbackException ex = new TransactionRolledbackException(cause.getMessage());
            ex.detail = cause;
            throw ex;
        }
    }

    private void registerTimer(Invocation invocation) throws RollbackException, SystemException {
        Timer timer = (Timer)invocation.getArguments()[0];
        Transaction transaction = invocation.getTransaction();
        if (transaction != null && timer instanceof Synchronization) {
            transaction.registerSynchronization((Synchronization)timer);
        }
    }

    private String formatException(String msg, Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        if (msg != null) {
            pw.println(msg);
        }
        t.printStackTrace(pw);
        return sw.toString();
    }

    static {
        try {
            ejbTimeout = TimedObject.class.getMethod("ejbTimeout", Timer.class);
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

