/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.integration.deployers;

import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.ApplicationPath;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.DeploymentStages;
import org.jboss.deployers.spi.deployer.helpers.AbstractRealDeployer;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.logging.Logger;
import org.jboss.metadata.javaee.spec.ParamValueMetaData;
import org.jboss.metadata.javaee.support.MappableMetaData;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.metadata.web.spec.FilterMappingMetaData;
import org.jboss.metadata.web.spec.FilterMetaData;
import org.jboss.metadata.web.spec.FiltersMetaData;
import org.jboss.resteasy.integration.deployers.ResteasyDeploymentData;
import org.jboss.resteasy.plugins.server.servlet.Filter30Dispatcher;

public class ResteasyIntegrationDeployer
extends AbstractRealDeployer {
    private static final Logger LOGGER = Logger.getLogger(ResteasyIntegrationDeployer.class);
    public static final String CDI_INJECTOR_FACTORY_CLASS = "org.jboss.resteasy.cdi.CdiInjectorFactory";

    public ResteasyIntegrationDeployer() {
        this.addRequiredInput(JBossWebMetaData.class);
        this.addRequiredInput(ResteasyDeploymentData.class);
        this.addOutput(JBossWebMetaData.class);
        this.setStage(DeploymentStages.PRE_REAL);
    }

    protected void populateWebMetadata() {
    }

    protected void setFilterInitParam(FilterMetaData filter, String name, String value) {
        ParamValueMetaData param = new ParamValueMetaData();
        param.setParamName(name);
        param.setParamValue(value);
        ArrayList<ParamValueMetaData> params = filter.getInitParam();
        if (params == null) {
            params = new ArrayList<ParamValueMetaData>();
            filter.setInitParam(params);
        }
        params.add(param);
    }

    public static ParamValueMetaData findContextParam(JBossWebMetaData webdata, String name) {
        List params = webdata.getContextParams();
        if (params == null) {
            return null;
        }
        for (ParamValueMetaData param : params) {
            if (!param.getParamName().equals(name)) continue;
            return param;
        }
        return null;
    }

    public static void setContextParameter(JBossWebMetaData webdata, String name, String value) {
        ParamValueMetaData param = new ParamValueMetaData();
        param.setParamName(name);
        param.setParamValue(value);
        ArrayList<ParamValueMetaData> params = webdata.getContextParams();
        if (params == null) {
            params = new ArrayList<ParamValueMetaData>();
            webdata.setContextParams(params);
        }
        params.add(param);
    }

    protected void internalDeploy(DeploymentUnit du) throws DeploymentException {
        String providers;
        StringBuffer buf;
        JBossWebMetaData webdata = (JBossWebMetaData)du.getAttachment(JBossWebMetaData.class);
        ResteasyDeploymentData resteasy = (ResteasyDeploymentData)du.getAttachment(ResteasyDeploymentData.class);
        if (resteasy == null) {
            return;
        }
        if (!resteasy.getScannedResourceClasses().isEmpty()) {
            buf = null;
            for (String resource : resteasy.getScannedResourceClasses()) {
                if (buf == null) {
                    buf = new StringBuffer();
                    buf.append(resource);
                    continue;
                }
                buf.append(",").append(resource);
            }
            String resources = buf.toString();
            this.log.info((Object)("*** Adding JAX-RS resource classes: " + resources));
            ResteasyIntegrationDeployer.setContextParameter(webdata, "resteasy.scanned.resources", resources);
        }
        if (!resteasy.getScannedProviderClasses().isEmpty()) {
            buf = null;
            for (String provider : resteasy.getScannedProviderClasses()) {
                if (buf == null) {
                    buf = new StringBuffer();
                    buf.append(provider);
                    continue;
                }
                buf.append(",").append(provider);
            }
            providers = buf.toString();
            this.log.info((Object)("*** Adding JAX-RS provider classes: " + providers));
            ResteasyIntegrationDeployer.setContextParameter(webdata, "resteasy.scanned.providers", providers);
        }
        if (!resteasy.getScannedJndiComponentResources().isEmpty()) {
            buf = null;
            for (String resource : resteasy.getScannedJndiComponentResources()) {
                if (buf == null) {
                    buf = new StringBuffer();
                    buf.append(resource);
                    continue;
                }
                buf.append(",").append(resource);
            }
            providers = buf.toString();
            this.log.info((Object)("*** Adding JAX-RS jndi component resource classes: " + providers));
            ResteasyIntegrationDeployer.setContextParameter(webdata, "resteasy.scanned.jndi.resources", providers);
        }
        boolean useScannedApplicationClass = false;
        if (resteasy.getScannedApplicationClass() != null && ResteasyIntegrationDeployer.findContextParam(webdata, "javax.ws.rs.Application") == null) {
            useScannedApplicationClass = true;
            ResteasyIntegrationDeployer.setContextParameter(webdata, "javax.ws.rs.Application", resteasy.getScannedApplicationClass().getName());
        }
        try {
            Thread.currentThread().getContextClassLoader().loadClass(CDI_INJECTOR_FACTORY_CLASS);
            boolean isVFSDU = du instanceof VFSDeploymentUnit;
            if (isVFSDU && ((VFSDeploymentUnit)du).getMetaDataFile("beans.xml") != null) {
                this.log.debug((Object)"***** Found CDI, adding injector factory class");
                ResteasyIntegrationDeployer.setContextParameter(webdata, "resteasy.injector.factory", CDI_INJECTOR_FACTORY_CLASS);
            }
        }
        catch (ClassNotFoundException ignored) {
            // empty catch block
        }
        if (!resteasy.isUnwrappedExceptionsParameterSet()) {
            ResteasyIntegrationDeployer.setContextParameter(webdata, "resteasy.unwrapped.exceptions", "javax.ejb.EJBException");
        }
        if (resteasy.hasBootClasses() || resteasy.isDispatcherCreated()) {
            return;
        }
        if (resteasy.getScannedApplicationClass() == null && resteasy.getScannedJndiComponentResources().isEmpty() && resteasy.getScannedProviderClasses().isEmpty() && resteasy.getScannedResourceClasses().isEmpty()) {
            return;
        }
        FilterMetaData filter = new FilterMetaData();
        filter.setFilterClass(Filter30Dispatcher.class.getName());
        filter.setName("Resteasy");
        filter.setAsyncSupported(true);
        FilterMappingMetaData mapping = new FilterMappingMetaData();
        mapping.setFilterName("Resteasy");
        ArrayList<String> patterns = new ArrayList<String>();
        if (useScannedApplicationClass && resteasy.getScannedApplicationClass().isAnnotationPresent(ApplicationPath.class)) {
            ApplicationPath path = resteasy.getScannedApplicationClass().getAnnotation(ApplicationPath.class);
            String pathValue = path.value().trim();
            if (!pathValue.startsWith("/")) {
                pathValue = "/" + pathValue;
            }
            String prefix = pathValue;
            pathValue = pathValue.endsWith("/") ? pathValue + "*" : pathValue + "/*";
            patterns.add(pathValue);
            ResteasyIntegrationDeployer.setContextParameter(webdata, "resteasy.servlet.mapping.prefix", prefix);
        } else {
            patterns.add("/*");
        }
        mapping.setUrlPatterns(patterns);
        if (webdata.getFilters() == null) {
            webdata.setFilters(new FiltersMetaData());
        }
        webdata.getFilters().add((MappableMetaData)filter);
        ArrayList<FilterMappingMetaData> mappings = webdata.getFilterMappings();
        if (mappings == null) {
            mappings = new ArrayList<FilterMappingMetaData>();
            webdata.setFilterMappings(mappings);
        }
        mappings.add(mapping);
    }
}

