/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets.tag.jsf;

import java.io.IOException;
import java.util.ArrayList;
import javax.el.ELContext;
import javax.el.ValueExpression;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.Validator;
import javax.faces.view.AttachedObjectHandler;
import javax.faces.view.EditableValueHolderAttachedObjectHandler;
import javax.faces.view.facelets.ComponentHandler;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.MetaRuleset;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagConfig;
import javax.faces.view.facelets.TagException;
import javax.faces.view.facelets.TagHandlerDelegate;
import javax.faces.view.facelets.ValidatorHandler;
import org.apache.myfaces.view.facelets.FaceletCompositionContext;
import org.apache.myfaces.view.facelets.compiler.FaceletsCompilerUtils;
import org.apache.myfaces.view.facelets.tag.MetaRulesetImpl;

public class ValidatorTagHandlerDelegate
extends TagHandlerDelegate
implements EditableValueHolderAttachedObjectHandler {
    public static final String VALIDATOR_ID_EXCLUSION_LIST_KEY = "org.apache.myfaces.validator.VALIDATOR_ID_EXCLUSION_LIST";
    private ValidatorHandler _delegate;
    private final boolean _wrapMode;

    public ValidatorTagHandlerDelegate(ValidatorHandler delegate) {
        this._delegate = delegate;
        this._wrapMode = FaceletsCompilerUtils.hasChildren((TagConfig)this._delegate.getValidatorConfig());
    }

    public void apply(FaceletContext ctx, UIComponent parent) throws IOException {
        if (!ComponentHandler.isNew((UIComponent)parent)) {
            return;
        }
        FaceletCompositionContext mctx = FaceletCompositionContext.getCurrentInstance(ctx);
        if (this._wrapMode) {
            String validatorId = this._delegate.getValidatorConfig().getValidatorId();
            boolean disabled = this._delegate.isDisabled(ctx);
            if (disabled) {
                boolean validatorIdAvailable;
                boolean bl = validatorIdAvailable = validatorId != null && !"".equals(validatorId);
                if (validatorIdAvailable) {
                    mctx.pushExcludedValidatorIdToStack(validatorId);
                }
                this._delegate.getValidatorConfig().getNextHandler().apply(ctx, parent);
                if (validatorIdAvailable) {
                    mctx.popExcludedValidatorIdToStack();
                }
            } else {
                boolean groupsAvailable;
                String groups = this.getValidationGroups(ctx);
                boolean bl = groupsAvailable = groups != null && !groups.matches("^[\\W,]*$");
                if (groupsAvailable) {
                    mctx.pushValidationGroupsToStack(groups);
                }
                mctx.pushEnclosingValidatorIdToStack(validatorId);
                this._delegate.getValidatorConfig().getNextHandler().apply(ctx, parent);
                mctx.popEnclosingValidatorIdToStack();
                if (groupsAvailable) {
                    mctx.popValidationGroupsToStack();
                }
            }
        } else if (parent instanceof EditableValueHolder) {
            this.applyAttachedObject(ctx.getFacesContext(), parent);
        } else if (UIComponent.isCompositeComponent((UIComponent)parent)) {
            if (this.getFor() == null) {
                throw new TagException(this._delegate.getTag(), "is nested inside a composite component but does not have a for attribute.");
            }
            mctx.addAttachedObjectHandler(parent, (AttachedObjectHandler)this._delegate);
        } else {
            throw new TagException(this._delegate.getTag(), "Parent not composite component or an instance of EditableValueHolder: " + parent);
        }
    }

    protected Validator createValidator(FaceletContext ctx) {
        if (this._delegate.getValidatorId(ctx) == null) {
            throw new TagException(this._delegate.getTag(), "Default behavior invoked of requiring a validator-id passed in the constructor, must override ValidateHandler(ValidatorConfig)");
        }
        return ctx.getFacesContext().getApplication().createValidator(this._delegate.getValidatorId(ctx));
    }

    public MetaRuleset createMetaRuleset(Class type) {
        MetaRulesetImpl metaRuleset = new MetaRulesetImpl(this._delegate.getTag(), type);
        metaRuleset.ignore("binding").ignore("disabled");
        metaRuleset.ignore("for");
        return metaRuleset;
    }

    public void applyAttachedObject(FacesContext context, UIComponent parent) {
        FaceletContext faceletContext = (FaceletContext)context.getAttributes().get("com.sun.faces.facelets.FACELET_CONTEXT");
        if (this._delegate.isDisabled(faceletContext)) {
            String validatorId = this._delegate.getValidatorConfig().getValidatorId();
            if (validatorId != null && !"".equals(validatorId)) {
                ArrayList<String> exclusionList = (ArrayList<String>)parent.getAttributes().get(VALIDATOR_ID_EXCLUSION_LIST_KEY);
                if (exclusionList == null) {
                    exclusionList = new ArrayList<String>();
                    parent.getAttributes().put(VALIDATOR_ID_EXCLUSION_LIST_KEY, exclusionList);
                }
                exclusionList.add(validatorId);
            }
        } else {
            EditableValueHolder evh = (EditableValueHolder)parent;
            ValueExpression ve = null;
            Validator v = null;
            if (this._delegate.getBinding() != null) {
                ve = this._delegate.getBinding().getValueExpression(faceletContext, Validator.class);
                v = (Validator)ve.getValue((ELContext)faceletContext);
            }
            if (v == null) {
                v = this.createValidator(faceletContext);
                if (ve != null) {
                    ve.setValue((ELContext)faceletContext, (Object)v);
                }
            }
            if (v == null) {
                throw new TagException(this._delegate.getTag(), "No Validator was created");
            }
            this._delegate.setAttributes(faceletContext, (Object)v);
            evh.addValidator(v);
        }
    }

    public String getFor() {
        TagAttribute forAttribute = this._delegate.getTagAttribute("for");
        if (forAttribute == null) {
            return null;
        }
        return forAttribute.getValue();
    }

    public String getValidationGroups(FaceletContext ctx) {
        TagAttribute attribute = this._delegate.getTagAttribute("validationGroups");
        if (attribute == null) {
            return null;
        }
        return attribute.getValue(ctx);
    }
}

