/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.management.j2ee.factory;

import java.util.HashMap;
import javax.management.Notification;
import javax.management.ObjectName;
import org.jboss.logging.Logger;
import org.jboss.management.j2ee.factory.EARModuleFactory;
import org.jboss.management.j2ee.factory.EJBModuleFactory;
import org.jboss.management.j2ee.factory.JCAResourceFactory;
import org.jboss.management.j2ee.factory.JMSResourceFactory;
import org.jboss.management.j2ee.factory.JNDIResourceFactory;
import org.jboss.management.j2ee.factory.JTAResourceFactory;
import org.jboss.management.j2ee.factory.JavaMailResourceFactory;
import org.jboss.management.j2ee.factory.ManagedObjectFactory;
import org.jboss.management.j2ee.factory.ManagedObjectFactoryMap;
import org.jboss.management.j2ee.factory.RARModuleFactory;
import org.jboss.management.j2ee.factory.RMIIIOPResourceFactory;
import org.jboss.management.j2ee.factory.ServiceModuleFactory;
import org.jboss.management.j2ee.factory.WebModuleFactory;
import org.jboss.mx.util.ObjectNameMatch;

public class DefaultManagedObjectFactoryMap
implements ManagedObjectFactoryMap {
    private static Logger log = Logger.getLogger(DefaultManagedObjectFactoryMap.class);
    private HashMap factoryMap = new HashMap();
    private HashMap patternFactoryMap = new HashMap();

    public ManagedObjectFactory getFactory(Notification createEvent) {
        ManagedObjectFactory factory = null;
        Object data = createEvent.getUserData();
        ObjectName senderName = null;
        if (data instanceof ObjectName) {
            senderName = (ObjectName)data;
        }
        if ((factory = (ManagedObjectFactory)this.factoryMap.get(senderName)) == null) {
            for (ObjectName pattern : this.patternFactoryMap.keySet()) {
                if (!ObjectNameMatch.match((ObjectName)pattern, (ObjectName)senderName)) continue;
                factory = (ManagedObjectFactory)this.patternFactoryMap.get(pattern);
            }
            if (factory == null) {
                log.debug((Object)("Failed to find factory for event: " + createEvent));
            }
        }
        return factory;
    }

    public void setSARDeployer(ObjectName name) {
        this.factoryMap.put(name, new ServiceModuleFactory());
    }

    public void setEARDeployer(ObjectName name) {
        this.factoryMap.put(name, new EARModuleFactory());
    }

    public void setEJBDeployer(ObjectName name) {
        this.factoryMap.put(name, new EJBModuleFactory());
    }

    public void setRARDeployer(ObjectName name) {
        this.factoryMap.put(name, new RARModuleFactory());
    }

    public void setCMDeployer(ObjectName name) {
        this.factoryMap.put(name, new JCAResourceFactory());
    }

    public void setWARDeployer(ObjectName name) {
        this.factoryMap.put(name, new WebModuleFactory());
    }

    public void setJavaMailResource(ObjectName name) {
        this.factoryMap.put(name, new JavaMailResourceFactory());
    }

    public void setJMSResource(ObjectName name) {
        this.factoryMap.put(name, new JMSResourceFactory());
    }

    public void setJNDIResource(ObjectName name) {
        this.factoryMap.put(name, new JNDIResourceFactory());
    }

    public void setJTAResource(ObjectName name) {
        this.factoryMap.put(name, new JTAResourceFactory());
    }

    public void setRMI_IIOPResource(ObjectName name) {
        this.factoryMap.put(name, new RMIIIOPResourceFactory());
    }
}

