/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.management.j2ee.deployers;

import java.net.InetAddress;
import java.util.Set;
import javax.management.JMException;
import javax.management.MBeanException;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.jboss.logging.Logger;
import org.jboss.management.j2ee.J2EEDomain;
import org.jboss.management.j2ee.J2EEServer;
import org.jboss.management.j2ee.JVM;
import org.jboss.management.j2ee.deployers.LocalJBossServerDomainMBean;
import org.jboss.management.j2ee.factory.DefaultManagedObjectFactoryMap;
import org.jboss.management.j2ee.factory.ManagedObjectFactory;
import org.jboss.management.j2ee.factory.ManagedObjectFactoryMap;
import org.jboss.system.ServiceControllerMBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalJBossServerDomain
implements NotificationListener,
LocalJBossServerDomainMBean,
MBeanRegistration {
    private static final Logger log = Logger.getLogger(LocalJBossServerDomain.class);
    private MBeanServer server;
    private ObjectName serviceName;
    private ObjectName jndiService;
    private ObjectName jtaService;
    private ObjectName userTxService;
    private ObjectName mailService;
    private ObjectName rmiiiopService;
    private ObjectName jndiBindingService;
    private ManagedObjectFactoryMap managedObjFactoryMap;
    private Class<?> managedObjFactoryMapClass = DefaultManagedObjectFactoryMap.class;

    @Override
    public ObjectName getJNDIService() {
        return this.jndiService;
    }

    @Override
    public void setJNDIService(ObjectName name) {
        this.jndiService = name;
    }

    @Override
    public ObjectName getJTAService() {
        return this.jtaService;
    }

    @Override
    public void setJTAService(ObjectName name) {
        this.jtaService = name;
    }

    @Override
    public ObjectName getMailService() {
        return this.mailService;
    }

    @Override
    public void setMailService(ObjectName name) {
        this.mailService = name;
    }

    @Override
    public ObjectName getUserTransactionService() {
        return this.userTxService;
    }

    @Override
    public void setUserTransactionService(ObjectName name) {
        this.userTxService = name;
    }

    @Override
    public ObjectName getRMI_IIOPService() {
        return this.rmiiiopService;
    }

    @Override
    public void setRMI_IIOPService(ObjectName name) {
        this.rmiiiopService = name;
    }

    @Override
    public ObjectName getJndiBindingService() {
        return this.jndiBindingService;
    }

    @Override
    public void setJndiBindingService(ObjectName name) {
        this.jndiBindingService = name;
    }

    @Override
    public Class<?> getManagementObjFactoryMapClass() {
        return this.managedObjFactoryMapClass;
    }

    @Override
    public void setManagementObjFactoryMapClass(Class<?> cls) {
        this.managedObjFactoryMapClass = cls;
    }

    @Override
    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.server = server;
        this.serviceName = name;
        return name;
    }

    @Override
    public void postRegister(Boolean registrationDone) {
        if (registrationDone.booleanValue()) {
            try {
                this.createService();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void preDeregister() throws Exception {
        this.destroyService();
    }

    @Override
    public void postDeregister() {
    }

    @Override
    public void handleNotification(Notification msg, Object handback) {
        if (this.managedObjFactoryMap == null || this.server == null) {
            return;
        }
        log.debug((Object)("handleNotification: " + msg));
        String type = msg.getType();
        Object userData = msg.getUserData();
        try {
            ManagedObjectFactory factory;
            if (type.equals("org.jboss.system.ServiceMBean.create")) {
                ManagedObjectFactory factory2 = this.managedObjFactoryMap.getFactory(msg);
                if (factory2 != null) {
                    factory2.create(this.server, userData);
                }
            } else if (type.equals("org.jboss.system.ServiceMBean.destroy") && (factory = this.managedObjFactoryMap.getFactory(msg)) != null) {
                factory.destroy(this.server, userData);
            }
        }
        catch (Throwable t) {
            log.debug((Object)"Failed to handle event", t);
        }
    }

    public String toString() {
        return "LocalJBossServerDomain { " + super.toString() + " }";
    }

    protected void createService() throws Exception {
        this.setupJ2EEMBeans();
        this.registerWithController();
        this.populateFactoryMap();
    }

    protected void destroyService() throws Exception {
        this.cleanupLeftoverMBeans();
        this.unregisterWithController();
    }

    private void populateFactoryMap() throws Exception {
        this.managedObjFactoryMap = (ManagedObjectFactoryMap)this.managedObjFactoryMapClass.newInstance();
        this.managedObjFactoryMap.setJNDIResource(this.jndiService);
        this.managedObjFactoryMap.setJTAResource(this.jtaService);
        this.managedObjFactoryMap.setJTAResource(this.userTxService);
        this.managedObjFactoryMap.setJavaMailResource(this.mailService);
        this.managedObjFactoryMap.setRMI_IIOPResource(this.rmiiiopService);
    }

    private void setupJ2EEMBeans() {
        try {
            String version;
            String vendor;
            log.debug((Object)"setupJ2EEMBeans(), create J2EEServer instance");
            Package pkg = Package.getPackage("org.jboss");
            if (pkg != null) {
                vendor = pkg.getSpecificationVendor();
                version = pkg.getImplementationVersion();
            } else {
                vendor = "JBoss";
                version = "Unknown";
            }
            J2EEDomain serverDomain = new J2EEDomain(this.serviceName.getDomain());
            ObjectName domain = serverDomain.getObjectName();
            this.server.registerMBean(serverDomain, domain);
            J2EEServer j2eeServer = new J2EEServer("Local", domain, vendor, version);
            ObjectName lServer = j2eeServer.getObjectName();
            this.server.registerMBean(j2eeServer, lServer);
            String hostName = "localhost";
            try {
                InetAddress lLocalHost = InetAddress.getLocalHost();
                hostName = lLocalHost.getHostName();
            }
            catch (Exception e) {
                // empty catch block
            }
            String vmVendor = System.getProperty("java.vendor");
            String vmVersion = System.getProperty("java.version");
            String name = vmVendor + " " + vmVersion;
            JVM jvm = new JVM(name, lServer, vmVersion, vmVendor, hostName);
            ObjectName jvmName = jvm.getObjectName();
            this.server.registerMBean(jvm, jvmName);
        }
        catch (JMException jme) {
            log.debug((Object)"setupJ2EEMBeans - unexpected JMException", (Throwable)jme);
        }
        catch (Exception e) {
            log.debug((Object)"setupJ2EEMBeans - unexpected exception", (Throwable)e);
        }
    }

    private void registerWithController() {
        try {
            this.server.addNotificationListener(ServiceControllerMBean.OBJECT_NAME, this, null, null);
            log.debug((Object)("Registered as listener of: " + ServiceControllerMBean.OBJECT_NAME));
        }
        catch (JMException jme) {
            log.debug((Object)"unexpected exception", (Throwable)jme);
        }
        catch (Exception e) {
            log.debug((Object)"unexpected exception", (Throwable)e);
        }
    }

    private void unregisterWithController() {
        try {
            this.server.removeNotificationListener(ServiceControllerMBean.OBJECT_NAME, this);
            log.debug((Object)("UNRegistered as listener of: " + ServiceControllerMBean.OBJECT_NAME));
        }
        catch (JMException jme) {
            log.debug((Object)"unexpected exception", (Throwable)jme);
        }
        catch (Exception e) {
            log.debug((Object)"unexpected exception", (Throwable)e);
        }
    }

    private void cleanupLeftoverMBeans() throws Exception {
        String domain = this.serviceName.getDomain();
        ObjectName domainName = new ObjectName(domain + ":*");
        Set<ObjectName> domainNames = this.server.queryNames(domainName, null);
        log.debug((Object)("Found " + domainNames.size() + " domain mbeans"));
        for (ObjectName name : domainNames) {
            try {
                ObjectName oname = name;
                if (oname.equals(this.serviceName)) continue;
                this.server.unregisterMBean(oname);
            }
            catch (MBeanException ignore) {}
        }
    }
}

