/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.management.j2ee.deployers;

import java.util.HashSet;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.management.j2ee.JMSResource;
import org.jboss.management.j2ee.deployers.AbstractJSR77Deployer;
import org.jboss.system.metadata.ServiceMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JMSResourceJSR77Deployer
extends AbstractJSR77Deployer<ServiceMetaData> {
    private Set<String> jmsCodes;

    public JMSResourceJSR77Deployer() {
        super(ServiceMetaData.class);
        this.setComponentsOnly(true);
    }

    protected boolean isJMSServiceMetaData(ServiceMetaData metaData) {
        if (this.jmsCodes == null) {
            this.jmsCodes = new HashSet<String>();
            this.jmsCodes.add("org.jboss.jms.server.destination.QueueService");
            this.jmsCodes.add("org.jboss.jms.server.destination.TopicService");
        }
        String code = metaData.getCode();
        return this.jmsCodes.contains(code);
    }

    @Override
    protected void deployJsr77(MBeanServer server, DeploymentUnit unit, ServiceMetaData metaData) throws Throwable {
        if (this.isJMSServiceMetaData(metaData)) {
            ObjectName serviceName = metaData.getObjectName();
            JMSResource.create(server, "LocalJMS", serviceName);
        }
    }

    @Override
    protected void undeployJsr77(MBeanServer server, DeploymentUnit unit, ServiceMetaData metaData) {
        if (this.isJMSServiceMetaData(metaData)) {
            JMSResource.destroy(server, "LocalJMS");
        }
    }

    public void setJmsCodes(Set<String> jmsCodes) {
        this.jmsCodes = jmsCodes;
    }
}

