/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.reflect.plugins.introspection;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ReflectPermission;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.jboss.reflect.plugins.FieldInfoImpl;
import org.jboss.reflect.plugins.introspection.ReflectionUtils;
import org.jboss.reflect.spi.AnnotationValue;
import org.jboss.reflect.spi.ClassInfo;
import org.jboss.reflect.spi.TypeInfo;

public class ReflectFieldInfoImpl
extends FieldInfoImpl {
    private static final long serialVersionUID = 2L;
    private static Permission accessCheck = new ReflectPermission("suppressAccessChecks");
    protected volatile transient Field field;

    public ReflectFieldInfoImpl() {
    }

    public ReflectFieldInfoImpl(AnnotationValue[] annotations, String name, TypeInfo type, int modifiers, ClassInfo declaring) {
        super(annotations, name, type, modifiers, declaring);
    }

    public void setField(Field field) {
        if (field != null) {
            this.accessCheck(Modifier.isPublic(field.getModifiers()));
        }
        this.field = field;
        if (!this.isPublic() && field != null) {
            this.setAccessible();
        }
    }

    public Field getField() {
        this.accessCheck();
        if (this.field == null) {
            this.initField();
        }
        return this.field;
    }

    protected final void accessCheck() {
        this.accessCheck(this.isPublic());
    }

    protected final void accessCheck(boolean isPublic) {
        SecurityManager sm;
        if (!isPublic && (sm = System.getSecurityManager()) != null) {
            sm.checkPermission(accessCheck);
        }
    }

    public Object get(Object target) throws Throwable {
        if (this.field == null) {
            this.initField();
        }
        this.accessCheck();
        return ReflectionUtils.getField(this.field, target);
    }

    public Object set(Object target, Object value) throws Throwable {
        if (this.field == null) {
            this.initField();
        }
        this.accessCheck();
        return ReflectionUtils.setField(this.field, target, value);
    }

    private void setAccessible() {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            this.field.setAccessible(true);
        } else {
            AccessController.doPrivileged(new SetAccessible());
        }
    }

    private synchronized void initField() {
        if (this.field != null) {
            return;
        }
        try {
            this.setField(this.findField());
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    private Field findField() throws NoSuchFieldException {
        if (System.getSecurityManager() == null) {
            return ReflectionUtils.findExactField(this.getDeclaringClass().getType(), this.name);
        }
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Field>(){

                @Override
                public Field run() throws Exception {
                    return ReflectionUtils.findExactField(ReflectFieldInfoImpl.this.getDeclaringClass().getType(), ReflectFieldInfoImpl.this.name);
                }
            });
        }
        catch (PrivilegedActionException e) {
            if (e.getCause() instanceof NoSuchFieldException) {
                throw (NoSuchFieldException)e.getCause();
            }
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new RuntimeException(e.getCause());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SetAccessible
    implements PrivilegedAction<Object> {
        private SetAccessible() {
        }

        @Override
        public Object run() {
            ReflectFieldInfoImpl.this.field.setAccessible(true);
            return null;
        }
    }
}

