/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.reflect.plugins.bytecode;

import javassist.bytecode.SignatureAttribute;

abstract class BytecodeTypeVariableSpy {
    BytecodeTypeVariableSpy() {
    }

    static BytecodeTypeVariableSpy createForBehavior(SignatureAttribute.ClassSignature classSig, SignatureAttribute.MethodSignature sig) {
        return new MethodTypeVariable(classSig, sig);
    }

    static BytecodeTypeVariableSpy createForClass(SignatureAttribute.ClassSignature sig) {
        return new ClassTypeVariable(sig);
    }

    static BytecodeTypeVariableSpy createForField(SignatureAttribute.ClassSignature sig) {
        return new ClassTypeVariable(sig);
    }

    abstract SignatureAttribute.Type getTypeBound(SignatureAttribute.TypeVariable var1);

    private static SignatureAttribute.Type getTypeFromTypeParameters(SignatureAttribute.TypeVariable tv, SignatureAttribute.TypeParameter[] parameters) {
        if (parameters == null) {
            return null;
        }
        for (int i = 0; i < parameters.length; ++i) {
            if (!parameters[i].getName().equals(tv.getName())) continue;
            SignatureAttribute.ObjectType type = parameters[i].getClassBound();
            if (type != null) {
                return type;
            }
            SignatureAttribute.ObjectType[] types = parameters[i].getInterfaceBound();
            if (types == null || types.length <= 0) break;
            return types[0];
        }
        return null;
    }

    private static class ClassTypeVariable
    extends BytecodeTypeVariableSpy {
        private final SignatureAttribute.ClassSignature sig;

        public ClassTypeVariable(SignatureAttribute.ClassSignature sig) {
            this.sig = sig;
        }

        SignatureAttribute.Type getTypeBound(SignatureAttribute.TypeVariable tv) {
            SignatureAttribute.Type type = BytecodeTypeVariableSpy.getTypeFromTypeParameters(tv, this.sig.getParameters());
            if (type != null) {
                return type;
            }
            throw new IllegalStateException("No type parameter found called " + tv.getName() + " in " + this.sig);
        }
    }

    private static class MethodTypeVariable
    extends BytecodeTypeVariableSpy {
        protected final SignatureAttribute.ClassSignature classSig;
        private final SignatureAttribute.MethodSignature sig;

        MethodTypeVariable(SignatureAttribute.ClassSignature classSig, SignatureAttribute.MethodSignature sig) {
            this.classSig = classSig;
            this.sig = sig;
        }

        SignatureAttribute.Type getTypeBound(SignatureAttribute.TypeVariable tv) {
            SignatureAttribute.Type type = BytecodeTypeVariableSpy.getTypeFromTypeParameters(tv, this.sig.getTypeParameters());
            if (type != null) {
                return type;
            }
            type = BytecodeTypeVariableSpy.getTypeFromTypeParameters(tv, this.classSig.getParameters());
            if (type != null) {
                return type;
            }
            throw new IllegalStateException("No type parameter found called " + tv.getName() + " in " + this.sig + " or in " + this.classSig);
        }
    }
}

