/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jbossas5.helper;

import java.util.jar.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum JBossProductType {
    AS("JBoss AS", "JBoss Application Server", "default"),
    EAP("JBoss EAP", "JBoss Enterprise Application Platform", "default"),
    EWP("JBoss EWP", "JBoss Enterprise Web Platform", "default"),
    SOA("JBoss SOA-P", "JBoss Enterprise SOA Platform", "default");

    public final String NAME;
    public final String DESCRIPTION;
    public final String DEFAULT_CONFIG_NAME;
    private static final String EAP_IMPLEMENTATION_TITLE = "JBoss [EAP]";
    private static final String EWP_IMPLEMENTATION_TITLE = "JBoss [EWP]";
    private static final String SOA_IMPLEMENTATION_TITLE = "JBoss [SOA]";

    private JBossProductType(String name, String description, String defaultConfigName) {
        this.NAME = name;
        this.DESCRIPTION = description;
        this.DEFAULT_CONFIG_NAME = defaultConfigName;
    }

    public static JBossProductType determineJBossProductType(Attributes attributes) {
        String implementationTitle;
        JBossProductType result = AS;
        String string = implementationTitle = attributes != null ? attributes.getValue(Attributes.Name.IMPLEMENTATION_TITLE) : null;
        if (implementationTitle != null) {
            if (implementationTitle.equalsIgnoreCase(EAP_IMPLEMENTATION_TITLE)) {
                result = EAP;
            } else if (implementationTitle.equalsIgnoreCase(EWP_IMPLEMENTATION_TITLE)) {
                result = EWP;
            } else if (implementationTitle.equalsIgnoreCase(SOA_IMPLEMENTATION_TITLE)) {
                result = SOA;
            }
        }
        return result;
    }

    public String toString() {
        return this.NAME;
    }
}

