/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.extensions.wsrm.protocol.spec200502;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.jboss.ws.extensions.wsrm.api.RMException;
import org.jboss.ws.extensions.wsrm.common.serialization.RMAbstractSerializable;
import org.jboss.ws.extensions.wsrm.protocol.RMProvider;
import org.jboss.ws.extensions.wsrm.protocol.spec200502.RMProviderImpl;
import org.jboss.ws.extensions.wsrm.protocol.spi.RMSequenceAcknowledgement;

final class RMSequenceAcknowledgementImpl
extends RMAbstractSerializable
implements RMSequenceAcknowledgement {
    private static final RMProvider PROVIDER = RMProviderImpl.getInstance();
    private final List<Long> nacks = new LinkedList<Long>();
    private final List<RMSequenceAcknowledgement.RMAcknowledgementRange> acknowledgementRanges = new LinkedList<RMSequenceAcknowledgement.RMAcknowledgementRange>();
    private String identifier;

    RMSequenceAcknowledgementImpl() {
    }

    @Override
    public void addAcknowledgementRange(RMSequenceAcknowledgement.RMAcknowledgementRange newAcknowledgementRange) {
        if (newAcknowledgementRange == null || !(newAcknowledgementRange instanceof AcknowledgementRangeImpl)) {
            throw new IllegalArgumentException();
        }
        if (this.nacks.size() != 0) {
            throw new IllegalStateException("There are already some nacks specified");
        }
        if (newAcknowledgementRange.getLower() == 0L || newAcknowledgementRange.getUpper() == 0L) {
            throw new IllegalArgumentException("Both, lower and upper values must be specified");
        }
        for (RMSequenceAcknowledgement.RMAcknowledgementRange alreadyAccepted : this.acknowledgementRanges) {
            RMSequenceAcknowledgementImpl.checkOverlap(alreadyAccepted, newAcknowledgementRange);
        }
        this.acknowledgementRanges.add(newAcknowledgementRange);
    }

    @Override
    public void addNack(long messageNumber) {
        if (this.acknowledgementRanges.size() != 0) {
            throw new IllegalStateException("There are already some acknowledgement ranges specified");
        }
        if (this.nacks.contains(messageNumber)) {
            throw new IllegalArgumentException("There is already nack with value " + messageNumber + " specified");
        }
        this.nacks.add(messageNumber);
    }

    @Override
    public List<RMSequenceAcknowledgement.RMAcknowledgementRange> getAcknowledgementRanges() {
        return Collections.unmodifiableList(this.acknowledgementRanges);
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public List<Long> getNacks() {
        return Collections.unmodifiableList(this.nacks);
    }

    @Override
    public boolean isFinal() {
        return false;
    }

    @Override
    public boolean isNone() {
        return false;
    }

    @Override
    public RMSequenceAcknowledgement.RMAcknowledgementRange newAcknowledgementRange() {
        return new AcknowledgementRangeImpl();
    }

    @Override
    public void setFinal() {
    }

    @Override
    public void setIdentifier(String identifier) {
        if (identifier == null || identifier.trim().equals("")) {
            throw new IllegalArgumentException("Identifier cannot be null nor empty string");
        }
        if (this.identifier != null) {
            throw new UnsupportedOperationException("Value already set, cannot be overriden");
        }
        this.identifier = identifier;
    }

    @Override
    public void setNone() {
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.identifier == null ? 0 : this.identifier.hashCode());
        result = 31 * result + (this.nacks == null ? 0 : ((Object)this.nacks).hashCode());
        result = 31 * result + (this.acknowledgementRanges == null ? 0 : ((Object)this.acknowledgementRanges).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RMSequenceAcknowledgementImpl)) {
            return false;
        }
        RMSequenceAcknowledgementImpl other = (RMSequenceAcknowledgementImpl)obj;
        if (this.acknowledgementRanges == null ? other.acknowledgementRanges != null : !((Object)this.acknowledgementRanges).equals(other.acknowledgementRanges)) {
            return false;
        }
        if (this.identifier == null ? other.identifier != null : !this.identifier.equals(other.identifier)) {
            return false;
        }
        return !(this.nacks == null ? other.nacks != null : !((Object)this.nacks).equals(other.nacks));
    }

    @Override
    public RMProvider getProvider() {
        return PROVIDER;
    }

    @Override
    public void validate() {
        if (this.identifier == null) {
            throw new RMException("Identifier not set");
        }
        if (this.acknowledgementRanges.size() == 0 && this.nacks.size() == 0) {
            throw new RMException("AcknowledgementRange or Nack must be set");
        }
    }

    private static void checkOverlap(RMSequenceAcknowledgement.RMAcknowledgementRange currentRange, RMSequenceAcknowledgement.RMAcknowledgementRange newRange) {
        if (currentRange.getLower() <= newRange.getLower() && newRange.getLower() <= currentRange.getUpper()) {
            throw new IllegalArgumentException("Overlap detected: " + currentRange + " vs. " + newRange);
        }
        if (currentRange.getLower() <= newRange.getUpper() && newRange.getUpper() <= currentRange.getUpper()) {
            throw new IllegalArgumentException("Overlap detected: " + currentRange + " vs. " + newRange);
        }
    }

    private static class AcknowledgementRangeImpl
    implements RMSequenceAcknowledgement.RMAcknowledgementRange {
        private long lower;
        private long upper;

        private AcknowledgementRangeImpl() {
        }

        @Override
        public long getLower() {
            return this.lower;
        }

        @Override
        public long getUpper() {
            return this.upper;
        }

        @Override
        public void setLower(long lower) {
            if (lower <= 0L) {
                throw new IllegalArgumentException("Value must be greater than 0");
            }
            if (this.lower > 0L) {
                throw new UnsupportedOperationException("Value already set, cannot be overriden");
            }
            if (this.upper > 0L && lower > this.upper) {
                throw new IllegalArgumentException("Value must be lower or equal to " + this.upper);
            }
            this.lower = lower;
        }

        @Override
        public void setUpper(long upper) {
            if (upper <= 0L) {
                throw new IllegalArgumentException("Value must be greater than 0");
            }
            if (this.upper > 0L) {
                throw new UnsupportedOperationException("Value already set, cannot be overriden");
            }
            if (this.lower > 0L && this.lower > upper) {
                throw new IllegalArgumentException("Value must be greater or equal to " + this.lower);
            }
            this.upper = upper;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (int)(this.lower ^ this.lower >>> 32);
            result = 31 * result + (int)(this.upper ^ this.upper >>> 32);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof AcknowledgementRangeImpl)) {
                return false;
            }
            AcknowledgementRangeImpl other = (AcknowledgementRangeImpl)obj;
            if (this.lower != other.lower) {
                return false;
            }
            return this.upper == other.upper;
        }

        public String toString() {
            return "<" + this.lower + "; " + this.upper + ">";
        }
    }
}

