/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.Serializable;
import java.net.InetAddress;
import org.jgroups.Event;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.ReceiverAdapter;
import org.jgroups.protocols.BARRIER;
import org.jgroups.protocols.FD_ALL;
import org.jgroups.protocols.FD_SOCK;
import org.jgroups.protocols.FRAG2;
import org.jgroups.protocols.MERGE2;
import org.jgroups.protocols.MFC;
import org.jgroups.protocols.PING;
import org.jgroups.protocols.SHARED_LOOPBACK;
import org.jgroups.protocols.TP;
import org.jgroups.protocols.UDP;
import org.jgroups.protocols.UFC;
import org.jgroups.protocols.UNICAST2;
import org.jgroups.protocols.VERIFY_SUSPECT;
import org.jgroups.protocols.pbcast.GMS;
import org.jgroups.protocols.pbcast.NAKACK;
import org.jgroups.protocols.pbcast.STABLE;
import org.jgroups.stack.Protocol;
import org.jgroups.stack.ProtocolStack;
import org.jgroups.util.Util;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, sequential=true)
public class ProgrammaticApiTest {
    JChannel c1;
    JChannel c2;

    @BeforeMethod
    void init() {
        this.c1 = new JChannel(false);
        this.c1.setName("A");
        this.c2 = new JChannel(false);
        this.c2.setName("B");
    }

    @AfterMethod
    void destroy() {
        Util.close(this.c2, this.c1);
    }

    public void testChannelCreation() throws Exception {
        MyReceiver receiver = new MyReceiver(null);
        this.c1.setReceiver(receiver);
        ProtocolStack stack = new ProtocolStack();
        this.c1.setProtocolStack(stack);
        stack.addProtocol(new SHARED_LOOPBACK()).addProtocol(new MockProtocol1()).addProtocol(new MockProtocol2());
        stack.init();
        this.c1.connect("demo");
        TP transport = stack.getTransport();
        ((Protocol)transport).up(new Event(1, new Message(null, Util.createRandomAddress(), (Serializable)((Object)"hello world"))));
        assert (receiver.getNumMsgsReceived() == 1);
    }

    public void testSharedTransport() throws Exception {
        int i;
        ProtocolStack stack1 = new ProtocolStack();
        ProtocolStack stack2 = new ProtocolStack();
        this.c1.setProtocolStack(stack1);
        this.c2.setProtocolStack(stack2);
        MyReceiver receiver1 = new MyReceiver("A");
        MyReceiver receiver2 = new MyReceiver("B");
        UDP shared_transport = (UDP)new UDP().setValue("bind_addr", InetAddress.getByName("192.168.1.5")).setValue("singleton_name", "shared");
        stack1.addProtocol(shared_transport).addProtocols(ProgrammaticApiTest.createProtocols());
        stack2.addProtocol(shared_transport).addProtocols(ProgrammaticApiTest.createProtocols());
        stack1.init();
        stack2.init();
        this.c1.setReceiver(receiver1);
        this.c2.setReceiver(receiver2);
        this.c1.connect("cluster-one");
        this.c2.connect("cluster-two");
        for (i = 0; i < 10; ++i) {
            this.c1.send(new Message(null, null, (Serializable)((Object)("hello-" + i))));
        }
        for (i = 0; i < 5; ++i) {
            this.c2.send(new Message(null, null, (Serializable)((Object)("hello-" + i))));
        }
        for (i = 0; i < 20 && (receiver1.getNumMsgsReceived() != 10 || receiver2.getNumMsgsReceived() != 5); ++i) {
            Util.sleep(500L);
        }
        assert (receiver1.getNumMsgsReceived() == 10) : "num msgs for A: " + receiver1.getNumMsgsReceived() + " (expected=10)";
        assert (receiver2.getNumMsgsReceived() == 5) : "num msgs for B: " + receiver1.getNumMsgsReceived() + " (expected=5)";
    }

    static Protocol[] createProtocols() {
        return new Protocol[]{new PING(), new MERGE2(), new FD_SOCK(), new FD_ALL().setValue("timeout", 12000).setValue("interval", 3000), new VERIFY_SUSPECT(), new BARRIER(), new NAKACK(), new UNICAST2(), new STABLE(), new GMS(), new UFC(), new MFC(), new FRAG2()};
    }

    static class MyReceiver
    extends ReceiverAdapter {
        int num_msgs_received = 0;
        final String name;

        public MyReceiver(String name) {
            this.name = name;
        }

        public int getNumMsgsReceived() {
            return this.num_msgs_received;
        }

        @Override
        public void receive(Message msg) {
            System.out.println((this.name != null ? "[" + this.name + "]" : "") + "<< " + msg.getObject());
            ++this.num_msgs_received;
        }
    }

    protected static class MockProtocol2
    extends Protocol {
        protected MockProtocol2() {
        }
    }

    protected static class MockProtocol1
    extends Protocol {
        protected MockProtocol1() {
        }
    }
}

