/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import org.jgroups.logging.Log;
import org.jgroups.logging.LogFactory;
import org.testng.annotations.Test;

@Test
public class LogTest {
    static final Log log = LogFactory.getLog(LogTest.class);
    final boolean trace = log.isTraceEnabled();
    final int NUM = 10000;
    long start;
    long stop;
    long diff;

    public void testSpeedWithSingleTraceStatement() {
        this.start = System.currentTimeMillis();
        for (int i = 0; i < 10000; ++i) {
            if (!log.isTraceEnabled()) continue;
            log.trace("this is log statement number " + i + " from Bela");
        }
        this.stop = System.currentTimeMillis();
        System.out.println("took " + (this.stop - this.start) + "ms for " + 10000 + " log statements");
    }

    public void testSpeedWithSingleTraceStatementLogIsTracePreset() {
        this.start = System.currentTimeMillis();
        for (int i = 0; i < 10000; ++i) {
            if (!this.trace) continue;
            log.trace("this is log statement number " + i + " from Bela");
        }
        this.stop = System.currentTimeMillis();
        System.out.println("took " + (this.stop - this.start) + "ms for " + 10000 + " log statements");
    }

    public void testSpeedWithTwoTraceStatements() {
        this.start = System.currentTimeMillis();
        for (int i = 0; i < 10000; ++i) {
            if (!log.isTraceEnabled()) continue;
            log.trace("this is log statement number " + i);
            log.trace(" from Bela");
        }
        this.stop = System.currentTimeMillis();
        System.out.println("took " + (this.stop - this.start) + "ms for " + 10000 + " log statements");
    }
}

