/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.ChannelException;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.ReceiverAdapter;
import org.jgroups.View;
import org.jgroups.annotations.Experimental;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.ManagedOperation;
import org.jgroups.annotations.Property;
import org.jgroups.annotations.Unsupported;
import org.jgroups.stack.Protocol;
import org.jgroups.util.TimeScheduler;
import org.jgroups.util.Util;

@Experimental
@Unsupported
@MBean(description="RELAY protocol")
public class RELAY
extends Protocol {
    @Property(description="Properties of the bridge cluster (e.g. tcp.xml)")
    protected String props = null;
    @Property(description="Name of the bridge cluster")
    protected String cluster_name = "bridge-cluster";
    @Property(description="If true, messages are relayed asynchronously, ie. via submission of a task to the timer thread pool")
    protected boolean async = false;
    @Property(description="If set to false, don't perform relaying. Used e.g. for backup clusters; unidirectional replication from one cluster to another, but not back. Can be changed at runtime")
    protected boolean relay = true;
    protected Address local_addr;
    @ManagedAttribute
    protected volatile boolean is_coord = false;
    protected JChannel ch;
    protected TimeScheduler timer;

    @ManagedOperation
    public void setRelay(boolean relay) {
        this.relay = relay;
    }

    @Override
    public void init() throws Exception {
        this.timer = this.getTransport().getTimer();
    }

    @Override
    public void stop() {
        Util.close((Channel)this.ch);
    }

    @Override
    public Object down(Event evt) {
        switch (evt.getType()) {
            case 6: {
                this.handleView((View)evt.getArg());
                break;
            }
            case 4: {
                Util.close((Channel)this.ch);
                break;
            }
            case 8: {
                this.local_addr = (Address)evt.getArg();
            }
        }
        return this.down_prot.down(evt);
    }

    @Override
    public Object up(Event evt) {
        switch (evt.getType()) {
            case 1: {
                boolean multicast;
                if (!this.is_coord || !this.relay || this.ch == null) break;
                Message msg = (Message)evt.getArg();
                Address dest = msg.getDest();
                RelayHeader hdr = (RelayHeader)msg.getHeader(this.getId());
                boolean bl = multicast = dest == null || dest.isMulticastAddress();
                if (!multicast || hdr != null) break;
                this.relay(msg);
                break;
            }
            case 6: {
                this.handleView((View)evt.getArg());
            }
        }
        return this.up_prot.up(evt);
    }

    protected void handleView(View view) {
        if (this.is_coord) {
            if (!Util.isCoordinator(view, this.local_addr)) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace("I'm not coordinator anymore, closing the channel");
                }
                Util.close((Channel)this.ch);
                this.ch = null;
            }
        } else if (Util.isCoordinator(view, this.local_addr)) {
            this.is_coord = true;
            try {
                if (this.log.isTraceEnabled()) {
                    this.log.trace("I'm the coordinator, creating a channel (props=" + this.props + ", cluster_name=" + this.cluster_name + ")");
                }
                this.ch = new JChannel(this.props);
                this.ch.setOpt(3, false);
                this.ch.connect(this.cluster_name);
                this.ch.setReceiver(new Receiver());
            }
            catch (ChannelException e) {
                this.log.error("failed creating channel (props=" + this.props + ")", e);
            }
        }
    }

    protected void relay(Message msg) {
        final Message copy = msg.copy(true, false);
        if (this.async) {
            this.timer.execute(new Runnable(){

                @Override
                public void run() {
                    RELAY.this._relay(copy);
                }
            });
        } else {
            this._relay(copy);
        }
    }

    protected void _relay(Message msg) {
        try {
            if (this.log.isTraceEnabled()) {
                this.log.trace("relaying message from " + msg.getSrc());
            }
            this.ch.send(msg);
        }
        catch (Throwable e) {
            this.log.error("failed relaying message " + msg, e);
        }
    }

    public static class RelayHeader
    extends Header {
        @Override
        public int size() {
            return 0;
        }

        @Override
        public void writeTo(DataOutputStream out) throws IOException {
        }

        @Override
        public void readFrom(DataInputStream in) throws IOException, IllegalAccessException, InstantiationException {
        }
    }

    protected class Receiver
    extends ReceiverAdapter {
        protected Receiver() {
        }

        @Override
        public void receive(Message msg) {
            Message copy = msg.copy(true, false);
            copy.putHeader(RELAY.this.getId(), new RelayHeader());
            copy.setSrc(RELAY.this.local_addr);
            if (RELAY.this.log.isTraceEnabled()) {
                RELAY.this.log.trace("received msg from " + msg.getSrc() + ", passing down the stack with dest=" + copy.getDest() + " and src=" + RELAY.this.local_addr);
            }
            RELAY.this.down_prot.down(new Event(1, copy));
        }
    }
}

