/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import bsh.EvalError;
import bsh.Interpreter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import org.jgroups.annotations.Experimental;
import org.jgroups.annotations.Property;
import org.jgroups.annotations.Unsupported;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Util;

@Experimental
@Unsupported
public class BSH
extends Protocol
implements Runnable {
    protected Interpreter interpreter = null;
    protected ServerSocket srv_sock;
    protected Thread acceptor;
    protected final List<Socket> sockets = new ArrayList<Socket>();
    @Property(description="Port on which the interpreter should listen for requests. 0 is an ephemeral port")
    int bind_port = 0;

    @Override
    public void start() throws Exception {
        this.srv_sock = Util.createServerSocket(this.getSocketFactory(), "jgroups.bsh.srv_sock", this.bind_port);
        this.log.info("Server socket listening at " + this.srv_sock.getLocalSocketAddress());
        this.acceptor = new Thread(this);
        this.acceptor.start();
    }

    @Override
    public void stop() {
        Util.close(this.srv_sock);
        if (this.acceptor != null && this.acceptor.isAlive()) {
            this.acceptor.interrupt();
        }
        Util.sleep(500L);
        if (!this.sockets.isEmpty()) {
            for (Socket sock : this.sockets) {
                Util.close(sock);
            }
        }
    }

    @Override
    public void run() {
        while (this.srv_sock != null && !this.srv_sock.isClosed()) {
            try {
                final Socket sock = this.srv_sock.accept();
                this.sockets.add(sock);
                this.createInterpreter();
                new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            InputStream input = sock.getInputStream();
                            OutputStream out = sock.getOutputStream();
                            BufferedReader reader = new BufferedReader(new InputStreamReader(input));
                            while (!sock.isClosed()) {
                                String line = reader.readLine();
                                if (line == null || line.length() == 0) continue;
                                try {
                                    Object retval = BSH.this.interpreter.eval(line);
                                    if (retval != null) {
                                        String rsp = retval.toString();
                                        byte[] buf = rsp.getBytes();
                                        out.write(buf, 0, buf.length);
                                        out.flush();
                                    }
                                    if (!BSH.this.log.isTraceEnabled()) continue;
                                    BSH.this.log.trace(line);
                                    if (retval == null) continue;
                                    BSH.this.log.trace(retval);
                                }
                                catch (EvalError evalError) {
                                    evalError.printStackTrace();
                                }
                            }
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        finally {
                            Util.close(sock);
                            BSH.this.sockets.remove(sock);
                        }
                    }
                }.start();
            }
            catch (IOException iOException) {}
        }
    }

    synchronized void createInterpreter() {
        if (this.interpreter == null) {
            this.interpreter = new Interpreter();
            try {
                this.interpreter.set("bsh_prot", (Object)this);
            }
            catch (EvalError evalError) {
                // empty catch block
            }
        }
    }
}

