/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.blocks;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.LinkedBlockingQueue;
import org.jgroups.Address;
import org.jgroups.blocks.TCPConnectionMap;
import org.jgroups.stack.IpAddress;
import org.jgroups.util.DefaultThreadFactory;
import org.jgroups.util.StackType;
import org.jgroups.util.Util;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, sequential=true)
public class ConnectionMapTest {
    private TCPConnectionMap ct1;
    private TCPConnectionMap ct2;
    static final InetAddress loopback_addr;
    static byte[] data;
    static final int PORT1 = 7521;
    static final int PORT2 = 8931;
    static final Address addr1;
    static final Address addr2;

    @AfterMethod
    protected void tearDown() throws Exception {
        if (this.ct2 != null) {
            this.ct2.stop();
            this.ct2 = null;
        }
        if (this.ct1 != null) {
            this.ct1.stop();
            this.ct1 = null;
        }
    }

    public void testConcurrentConnect() throws Exception {
        CyclicBarrier barrier = new CyclicBarrier(3);
        TCPConnectionMap.Receiver dummy = new TCPConnectionMap.Receiver(){

            @Override
            public void receive(Address sender, byte[] data, int offset, int length) {
            }
        };
        this.ct1 = new TCPConnectionMap("ConnectionMapTest1", new DefaultThreadFactory(Util.getGlobalThreadGroup(), "ConnectionMapTest", true), null, dummy, loopback_addr, null, 7521, 7521);
        this.ct1.start();
        this.ct2 = new TCPConnectionMap("ConnectionMapTest2", new DefaultThreadFactory(Util.getGlobalThreadGroup(), "ConnectionMapTest", true), null, dummy, loopback_addr, null, 8931, 8931);
        this.ct2.start();
        Sender sender1 = new Sender(this.ct1, barrier, addr2, 0L);
        Sender sender2 = new Sender(this.ct2, barrier, addr1, 0L);
        sender1.start();
        sender2.start();
        Util.sleep(100L);
        int num_conns = this.ct1.getNumConnections();
        assert (num_conns == 0);
        num_conns = this.ct2.getNumConnections();
        assert (num_conns == 0);
        barrier.await();
        sender1.join();
        sender2.join();
        Util.sleep(500L);
        String msg = "ct1: " + this.ct1 + "\nct2: " + this.ct2;
        System.out.println(msg);
        num_conns = this.ct1.getNumConnections();
        assert (num_conns == 1) : "num_conns for ct1 is " + num_conns + ", " + msg;
        num_conns = this.ct2.getNumConnections();
        assert (num_conns == 1) : "num_conns for ct2 is " + num_conns + ", " + msg;
        assert (this.ct1.connectionEstablishedTo(addr2)) : "valid connection to peer";
        assert (this.ct2.connectionEstablishedTo(addr1)) : "valid connection to peer";
    }

    public static void testBlockingQueue() {
        final LinkedBlockingQueue queue = new LinkedBlockingQueue();
        Thread taker = new Thread(){

            @Override
            public void run() {
                try {
                    System.out.println("taking an element from the queue");
                    queue.take();
                    System.out.println("clear");
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        };
        taker.start();
        Util.sleep(500L);
        queue.clear();
        Util.interruptAndWaitToDie(taker);
        assert (!taker.isAlive()) : "taker: " + taker;
    }

    public void testStopConnectionMapNoSendQueues() throws Exception {
        this.ct1 = new TCPConnectionMap("ConnectionMapTest1", new DefaultThreadFactory(Util.getGlobalThreadGroup(), "ConnectionMapTest", true), new DummyReceiver(), loopback_addr, null, 7521, 7521, 60000L, 120000L);
        this.ct1.setUseSendQueues(false);
        this.ct1.start();
        this.ct2 = new TCPConnectionMap("ConnectionMapTest2", new DefaultThreadFactory(Util.getGlobalThreadGroup(), "ConnectionMapTest", true), new DummyReceiver(), loopback_addr, null, 8931, 8931, 60000L, 120000L);
        this.ct2.setUseSendQueues(false);
        this.ct2.start();
        ConnectionMapTest._testStop(this.ct1, this.ct2);
    }

    public void testStopConnectionMapWithSendQueues() throws Exception {
        this.ct1 = new TCPConnectionMap("ConnectionMapTest1", new DefaultThreadFactory(Util.getGlobalThreadGroup(), "ConnectionMapTest", true), new DummyReceiver(), loopback_addr, null, 7521, 7521, 60000L, 120000L);
        this.ct1.start();
        this.ct2 = new TCPConnectionMap("ConnectionMapTest2", new DefaultThreadFactory(Util.getGlobalThreadGroup(), "ConnectionMapTest", true), new DummyReceiver(), loopback_addr, null, 8931, 8931, 60000L, 120000L);
        this.ct2.start();
        ConnectionMapTest._testStop(this.ct1, this.ct2);
    }

    private static void _testStop(TCPConnectionMap table1, TCPConnectionMap table2) throws Exception {
        table1.send(addr1, data, 0, data.length);
        assert (table1.getNumConnections() == 0);
        table1.send(addr2, data, 0, data.length);
        table2.send(addr2, data, 0, data.length);
        table2.send(addr1, data, 0, data.length);
        System.out.println("table1:\n" + table1 + "\ntable2:\n" + table2);
        int num_conns_table1 = table1.getNumConnections();
        int num_conns_table2 = table2.getNumConnections();
        assert (num_conns_table1 == 1) : "table1 should have 1 connection, but has " + num_conns_table1 + ": " + table1;
        assert (num_conns_table2 == 1) : "table2 should have 1 connection, but has " + num_conns_table2 + ": " + table2;
        table2.stop();
        table1.stop();
        assert (table1.getNumConnections() == 0) : "table1 should have 0 connections: " + table1;
        assert (table2.getNumConnections() == 0) : "table2 should have 0 connections: " + table2;
    }

    static {
        try {
            StackType type = Util.getIpStackType();
            String tmp = type == StackType.IPv6 ? "::1" : "127.0.0.1";
            loopback_addr = InetAddress.getByName(tmp);
        }
        catch (UnknownHostException e) {
            throw new RuntimeException("failed initializing loopback_addr", e);
        }
        data = new byte[]{98, 101, 108, 97};
        addr1 = new IpAddress(loopback_addr, 7521);
        addr2 = new IpAddress(loopback_addr, 8931);
    }

    static class DummyReceiver
    implements TCPConnectionMap.Receiver {
        DummyReceiver() {
        }

        @Override
        public void receive(Address sender, byte[] data, int offset, int length) {
            System.out.println("-- received " + length + " bytes from " + sender);
        }
    }

    private static class Sender
    extends Thread {
        final TCPConnectionMap conn_table;
        final CyclicBarrier barrier;
        final Address dest;
        final long sleep_time;

        public Sender(TCPConnectionMap conn_table, CyclicBarrier barrier, Address dest, long sleep_time) {
            this.conn_table = conn_table;
            this.barrier = barrier;
            this.dest = dest;
            this.sleep_time = sleep_time;
        }

        @Override
        public void run() {
            try {
                this.barrier.await();
                if (this.sleep_time > 0L) {
                    Util.sleep(this.sleep_time);
                }
                this.conn_table.send(this.dest, data, 0, data.length);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

