/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3.remote;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.security.Principal;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslServerFactory;
import org.jboss.marshalling.ProviderDescriptor;
import org.jboss.remoting3.remote.ExternalSaslServerFactory;
import org.jboss.remoting3.remote.GreetingUtils;
import org.jboss.remoting3.remote.Loggers;
import org.jboss.remoting3.remote.RemoteConnection;
import org.jboss.remoting3.remote.SaslUtils;
import org.jboss.remoting3.remote.ServerGreetingHandler;
import org.jboss.remoting3.security.ServerAuthenticationProvider;
import org.jboss.remoting3.spi.ConnectionProviderContext;
import org.jboss.xnio.ChannelListener;
import org.jboss.xnio.IoUtils;
import org.jboss.xnio.OptionMap;
import org.jboss.xnio.Options;
import org.jboss.xnio.Sequence;
import org.jboss.xnio.channels.ConnectedStreamChannel;
import org.jboss.xnio.channels.SslChannel;
import org.jboss.xnio.log.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ServerOpenListener
implements ChannelListener<ConnectedStreamChannel<InetSocketAddress>> {
    private final OptionMap optionMap;
    private final ConnectionProviderContext connectionProviderContext;
    private final ProviderDescriptor providerDescriptor;
    private final ServerAuthenticationProvider authenticationProvider;
    private static final Logger log = Loggers.serverSasl;

    ServerOpenListener(OptionMap optionMap, ConnectionProviderContext connectionProviderContext, ProviderDescriptor providerDescriptor, ServerAuthenticationProvider authenticationProvider) {
        this.optionMap = optionMap;
        this.connectionProviderContext = connectionProviderContext;
        this.providerDescriptor = providerDescriptor;
        this.authenticationProvider = authenticationProvider;
    }

    public void handleEvent(ConnectedStreamChannel<InetSocketAddress> channel) {
        int[] versions;
        try {
            channel.setOption(Options.TCP_NODELAY, (Object)Boolean.TRUE);
        }
        catch (IOException e) {
            // empty catch block
        }
        final RemoteConnection connection = new RemoteConnection(this.connectionProviderContext.getExecutor(), channel, this.optionMap, this.providerDescriptor);
        Sequence mechs = (Sequence)this.optionMap.get(Options.SASL_MECHANISMS);
        HashSet includes = mechs != null ? new HashSet(mechs) : null;
        Map<String, Object> propertyMap = SaslUtils.createPropertyMap(this.optionMap);
        Enumeration<SaslServerFactory> e = Sasl.getSaslServerFactories();
        LinkedHashMap<String, SaslServerFactory> saslServerFactories = new LinkedHashMap<String, SaslServerFactory>();
        if (channel instanceof SslChannel && includes == null | includes.contains("EXTERNAL")) {
            SslChannel sslChannel = (SslChannel)channel;
            SSLSession session = sslChannel.getSslSession();
            try {
                Principal peerPrincipal = session.getPeerPrincipal();
                saslServerFactories.put("EXTERNAL", new ExternalSaslServerFactory(peerPrincipal));
            }
            catch (SSLPeerUnverifiedException e1) {
                // empty catch block
            }
        }
        while (e.hasMoreElements()) {
            SaslServerFactory saslServerFactory = e.nextElement();
            for (String name : saslServerFactory.getMechanismNames(propertyMap)) {
                if (includes != null && !includes.contains(name)) continue;
                saslServerFactories.put(name, saslServerFactory);
            }
        }
        if (saslServerFactories.isEmpty()) {
            try {
                log.trace("Sending server no-mechanisms message");
                connection.sendAuthReject("No mechanisms available");
                connection.close();
                return;
            }
            catch (IOException e1) {
                log.trace((Throwable)e1, "Failed to send server no-mechanisms message", new Object[0]);
                IoUtils.safeClose((Closeable)connection);
                return;
            }
        }
        final ByteBuffer buffer = connection.allocate();
        buffer.putInt(0);
        buffer.put((byte)0);
        GreetingUtils.writeByte(buffer, (byte)0, (byte)0);
        for (int version : versions = this.providerDescriptor.getSupportedVersions()) {
            GreetingUtils.writeInt(buffer, (byte)3, version);
        }
        for (String name : saslServerFactories.keySet()) {
            GreetingUtils.writeString(buffer, (byte)1, name);
            log.trace("Offering SASL mechanism %s", (Object)name);
        }
        GreetingUtils.writeString(buffer, (byte)2, this.connectionProviderContext.getEndpoint().getName());
        buffer.flip();
        buffer.putInt(0, buffer.remaining() - 4);
        channel.getWriteSetter().set((ChannelListener)new ChannelListener<ConnectedStreamChannel<InetSocketAddress>>(){

            public void handleEvent(ConnectedStreamChannel<InetSocketAddress> channel) {
                while (buffer.hasRemaining()) {
                    int res;
                    try {
                        res = channel.write(buffer);
                    }
                    catch (IOException e1) {
                        log.trace((Throwable)e1, "Failed to send server greeting message", new Object[0]);
                        IoUtils.safeClose((Closeable)connection);
                        connection.free(buffer);
                        return;
                    }
                    if (res != 0) continue;
                    channel.resumeWrites();
                    return;
                }
                connection.free(buffer);
                try {
                    while (!channel.flush()) {
                    }
                }
                catch (IOException e) {
                    log.trace((Throwable)e, "Failed to flush server greeting message", new Object[0]);
                    IoUtils.safeClose((Closeable)connection);
                    return;
                }
                log.trace("Server sent greeting message");
                channel.resumeReads();
            }
        });
        connection.setMessageHandler(new ServerGreetingHandler(connection, this.connectionProviderContext, saslServerFactories, this.authenticationProvider, propertyMap));
        channel.resumeWrites();
    }
}

