/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3.remote;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;
import org.jboss.xnio.Buffers;
import org.jboss.xnio.Option;
import org.jboss.xnio.OptionMap;
import org.jboss.xnio.Options;
import org.jboss.xnio.SaslQop;
import org.jboss.xnio.Sequence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SaslUtils {
    static final byte[] EMPTY = new byte[0];
    private static final Set<String> SECURE_QOP;

    private SaslUtils() {
    }

    static Map<String, Object> createPropertyMap(OptionMap optionMap) {
        HashMap<String, Object> propertyMap = new HashMap<String, Object>();
        SaslUtils.add(optionMap, Options.SASL_POLICY_FORWARD_SECRECY, propertyMap, "javax.security.sasl.policy.forward");
        SaslUtils.add(optionMap, Options.SASL_POLICY_NOACTIVE, propertyMap, "javax.security.sasl.policy.noactive");
        SaslUtils.add(optionMap, Options.SASL_POLICY_NOANONYMOUS, propertyMap, "javax.security.sasl.policy.noanonymous");
        SaslUtils.add(optionMap, Options.SASL_POLICY_NODICTIONARY, propertyMap, "javax.security.sasl.policy.nodictionary");
        SaslUtils.add(optionMap, Options.SASL_POLICY_NOPLAINTEXT, propertyMap, "javax.security.sasl.policy.noplaintext");
        SaslUtils.add(optionMap, Options.SASL_POLICY_PASS_CREDENTIALS, propertyMap, "javax.security.sasl.policy.credentials");
        SaslUtils.add(optionMap, Options.SASL_REUSE, propertyMap, "javax.security.sasl.reuse");
        SaslUtils.add(optionMap, Options.SASL_SERVER_AUTH, propertyMap, "javax.security.sasl.server.authentication");
        SaslUtils.addQopList(optionMap, (Option<Sequence<SaslQop>>)Options.SASL_QOP, propertyMap, "javax.security.sasl.qop");
        SaslUtils.add(optionMap, Options.SASL_STRENGTH, propertyMap, "javax.security.sasl.strength");
        return propertyMap;
    }

    private static void add(OptionMap optionMap, Option<?> option, Map<String, Object> map, String propName) {
        Object value = optionMap.get(option);
        if (value != null) {
            map.put(propName, value.toString().toLowerCase());
        }
    }

    private static void addQopList(OptionMap optionMap, Option<Sequence<SaslQop>> option, Map<String, Object> map, String propName) {
        Sequence value = (Sequence)optionMap.get(option);
        if (value == null) {
            return;
        }
        Sequence seq = value;
        StringBuilder builder = new StringBuilder();
        Iterator iterator = seq.iterator();
        if (!iterator.hasNext()) {
            return;
        }
        do {
            builder.append(iterator.next());
            if (!iterator.hasNext()) continue;
            builder.append(',');
        } while (iterator.hasNext());
        map.put(propName, builder.toString());
    }

    static boolean isSecureQop(Object qop) {
        return SECURE_QOP.contains(qop);
    }

    static void wrapFramed(SaslClient saslClient, ByteBuffer message) throws SaslException {
        byte[] result;
        if (message.hasArray()) {
            result = saslClient.wrap(message.array(), message.arrayOffset() + 4, message.position());
        } else {
            int end = message.position();
            message.position(4);
            byte[] bytes = Buffers.take((ByteBuffer)message, (int)(end - 4));
            result = saslClient.wrap(bytes, 0, bytes.length);
        }
        message.position(4);
        message.put(result);
    }

    static {
        HashSet<String> set = new HashSet<String>();
        set.add("auth-int");
        set.add("auth-conf");
        SECURE_QOP = set;
    }
}

