/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3;

import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.InvalidObjectException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.NoSuchElementException;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.jboss.marshalling.ByteInput;
import org.jboss.marshalling.ByteOutput;
import org.jboss.marshalling.Pair;
import org.jboss.marshalling.cloner.ClassCloner;
import org.jboss.marshalling.cloner.ClassLoaderClassCloner;
import org.jboss.marshalling.cloner.CloneTable;
import org.jboss.marshalling.cloner.ClonerConfiguration;
import org.jboss.marshalling.cloner.ObjectCloner;
import org.jboss.marshalling.cloner.ObjectClonerFactory;
import org.jboss.marshalling.cloner.ObjectCloners;
import org.jboss.remoting3.EndpointImpl;
import org.jboss.remoting3.LocalRemoteReplyHandler;
import org.jboss.remoting3.LocalRequestHandlerConnector;
import org.jboss.remoting3.RemotingOptions;
import org.jboss.remoting3.spi.AbstractHandleableCloseable;
import org.jboss.remoting3.spi.LocalReplyHandler;
import org.jboss.remoting3.spi.LocalRequestHandler;
import org.jboss.remoting3.spi.RemoteRequestHandler;
import org.jboss.remoting3.spi.SpiUtils;
import org.jboss.remoting3.stream.ObjectSink;
import org.jboss.remoting3.stream.ObjectSource;
import org.jboss.xnio.Cancellable;
import org.jboss.xnio.IoUtils;
import org.jboss.xnio.OptionMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LocalRemoteRequestHandler
extends AbstractHandleableCloseable<RemoteRequestHandler>
implements RemoteRequestHandler {
    private final LocalRequestHandler handler;
    private final ClonerPairSource clonerPairSource;

    public LocalRemoteRequestHandler(LocalRequestHandler handler, ClassLoader replyClassLoader, OptionMap optionMap, OptionMap defaultOptionMap, Executor executor) {
        super(executor);
        ClonerPairSource clonerPairSource;
        boolean callByValue = optionMap.get(RemotingOptions.CALL_BY_VALUE, defaultOptionMap.get(RemotingOptions.CALL_BY_VALUE, false));
        if (callByValue) {
            handler.addCloseHandler(SpiUtils.closingCloseHandler(this));
            ClonerConfiguration configuration = new ClonerConfiguration();
            ClassLoader requestClassLoader = handler.getClassLoader();
            clonerPairSource = new HandlerClonerSource(configuration, ObjectCloners.getSerializingObjectClonerFactory(), requestClassLoader, replyClassLoader);
        } else {
            clonerPairSource = ClonerPairSource.IDENTITY;
        }
        this.clonerPairSource = clonerPairSource;
        this.handler = handler;
    }

    @Override
    protected void closeAction() throws IOException {
        this.handler.close();
    }

    @Override
    public Cancellable receiveRequest(Object request, LocalReplyHandler replyHandler) {
        Object clonedRequest;
        Pair<ObjectCloner, ObjectCloner> pair = this.clonerPairSource.createPair();
        ObjectCloner requestCloner = (ObjectCloner)pair.getA();
        ObjectCloner replyCloner = (ObjectCloner)pair.getB();
        try {
            clonedRequest = requestCloner.clone(request);
        }
        catch (IOException e) {
            replyHandler.handleException(e);
            return IoUtils.nullCancellable();
        }
        catch (ClassNotFoundException e) {
            InvalidObjectException ioe = new InvalidObjectException("Invalid object: " + e);
            ioe.initCause(e);
            replyHandler.handleException(ioe);
            return IoUtils.nullCancellable();
        }
        return this.handler.receiveRequest(clonedRequest, new LocalRemoteReplyHandler(replyHandler, replyCloner));
    }

    private static class CloningObjectSource
    implements ObjectSource {
        private volatile Pair<ObjectSource, ObjectCloner> pair;
        private static final AtomicReferenceFieldUpdater<CloningObjectSource, Pair> pairUpdater = AtomicReferenceFieldUpdater.newUpdater(CloningObjectSource.class, Pair.class, "pair");

        CloningObjectSource(ObjectSource objectSource, ObjectCloner outboundCloner) {
            this.pair = Pair.create((Object)objectSource, (Object)outboundCloner);
        }

        public boolean hasNext() throws IOException {
            Pair<ObjectSource, ObjectCloner> pair = this.pair;
            if (pair == null) {
                throw CloningObjectSource.closed();
            }
            return ((ObjectSource)pair.getA()).hasNext();
        }

        public Object next() throws NoSuchElementException, IOException {
            Pair<ObjectSource, ObjectCloner> pair = this.pair;
            if (pair == null) {
                throw CloningObjectSource.closed();
            }
            try {
                return ((ObjectCloner)pair.getB()).clone(((ObjectSource)pair.getA()).next());
            }
            catch (ClassNotFoundException e) {
                throw new InvalidObjectException("Class not found: " + e);
            }
        }

        private static IOException closed() {
            return new IOException("Object source has been closed");
        }

        public void close() throws IOException {
            Pair pair = pairUpdater.getAndSet(this, null);
            if (pair == null) {
                return;
            }
            ((ObjectSource)pair.getA()).close();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CloningObjectSink
    implements ObjectSink<Object> {
        private volatile Pair<ObjectCloner, ObjectSink> pair;
        private static final AtomicReferenceFieldUpdater<CloningObjectSink, Pair> pairUpdater = AtomicReferenceFieldUpdater.newUpdater(CloningObjectSink.class, Pair.class, "pair");

        public CloningObjectSink(ObjectCloner cloner, ObjectSink objectSink) {
            this.pair = Pair.create((Object)cloner, (Object)objectSink);
        }

        @Override
        public void accept(Object instance) throws IOException {
            Pair<ObjectCloner, ObjectSink> pair = this.pair;
            if (pair == null) {
                throw CloningObjectSink.closed();
            }
            ObjectSink objectSink = (ObjectSink)pair.getB();
            ObjectCloner cloner = (ObjectCloner)pair.getA();
            try {
                objectSink.accept(cloner.clone(instance));
            }
            catch (ClassNotFoundException e) {
                throw new InvalidClassException(e.getMessage());
            }
        }

        @Override
        public void flush() throws IOException {
            Pair<ObjectCloner, ObjectSink> pair = this.pair;
            if (pair == null) {
                throw CloningObjectSink.closed();
            }
            ObjectSink objectSink = (ObjectSink)pair.getB();
            if (objectSink == null) {
                throw CloningObjectSink.closed();
            }
            objectSink.flush();
        }

        private static IOException closed() {
            return new IOException("Object sink has been closed");
        }

        @Override
        public void close() throws IOException {
            Pair pair = pairUpdater.getAndSet(this, null);
            if (pair == null) {
                return;
            }
            ((ObjectSink)pair.getB()).close();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class HandlerClonerSource
    implements ClonerPairSource {
        private final ObjectClonerFactory clonerFactory;
        private final ClassLoader requestClassLoader;
        private final ClassLoader replyClassLoader;
        private final ClonerConfiguration configuration;

        public HandlerClonerSource(ClonerConfiguration configuration, ObjectClonerFactory clonerFactory, ClassLoader requestClassLoader, ClassLoader replyClassLoader) {
            this.configuration = configuration;
            this.clonerFactory = clonerFactory;
            this.requestClassLoader = requestClassLoader;
            this.replyClassLoader = replyClassLoader;
        }

        @Override
        public Pair<ObjectCloner, ObjectCloner> createPair() {
            ClonerConfiguration requestConfiguration = this.configuration.clone();
            ClonerConfiguration replyConfiguration = this.configuration.clone();
            ClassLoader requestClassLoader = this.requestClassLoader;
            ClassLoader replyClassLoader = this.replyClassLoader;
            if (requestClassLoader == replyClassLoader) {
                requestConfiguration.setClassCloner(ClassCloner.IDENTITY);
                replyConfiguration.setClassCloner(ClassCloner.IDENTITY);
            } else {
                requestConfiguration.setClassCloner((ClassCloner)new ClassLoaderClassCloner(requestClassLoader));
                replyConfiguration.setClassCloner((ClassCloner)new ClassLoaderClassCloner(replyClassLoader));
            }
            LocalCloneTable requestCloneTable = new LocalCloneTable();
            LocalCloneTable replyCloneTable = new LocalCloneTable();
            requestConfiguration.setCloneTable((CloneTable)requestCloneTable);
            replyConfiguration.setCloneTable((CloneTable)replyCloneTable);
            ObjectCloner requestCloner = this.clonerFactory.createCloner(requestConfiguration);
            ObjectCloner replyCloner = this.clonerFactory.createCloner(replyConfiguration);
            requestCloneTable.setInboundCloner(replyCloner);
            replyCloneTable.setInboundCloner(requestCloner);
            return Pair.create((Object)requestCloner, (Object)replyCloner);
        }

        public ObjectCloner createNew() {
            ClonerConfiguration configuration = this.configuration.clone();
            configuration.setCloneTable((CloneTable)new LocalCloneTable());
            return this.clonerFactory.createCloner(configuration);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface ClonerPairSource {
        public static final Pair<ObjectCloner, ObjectCloner> IDENTITY_PAIR = Pair.create((Object)ObjectCloner.IDENTITY, (Object)ObjectCloner.IDENTITY);
        public static final ClonerPairSource IDENTITY = new ClonerPairSource(){

            @Override
            public Pair<ObjectCloner, ObjectCloner> createPair() {
                return IDENTITY_PAIR;
            }
        };

        public Pair<ObjectCloner, ObjectCloner> createPair();
    }

    private static class LocalCloneTable
    implements CloneTable {
        private volatile ObjectCloner inboundCloner;

        LocalCloneTable() {
        }

        void setInboundCloner(ObjectCloner inboundCloner) {
            this.inboundCloner = inboundCloner;
        }

        public Object clone(Object original, ObjectCloner outboundCloner, ClassCloner classCloner) throws IOException, ClassNotFoundException {
            if (original instanceof ObjectSource) {
                return new CloningObjectSource((ObjectSource)original, outboundCloner);
            }
            if (original instanceof ObjectSink) {
                return new CloningObjectSink(this.inboundCloner, (ObjectSink)original);
            }
            if (original instanceof InputStream) {
                return original;
            }
            if (original instanceof OutputStream) {
                return original;
            }
            if (original instanceof Reader) {
                return original;
            }
            if (original instanceof Writer) {
                return original;
            }
            if (original instanceof ByteInput) {
                return original;
            }
            if (original instanceof ByteOutput) {
                return original;
            }
            if (original instanceof LocalRequestHandlerConnector) {
                return original;
            }
            if (original instanceof EndpointImpl) {
                return original;
            }
            return null;
        }
    }
}

