/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xnio;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executor;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.jboss.xnio.ChannelListener;
import org.jboss.xnio.IoFuture;
import org.jboss.xnio.IoUtils;
import org.jboss.xnio.Option;
import org.jboss.xnio.OptionMap;
import org.jboss.xnio.Options;
import org.jboss.xnio.Sequence;
import org.jboss.xnio.SslClientAuthMode;
import org.jboss.xnio.SslTcpServer;
import org.jboss.xnio.TcpServer;
import org.jboss.xnio.channels.BoundChannel;
import org.jboss.xnio.channels.Channels;
import org.jboss.xnio.channels.Configurable;
import org.jboss.xnio.channels.SslTcpChannel;
import org.jboss.xnio.channels.TcpChannel;

final class SslEngineSslTcpServer
implements SslTcpServer {
    private final SSLContext sslContext;
    private final TcpServer tcpServer;
    private final Executor sslExecutor;
    private volatile SslClientAuthMode clientAuthMode;
    private volatile boolean useClientMode;
    private volatile boolean enableSessionCreation;
    private volatile String[] cipherSuites;
    private volatile String[] protocols;
    private final ChannelListener.Setter<SslTcpServer> closeSetter;
    private final ChannelListener.Setter<SslTcpChannel> openSetter = new ChannelListener.Setter<SslTcpChannel>(){

        @Override
        public void set(final ChannelListener<? super SslTcpChannel> channelListener) {
            SslEngineSslTcpServer.this.tcpServer.getOpenSetter().set((ChannelListener<? extends TcpChannel>)(channelListener == null ? null : new ChannelListener<TcpChannel>(){

                @Override
                public void handleEvent(TcpChannel tcpChannel) {
                    String[] protocols;
                    int n;
                    SslClientAuthMode clientAuthMode;
                    InetSocketAddress peerAddress = (InetSocketAddress)tcpChannel.getPeerAddress();
                    SSLEngine engine = SslEngineSslTcpServer.this.sslContext.createSSLEngine(peerAddress.getHostName(), peerAddress.getPort());
                    boolean clientMode = SslEngineSslTcpServer.this.useClientMode;
                    engine.setUseClientMode(clientMode);
                    if (!clientMode && (clientAuthMode = SslEngineSslTcpServer.this.clientAuthMode) != null) {
                        switch (clientAuthMode) {
                            case NOT_REQUESTED: {
                                engine.setNeedClientAuth(false);
                                engine.setWantClientAuth(false);
                                break;
                            }
                            case REQUESTED: {
                                engine.setWantClientAuth(true);
                                break;
                            }
                            case REQUIRED: {
                                engine.setNeedClientAuth(true);
                                break;
                            }
                            default: {
                                throw new IllegalStateException();
                            }
                        }
                    }
                    engine.setEnableSessionCreation(SslEngineSslTcpServer.this.enableSessionCreation);
                    String[] cipherSuites = SslEngineSslTcpServer.this.cipherSuites;
                    if (cipherSuites != null) {
                        HashSet supported = new HashSet(Arrays.asList(engine.getSupportedCipherSuites()));
                        ArrayList<String> finalList = new ArrayList<String>();
                        String[] stringArray = cipherSuites;
                        n = cipherSuites.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String name = stringArray[n2];
                            if (supported.contains(name)) {
                                finalList.add(name);
                            }
                            ++n2;
                        }
                        engine.setEnabledCipherSuites(finalList.toArray(new String[finalList.size()]));
                    }
                    if ((protocols = SslEngineSslTcpServer.this.protocols) != null) {
                        HashSet supported = new HashSet(Arrays.asList(engine.getSupportedProtocols()));
                        ArrayList<String> finalList = new ArrayList<String>();
                        String[] stringArray = protocols;
                        int n3 = protocols.length;
                        n = 0;
                        while (n < n3) {
                            String name = stringArray[n];
                            if (supported.contains(name)) {
                                finalList.add(name);
                            }
                            ++n;
                        }
                        engine.setEnabledProtocols(finalList.toArray(new String[finalList.size()]));
                    }
                    channelListener.handleEvent(Channels.createSslTcpChannel(tcpChannel, engine, SslEngineSslTcpServer.this.sslExecutor));
                }
            }));
        }
    };
    private static final Set<Option<?>> SUPPORTED_OPTIONS = Option.setBuilder().add(Options.SSL_CLIENT_AUTH_MODE).add(Options.SSL_USE_CLIENT_MODE).add(Options.SSL_ENABLE_SESSION_CREATION).add(Options.SSL_ENABLED_CIPHER_SUITES).add(Options.SSL_ENABLED_PROTOCOLS).create();

    SslEngineSslTcpServer(SSLContext sslContext, TcpServer tcpServer, Executor executor, OptionMap optionMap) {
        this.tcpServer = tcpServer;
        this.sslExecutor = executor;
        this.sslContext = sslContext;
        this.clientAuthMode = optionMap.get(Options.SSL_CLIENT_AUTH_MODE);
        this.useClientMode = optionMap.get(Options.SSL_USE_CLIENT_MODE, false);
        this.enableSessionCreation = optionMap.get(Options.SSL_ENABLE_SESSION_CREATION, true);
        Sequence<String> enabledCipherSuites = optionMap.get(Options.SSL_ENABLED_CIPHER_SUITES);
        this.cipherSuites = enabledCipherSuites != null ? enabledCipherSuites.toArray((String[])new String[enabledCipherSuites.size()]) : null;
        Sequence<String> enabledProtocols = optionMap.get(Options.SSL_ENABLED_PROTOCOLS);
        this.protocols = enabledProtocols != null ? enabledProtocols.toArray((String[])new String[enabledProtocols.size()]) : null;
        this.closeSetter = IoUtils.getDelegatingSetter(tcpServer.getCloseSetter(), this);
    }

    @Override
    public <T> Configurable setOption(Option<T> option, T value) throws IllegalArgumentException, IOException {
        if (option == Options.SSL_CLIENT_AUTH_MODE) {
            this.clientAuthMode = Options.SSL_CLIENT_AUTH_MODE.cast(value);
        } else if (option == Options.SSL_USE_CLIENT_MODE) {
            Boolean valueObject = Options.SSL_USE_CLIENT_MODE.cast(value);
            if (valueObject != null) {
                this.useClientMode = valueObject;
            }
        } else if (option == Options.SSL_ENABLE_SESSION_CREATION) {
            Boolean valueObject = Options.SSL_ENABLE_SESSION_CREATION.cast(value);
            if (valueObject != null) {
                this.enableSessionCreation = valueObject;
            }
        } else if (option == Options.SSL_ENABLED_CIPHER_SUITES) {
            Sequence<String> seq = Options.SSL_ENABLED_CIPHER_SUITES.cast(value);
            this.cipherSuites = seq == null ? null : seq.toArray((String[])new String[seq.size()]);
        } else if (option == Options.SSL_ENABLED_PROTOCOLS) {
            Sequence<String> seq = Options.SSL_ENABLED_PROTOCOLS.cast(value);
            this.protocols = seq == null ? null : seq.toArray((String[])new String[seq.size()]);
        } else {
            this.tcpServer.setOption(option, value);
        }
        return this;
    }

    @Override
    public ChannelListener.Setter<? extends BoundChannel<InetSocketAddress>> getBindSetter() {
        return this.tcpServer.getBindSetter();
    }

    @Override
    public ChannelListener.Setter<? extends SslTcpServer> getCloseSetter() {
        return this.closeSetter;
    }

    @Override
    public ChannelListener.Setter<? extends SslTcpChannel> getOpenSetter() {
        return this.openSetter;
    }

    @Override
    public Collection<? extends BoundChannel<InetSocketAddress>> getChannels() {
        return this.tcpServer.getChannels();
    }

    @Override
    public IoFuture<? extends BoundChannel<InetSocketAddress>> bind(InetSocketAddress address) {
        return this.tcpServer.bind(address);
    }

    @Override
    public boolean isOpen() {
        return this.tcpServer.isOpen();
    }

    @Override
    public void close() throws IOException {
        this.tcpServer.close();
    }

    @Override
    public boolean supportsOption(Option<?> option) {
        return SUPPORTED_OPTIONS.contains(option) || this.tcpServer.supportsOption(option);
    }

    @Override
    public <T> T getOption(Option<T> option) throws IOException {
        if (option == Options.SSL_CLIENT_AUTH_MODE) {
            return option.cast((Object)this.clientAuthMode);
        }
        if (option == Options.SSL_USE_CLIENT_MODE) {
            return option.cast(this.useClientMode);
        }
        if (option == Options.SSL_ENABLE_SESSION_CREATION) {
            return option.cast(this.enableSessionCreation);
        }
        if (option == Options.SSL_ENABLED_CIPHER_SUITES) {
            String[] cipherSuites = this.cipherSuites;
            return cipherSuites == null ? null : (T)option.cast(Sequence.of(cipherSuites));
        }
        if (option == Options.SSL_ENABLED_PROTOCOLS) {
            String[] protocols = this.protocols;
            return protocols == null ? null : (T)option.cast(Sequence.of(protocols));
        }
        return this.tcpServer.getOption(option);
    }
}

