/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.pc.operation;

import java.util.HashMap;
import java.util.Map;
import org.rhq.core.clientapi.server.operation.OperationServerService;
import org.rhq.core.clientapi.util.StringUtil;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.pc.operation.OperationContextImpl;
import org.rhq.core.pc.operation.OperationManager;
import org.rhq.core.pluginapi.operation.OperationContext;
import org.rhq.core.pluginapi.operation.OperationServices;
import org.rhq.core.pluginapi.operation.OperationServicesResult;
import org.rhq.core.pluginapi.operation.OperationServicesResultCode;
import org.rhq.core.util.exception.ExceptionPackage;

public class OperationServicesAdapter
implements OperationServices,
OperationServerService {
    private OperationManager operationManager;
    private final Object callbackLock = new Object();
    private Map<String, OperationServicesResult> completedJobs = new HashMap<String, OperationServicesResult>();

    public OperationServicesAdapter(OperationManager operationManager) {
        this.operationManager = operationManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationServicesResult invokeOperation(OperationContext context, String operationName, Configuration operationParameters, long timeout) {
        if (timeout < 1L) {
            throw new IllegalArgumentException("timeout must be greater than zero");
        }
        OperationContextImpl contextImpl = (OperationContextImpl)context;
        if (timeout > 0L) {
            if (operationParameters == null) {
                operationParameters = new Configuration();
            }
            operationParameters.put((Property)new PropertySimple("rhq.timeout", (Object)timeout));
        }
        String jobId = "OperationServicesAdapter." + System.currentTimeMillis();
        Object object = this.callbackLock;
        synchronized (object) {
            try {
                this.operationManager.invokeOperation(jobId, contextImpl.getResourceId(), operationName, operationParameters, this);
                while (!this.completedJobs.containsKey(jobId)) {
                    this.callbackLock.wait();
                }
            }
            catch (Exception e) {
                OperationServicesResult result = new OperationServicesResult(OperationServicesResultCode.FAILURE);
                result.setErrorStackTrace(StringUtil.getStackTrace((Throwable)e));
                return result;
            }
        }
        OperationServicesResult result = this.completedJobs.get(jobId);
        this.completedJobs.remove(jobId);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void operationSucceeded(String jobId, Configuration result, long invocationTime, long completionTime) {
        OperationServicesResult operationServicesResult = new OperationServicesResult(OperationServicesResultCode.SUCCESS);
        operationServicesResult.setComplexResults(result);
        this.completedJobs.put(jobId, operationServicesResult);
        Object object = this.callbackLock;
        synchronized (object) {
            this.callbackLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void operationFailed(String jobId, Configuration result, ExceptionPackage error, long invocationTime, long completionTime) {
        OperationServicesResult operationServicesResult = new OperationServicesResult(OperationServicesResultCode.FAILURE);
        operationServicesResult.setComplexResults(result);
        operationServicesResult.setErrorStackTrace(error.getStackTraceString());
        this.completedJobs.put(jobId, operationServicesResult);
        Object object = this.callbackLock;
        synchronized (object) {
            this.callbackLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void operationTimedOut(String jobId, long invocationTime, long timeoutTime) {
        OperationServicesResult operationServicesResult = new OperationServicesResult(OperationServicesResultCode.TIMED_OUT);
        this.completedJobs.put(jobId, operationServicesResult);
        Object object = this.callbackLock;
        synchronized (object) {
            this.callbackLock.notifyAll();
        }
    }
}

