/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployment.spi.beans;

import javax.enterprise.deploy.model.DDBean;
import javax.enterprise.deploy.spi.DConfigBean;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;

public class TestBeans {
    public static void test_remove(DConfigBean config, DDBean dd) {
        try {
            System.out.println(config.getXpaths().length + " xpaths.");
            String targetXPath = config.getXpaths()[0];
            System.out.println(targetXPath + " is the first.");
            DDBean first = dd.getChildBean(targetXPath)[0];
            DConfigBean cnfg = config.getDConfigBean(first);
            System.out.println("cnfg has " + cnfg.getXpaths().length + " sub kids");
            config.removeDConfigBean(cnfg);
            System.out.println("cnfg has " + cnfg.getXpaths().length + " sub kids");
            System.out.println(config.getXpaths().length + " xpaths.");
        }
        catch (Exception e) {
            System.out.println("ERROR: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public static void traverse(DConfigBean config, DDBean dd, int indent) throws ConfigurationException {
        TestBeans.indentPrint(indent += 3, "starting \"" + dd.getXpath() + "\", config of type " + TestBeans.trimClass(config.getClass()));
        String[] pathsToFollow = config.getXpaths();
        if (pathsToFollow.length > 0) {
            TestBeans.indentPrint(indent, "- There are " + pathsToFollow.length + " xpaths returned.");
        }
        indent += 4;
        for (int i = 0; i < pathsToFollow.length; ++i) {
            String s = "path " + i + ": " + pathsToFollow[i];
            DDBean[] lesserBeans = dd.getChildBean(pathsToFollow[i]);
            TestBeans.indentPrint(indent, s + " , " + lesserBeans.length + " found.");
            for (int j = 0; j < lesserBeans.length; ++j) {
                DConfigBean cb = config.getDConfigBean(lesserBeans[j]);
                TestBeans.traverse(cb, lesserBeans[j], indent);
            }
        }
    }

    public static String trimClass(Class c) {
        int dot = c.getName().lastIndexOf(46);
        int dollar = c.getName().lastIndexOf(36);
        if (dollar == -1) {
            return c.getName().substring(dot + 1);
        }
        return c.getName().substring(dollar + 1);
    }

    public static void indentPrint(int x, String y) {
        String s = "";
        for (int i = 0; i < x; ++i) {
            s = s + " ";
        }
        System.out.println(s + y);
    }
}

