/*
 * Decompiled with CFR 0.152.
 */
package de.vdheide.mp3;

import de.vdheide.mp3.ID3v2BadFrameException;
import de.vdheide.mp3.ID3v2BadHeaderException;
import de.vdheide.mp3.ID3v2BadParsingException;
import de.vdheide.mp3.ID3v2DecompressionException;
import de.vdheide.mp3.ID3v2ExtendedHeader;
import de.vdheide.mp3.ID3v2Frame;
import de.vdheide.mp3.ID3v2Header;
import de.vdheide.mp3.ID3v2IllegalVersionException;
import de.vdheide.mp3.ID3v2NoSuchFrameException;
import de.vdheide.mp3.ID3v2WrongCRCException;
import de.vdheide.mp3.NoID3v2HeaderException;
import de.vdheide.mp3.NoID3v2TagException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.Enumeration;
import java.util.Vector;
import java.util.zip.CRC32;

public class ID3v2 {
    private File file;
    private ID3v2Header header;
    private ID3v2ExtendedHeader extended_header;
    private Vector frames;
    private boolean is_changed = false;
    private boolean use_padding = true;
    private boolean use_crc = true;
    private boolean use_unsynchronization = true;
    private boolean use_extended_header = true;
    private static int _tmpCount = 0;
    public static final byte VERSION = 3;
    public static final byte REVISION = 0;

    public ID3v2(InputStream in) throws IOException, ID3v2BadParsingException, ID3v2IllegalVersionException, ID3v2WrongCRCException, ID3v2BadHeaderException, ID3v2DecompressionException {
        try {
            this.file = null;
            try {
                this.readHeader(in);
            }
            catch (NoID3v2HeaderException e) {
                this.header = null;
                this.extended_header = null;
                this.frames = null;
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.is_changed = false;
                return;
            }
            if (this.header.hasExtendedHeader()) {
                this.readExtendedHeader(in);
            } else {
                this.extended_header = null;
            }
            this.readFrames(in);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException iOException) {}
            this.is_changed = false;
        }
    }

    public ID3v2(File file) throws IOException, ID3v2IllegalVersionException, ID3v2WrongCRCException, ID3v2DecompressionException, ID3v2BadHeaderException, ID3v2BadParsingException {
        this(new FileInputStream(file));
        this.file = file;
    }

    public static byte[] synchronize(byte[] in) {
        int FF = -1;
        boolean OO = false;
        boolean did_synch = false;
        byte[] out = new byte[in.length];
        int outpos = 0;
        int i = 0;
        while (i < in.length) {
            if (in[i] == -1) {
                if (in[i + 1] == 0) {
                    did_synch = true;
                    out[outpos++] = -1;
                    ++i;
                } else {
                    out[outpos++] = -1;
                }
            } else {
                out[outpos++] = in[i];
            }
            ++i;
        }
        if (outpos != in.length) {
            byte[] tmp = new byte[outpos];
            System.arraycopy(out, 0, tmp, 0, outpos);
            out = tmp;
        }
        if (did_synch) {
            return out;
        }
        return null;
    }

    public static byte[] unsynchronize(byte[] in) {
        byte[] out = new byte[in.length];
        int outpos = 0;
        boolean did_unsync = false;
        int i = 0;
        while (i < in.length) {
            if (in[i] == -1) {
                if (i + 1 < in.length && ((in[i + 1] & 0xFF) >= 224 || in[i + 1] == 0)) {
                    byte[] tmp = new byte[out.length + 1];
                    System.arraycopy(out, 0, tmp, 0, outpos);
                    out = tmp;
                    tmp = null;
                    out[outpos++] = -1;
                    out[outpos++] = 0;
                    out[outpos++] = in[i + 1];
                    ++i;
                    did_unsync = true;
                } else {
                    out[outpos++] = in[i];
                }
            } else {
                out[outpos++] = in[i];
            }
            ++i;
        }
        if (did_unsync) {
            return out;
        }
        return null;
    }

    public void setUsePadding(boolean use_padding) {
        if (this.use_padding != use_padding) {
            this.is_changed = true;
            this.use_padding = use_padding;
        }
    }

    public boolean getUsePadding() {
        return this.use_padding;
    }

    public void setUseCRC(boolean use_crc) {
        if (this.use_crc != use_crc) {
            this.is_changed = true;
            this.use_crc = use_crc;
        }
    }

    public boolean getUseCRC() {
        return this.use_crc;
    }

    public void setUseUnsynchronization(boolean use_unsynch) {
        if (this.use_unsynchronization != use_unsynch) {
            this.is_changed = true;
            this.use_unsynchronization = use_unsynch;
        }
    }

    public void setUseExtendedHeader(boolean use_extended_header) {
        if (this.use_extended_header != use_extended_header) {
            this.is_changed = true;
            this.use_extended_header = use_extended_header;
        }
    }

    public boolean getUseUnsynchronization() {
        return this.use_unsynchronization;
    }

    public boolean hasTag() {
        return this.header != null;
    }

    public Vector getFrames() throws NoID3v2TagException {
        if (this.frames == null) {
            throw new NoID3v2TagException();
        }
        return this.frames;
    }

    public Vector getFrame(String id) throws NoID3v2TagException, ID3v2NoSuchFrameException {
        if (this.frames == null) {
            throw new NoID3v2TagException();
        }
        Vector<ID3v2Frame> res = new Vector<ID3v2Frame>();
        Enumeration e = this.frames.elements();
        while (e.hasMoreElements()) {
            ID3v2Frame tmp = (ID3v2Frame)e.nextElement();
            if (!tmp.getID().equals(id)) continue;
            res.addElement(tmp);
        }
        if (res.size() == 0) {
            throw new ID3v2NoSuchFrameException();
        }
        return res;
    }

    public void addFrame(ID3v2Frame frame) {
        if (this.frames == null) {
            this.frames = new Vector();
        }
        this.frames.addElement(frame);
        this.is_changed = true;
    }

    public void removeFrame(ID3v2Frame frame) throws NoID3v2TagException, ID3v2NoSuchFrameException {
        if (this.frames == null) {
            throw new NoID3v2TagException();
        }
        if (!this.frames.removeElement(frame)) {
            throw new ID3v2NoSuchFrameException();
        }
        this.is_changed = true;
    }

    public void removeFrame(String id) throws NoID3v2TagException, ID3v2NoSuchFrameException {
        if (this.frames == null) {
            throw new NoID3v2TagException();
        }
        boolean found = false;
        Enumeration e = this.frames.elements();
        while (e.hasMoreElements()) {
            ID3v2Frame tmp = (ID3v2Frame)e.nextElement();
            if (!tmp.getID().equals(id)) continue;
            this.frames.removeElement(tmp);
            found = true;
        }
        if (!found) {
            throw new ID3v2NoSuchFrameException();
        }
        this.is_changed = true;
    }

    public void removeFrame(String id, int number) throws NoID3v2TagException, ID3v2NoSuchFrameException {
        if (this.frames == null) {
            throw new NoID3v2TagException();
        }
        int count = 0;
        boolean removed = false;
        Enumeration e = this.frames.elements();
        while (e.hasMoreElements()) {
            ID3v2Frame tmp = (ID3v2Frame)e.nextElement();
            if (!tmp.getID().equals(id)) continue;
            if (count == number) {
                this.frames.removeElement(tmp);
                removed = true;
                continue;
            }
            ++count;
        }
        if (!removed) {
            throw new ID3v2NoSuchFrameException();
        }
        this.is_changed = true;
    }

    public void removeFrames() {
        if (this.frames != null) {
            this.frames = new Vector();
        }
    }

    public void update() throws IOException {
        if (!this.is_changed) {
            return;
        }
        boolean usesUnsynchronization = false;
        byte[] newFramesBytes = this.convertFramesToArrayOfBytes();
        int crc = 0;
        if (this.use_crc) {
            CRC32 crcCalculator = new CRC32();
            crcCalculator.update(newFramesBytes);
            crc = (int)crcCalculator.getValue();
        }
        ID3v2ExtendedHeader newExtHeader = null;
        byte[] newExtHeaderBytes = new byte[]{};
        if (this.use_extended_header) {
            newExtHeader = new ID3v2ExtendedHeader(this.use_crc, crc, 0);
            newExtHeaderBytes = newExtHeader.getBytes();
        }
        if (this.use_unsynchronization) {
            byte[] unsynchFrames;
            byte[] unsynchExtHeader = ID3v2.unsynchronize(newExtHeaderBytes);
            if (unsynchExtHeader != null) {
                usesUnsynchronization = true;
                newExtHeaderBytes = unsynchExtHeader;
            }
            if ((unsynchFrames = ID3v2.unsynchronize(newFramesBytes)) != null) {
                usesUnsynchronization = true;
                newFramesBytes = unsynchFrames;
            }
        }
        int newHeaderLen = newFramesBytes.length + newExtHeaderBytes.length;
        ID3v2Header newHeader = new ID3v2Header(3, 0, usesUnsynchronization, this.use_extended_header, false, newHeaderLen);
        byte[] newHeaderBytes = newHeader.getBytes();
        int oldHeaderLen = 0;
        oldHeaderLen = this.header == null ? 0 : this.header.getTagSize() + 10;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(newHeaderBytes);
        baos.write(newExtHeaderBytes);
        baos.write(newFramesBytes);
        long contentLen = this.file.length() - (long)oldHeaderLen;
        long newFileLength = contentLen + (long)newHeaderLen;
        if (this.use_padding) {
            long padding = 0L;
            if (oldHeaderLen > newHeaderLen) {
                padding = oldHeaderLen - newHeaderLen;
            }
            long i = 0L;
            while (i < padding) {
                baos.write(0);
                ++i;
            }
        }
        byte[] finalNewHeader = baos.toByteArray();
        int minBuffSize = Math.abs(finalNewHeader.length - oldHeaderLen);
        int buffSize = Math.max(2048, minBuffSize);
        byte[] buf = new byte[buffSize];
        RandomAccessFile raf = null;
        try {
            raf = new RandomAccessFile(this.file, "rw");
            long oldPointer = oldHeaderLen == 0 ? 0 : oldHeaderLen - 1;
            long newPointer = 0L;
            raf.seek(oldPointer);
            long amountToRead = contentLen;
            if (amountToRead < (long)buffSize) {
                throw new IOException("Bad File");
            }
            int read = raf.read(buf, 0, buffSize);
            amountToRead -= (long)read;
            oldPointer = raf.getFilePointer();
            raf.seek(newPointer);
            raf.write(finalNewHeader);
            newPointer = raf.getFilePointer();
            while (amountToRead > 0L) {
                byte[] buf2 = new byte[buffSize];
                raf.seek(oldPointer);
                read = raf.read(buf2, 0, Math.min(buffSize, (int)amountToRead));
                if (read == -1) break;
                oldPointer = raf.getFilePointer();
                amountToRead -= (long)read;
                raf.seek(newPointer);
                raf.write(buf);
                newPointer = raf.getFilePointer();
                buf = buf2;
            }
            raf.seek(newPointer);
            raf.write(buf);
            this.header = newHeader;
            this.extended_header = newExtHeader;
            this.is_changed = false;
        }
        finally {
            try {
                if (raf != null) {
                    raf.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private void readHeader(InputStream in) throws NoID3v2HeaderException, ID3v2IllegalVersionException, IOException {
        this.header = new ID3v2Header(in);
    }

    private void readExtendedHeader(InputStream in) throws IOException {
        this.extended_header = new ID3v2ExtendedHeader(in);
    }

    private void readFrames(InputStream in) throws IOException, ID3v2BadParsingException, ID3v2BadHeaderException, ID3v2WrongCRCException, ID3v2DecompressionException {
        int bytes_to_read;
        if (this.extended_header != null) {
            int crc = this.extended_header.hasCRC() ? 0 : 4;
            bytes_to_read = this.header.getTagSize() - (this.extended_header.getSize() + crc) - this.extended_header.getPaddingSize();
        } else {
            bytes_to_read = this.header.getTagSize();
        }
        byte[] unsynch_frames_as_byte = null;
        try {
            unsynch_frames_as_byte = new byte[bytes_to_read];
        }
        catch (NegativeArraySizeException nax) {
            throw new ID3v2BadHeaderException();
        }
        catch (OutOfMemoryError ome) {
            throw new ID3v2BadParsingException(ome);
        }
        ID3v2.fillBuffer(unsynch_frames_as_byte, in);
        byte[] frames_as_byte = null;
        if (this.header.getUnsynchronization()) {
            frames_as_byte = ID3v2.synchronize(unsynch_frames_as_byte);
            if (frames_as_byte == null) {
                frames_as_byte = unsynch_frames_as_byte;
            }
        } else {
            frames_as_byte = unsynch_frames_as_byte;
        }
        if (this.extended_header != null && this.extended_header.hasCRC()) {
            CRC32 crc_calculator = new CRC32();
            crc_calculator.update(frames_as_byte);
            int crc = (int)crc_calculator.getValue();
            this.extended_header.getCRC();
        }
        this.frames = new Vector();
        ByteArrayInputStream bis = new ByteArrayInputStream(frames_as_byte);
        ID3v2Frame frame = null;
        boolean cont = true;
        while (bis.available() > 0 && cont) {
            try {
                frame = new ID3v2Frame(bis);
            }
            catch (ID3v2BadFrameException e) {
                continue;
            }
            if (frame.getID() == ID3v2Frame.ID_INVALID) {
                cont = false;
                continue;
            }
            this.frames.addElement(frame);
        }
    }

    private byte[] convertFramesToArrayOfBytes() {
        ID3v2Frame tmp = null;
        ByteArrayOutputStream out = new ByteArrayOutputStream(500);
        Enumeration e = this.frames.elements();
        while (e.hasMoreElements()) {
            tmp = (ID3v2Frame)e.nextElement();
            byte[] frame_in_bytes = tmp.getBytes();
            out.write(frame_in_bytes, 0, frame_in_bytes.length);
        }
        return out.toByteArray();
    }

    public static void fillBuffer(byte[] buffer, InputStream in) throws IOException {
        int offset = 0;
        while (offset < buffer.length) {
            int read = in.read(buffer, offset, buffer.length - offset);
            if (read == -1) {
                throw new IOException("eof");
            }
            if (read == 0) {
                throw new IOException("can't read");
            }
            offset += read;
        }
    }

    public static void skipData(int length, InputStream in) throws IOException {
        long skipped = 0L;
        while (skipped < (long)length) {
            long current = in.skip((long)length - skipped);
            if (current == -1L) {
                throw new IOException("eof");
            }
            if (current == 0L) {
                throw new IOException("can't read");
            }
            skipped += current;
        }
    }
}

