/*
 * Decompiled with CFR 0.152.
 */
package com.pugh.sockso.web;

import com.pugh.sockso.Properties;
import com.pugh.sockso.PropertiesListener;
import com.pugh.sockso.db.Database;
import com.pugh.sockso.resources.Resources;
import com.pugh.sockso.web.Dispatcher;
import com.pugh.sockso.web.Server;
import com.pugh.sockso.web.ServerThread;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Vector;
import javax.swing.JOptionPane;
import joptsimple.OptionSet;
import org.apache.log4j.Logger;

public class HttpServer
extends Thread
implements Server,
PropertiesListener {
    public static final int DEFAULT_PORT = 4444;
    private final Dispatcher dispatcher;
    private final Database db;
    private final Properties p;
    private final Resources r;
    private ServerSocket ss;
    private final Vector<ServerThread> threads;
    private int port;
    private static Logger log = Logger.getLogger(Server.class);

    public HttpServer(int port, Dispatcher dispatcher, Database db, Properties p, Resources r) {
        this.port = port;
        this.dispatcher = dispatcher;
        this.db = db;
        this.p = p;
        this.r = r;
        this.threads = new Vector();
    }

    public void start(OptionSet options) {
        this.p.addPropertiesListener(this);
        this.start();
    }

    public void run() {
        try {
            this.ss = this.getServerSocket(this.port);
            log.info((Object)("Listening on " + this.port));
            while (true) {
                this.handleRequest(this.ss.accept(), this.dispatcher);
            }
        }
        catch (IOException e) {
            if (!e.getMessage().equals("Socket closed")) {
                log.error((Object)e);
            }
            return;
        }
    }

    protected void handleRequest(Socket client, Dispatcher dispatcher) {
        ServerThread st = new ServerThread(this, client, this.db, this.p, this.r, dispatcher);
        this.threads.addElement(st);
        st.start();
    }

    public void shutdown() {
        log.info((Object)("Shutting Down " + this.threads.size() + " Thread(s)"));
        for (ServerThread thread : this.threads) {
            thread.shutdown();
        }
        if (this.ss != null) {
            try {
                log.info((Object)"Closing Listening Socket");
                this.ss.close();
            }
            catch (Exception e) {
                log.error((Object)e);
            }
        }
        log.info((Object)"Shutdown Complete");
    }

    public void requestComplete(ServerThread thread) {
        this.threads.removeElement(thread);
    }

    public String getHost() {
        return this.p.get("server.host") + ":" + this.getPort();
    }

    public int getPort() {
        return this.port;
    }

    public void propertiesSaved(Properties p) {
        try {
            int newPort = Integer.parseInt(p.get("server.port", "4444"));
            if (newPort != this.port) {
                JOptionPane.showMessageDialog(null, "You need to restart Sockso for this change to take effect");
            }
        }
        catch (NumberFormatException e) {
            log.warn((Object)("The server port is not a number: '" + p.get("server.port") + "'"));
        }
    }

    protected ServerSocket getServerSocket(int port) throws IOException {
        return new ServerSocket(port);
    }

    public String getProtocol() {
        return "http";
    }
}

