/*
 * Decompiled with CFR 0.152.
 */
package org.kc7bfi.jflac.apps;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.kc7bfi.jflac.FLACDecoder;
import org.kc7bfi.jflac.FrameListener;
import org.kc7bfi.jflac.frame.Frame;
import org.kc7bfi.jflac.metadata.Metadata;

public class Analyser
implements FrameListener {
    private int frameNum = 0;

    public void analyse(String inFileName) throws IOException {
        System.out.println("FLAX Analysis for " + inFileName);
        FileInputStream is = new FileInputStream(inFileName);
        FLACDecoder decoder = new FLACDecoder(is);
        decoder.addFrameListener(this);
        decoder.decode();
    }

    public void processMetadata(Metadata metadata) {
        System.out.println(metadata.toString());
    }

    public void processFrame(Frame frame) {
        ++this.frameNum;
        System.out.println(this.frameNum + " " + frame.toString());
    }

    public void processError(String msg) {
        System.out.println("Frame Error: " + msg);
    }

    public static void main(String[] args) {
        try {
            Analyser analyser = new Analyser();
            analyser.analyse(args[0]);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

