/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes.mindmapmode.actions;

import freemind.controller.MenuItemSelectedListener;
import freemind.controller.actions.generated.instance.NodeStyleFormatAction;
import freemind.controller.actions.generated.instance.XmlAction;
import freemind.main.Tools;
import freemind.modes.MindMap;
import freemind.modes.MindMapNode;
import freemind.modes.NodeAdapter;
import freemind.modes.mindmapmode.MindMapController;
import freemind.modes.mindmapmode.actions.NodeActorXml;
import freemind.modes.mindmapmode.actions.NodeGeneralAction;
import freemind.modes.mindmapmode.actions.xml.ActionPair;
import javax.swing.Action;
import javax.swing.JMenuItem;

public class NodeStyleAction
extends NodeGeneralAction
implements NodeActorXml,
MenuItemSelectedListener {
    private final String mStyle;

    public NodeStyleAction(MindMapController controller, String style) {
        super(controller, style, null);
        this.mStyle = style;
        this.addActor(this);
    }

    public ActionPair apply(MindMap model, MindMapNode node) {
        String newStyle = null;
        MindMapNode selected = this.modeController.getSelected();
        newStyle = selected.hasStyle() && Tools.safeEquals(this.mStyle, selected.getStyle()) ? null : this.mStyle;
        return this.getActionPair(node, newStyle);
    }

    public Class getDoActionClass() {
        return NodeStyleFormatAction.class;
    }

    public void setStyle(MindMapNode node, String style) {
        this.modeController.getActionFactory().startTransaction((String)this.getValue("Name"));
        this.modeController.getActionFactory().executeAction(this.getActionPair(node, style));
        this.modeController.getActionFactory().endTransaction((String)this.getValue("Name"));
    }

    private ActionPair getActionPair(MindMapNode targetNode, String style) {
        NodeStyleFormatAction styleAction = this.createNodeStyleFormatAction(targetNode, style);
        NodeStyleFormatAction undoStyleAction = this.createNodeStyleFormatAction(targetNode, targetNode.getStyle());
        return new ActionPair((XmlAction)styleAction, (XmlAction)undoStyleAction);
    }

    private NodeStyleFormatAction createNodeStyleFormatAction(MindMapNode selected, String style) {
        NodeStyleFormatAction nodeStyleAction = new NodeStyleFormatAction();
        nodeStyleAction.setNode(this.getNodeID(selected));
        nodeStyleAction.setStyle(style);
        return nodeStyleAction;
    }

    public void act(XmlAction action) {
        if (action instanceof NodeStyleFormatAction) {
            NodeStyleFormatAction nodeStyleAction = (NodeStyleFormatAction)action;
            NodeAdapter node = this.getNodeFromID(nodeStyleAction.getNode());
            String style = nodeStyleAction.getStyle();
            if (!Tools.safeEquals(node.hasStyle() ? node.getStyle() : null, style)) {
                node.setStyle(style);
                this.modeController.nodeStyleChanged(node);
            }
        }
    }

    public boolean isSelected(JMenuItem pCheckItem, Action pAction) {
        MindMapNode selected = this.modeController.getSelected();
        if (!selected.hasStyle()) {
            return false;
        }
        return Tools.safeEquals(this.mStyle, selected.getStyle());
    }
}

