/*
 * Decompiled with CFR 0.152.
 */
package de.foltin;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class CompileXsdStart
extends DefaultHandler {
    public static final String FREEMIND_PACKAGE = "freemind.controller.actions.generated.instance";
    private static final String DESTINATION_DIR = "binding/src/" + "freemind.controller.actions.generated.instance".replace('.', File.separatorChar);
    private static final String FREEMIND_ACTIONS_XSD = "freemind_actions.xsd";
    private static final String KEY_PACKAGE = "000_KEY_PACKAGE";
    private static final String FILE_START = "010_start";
    private static final String KEY_IMPORT_ARRAY_LIST = "020_import_array_list";
    private static final String KEY_CLASS_START = "030_CLASS_START";
    private static final String KEY_CLASS_EXTENSION = "040_CLASS_EXTENSION";
    private static final String KEY_CLASS_START2 = "050_CLASS_START2";
    private static final String KEY_CLASS_PRIVATE_MEMBERS = "060_PRIVATE_MEMBERS";
    private static final String KEY_CLASS_GETTERS = "070_Getters";
    private static final String KEY_CLASS_SETTERS = "080_setters";
    private static final String KEY_CLASS_SINGLE_CHOICE = "090_single_choice";
    private static final String KEY_CLASS_MULTIPLE_CHOICES_MEMBERS = "100_choice_members";
    private static final String KEY_CLASS_MULTIPLE_CHOICES_SETGET = "110_choice_setget";
    private static final String KEY_CLASS_SEQUENCE = "120_sequence";
    private static final String KEY_CLASS_END = "500_CLASS_END";
    private final InputStream mInputStream;
    private XsdHandler mCurrentHandler;
    private TreeSet mKeyOrder = new TreeSet();
    private HashMap mClassMap = new HashMap();
    private StringBuffer mBindingXml = new StringBuffer();
    private HashMap mElementMap = new HashMap();
    private HashMap mTypeMap = new HashMap();
    public final int Schema_Id = 0;
    public final int ComplexType_Id = 1;
    public final int Sequence_Id = 2;
    public final int Choice_Id = 3;
    public final int Attribute_Id = 4;
    public final int ComplexContent_Id = 5;
    public final int Element_Id = 6;
    public final int Extension_Id = 7;
    public final int SimpleType_Id = 8;
    public final int Restriction_Id = 9;
    public final int Enumeration_Id = 10;
    public final int Group_Id = 11;
    ElementTypes Schema = new ElementTypes(0);
    ElementTypes ComplexType = new ElementTypes(1);
    ElementTypes Sequence = new ElementTypes(2);
    ElementTypes Choice = new ElementTypes(3);
    ElementTypes Attribute = new ElementTypes(4);
    ElementTypes ComplexContent = new ElementTypes(5);
    ElementTypes Element = new ElementTypes(6);
    ElementTypes Extension = new ElementTypes(7);
    ElementTypes SimpleType = new ElementTypes(8);
    ElementTypes Restriction = new ElementTypes(9);
    ElementTypes Enumeration = new ElementTypes(10);
    ElementTypes Group = new ElementTypes(11);

    public CompileXsdStart(InputStream pInputStream) {
        this.mInputStream = pInputStream;
        this.mElementMap.put("xs:schema", this.Schema);
        this.mElementMap.put("xs:complexType", this.ComplexType);
        this.mElementMap.put("xs:complexContent", this.ComplexContent);
        this.mElementMap.put("xs:element", this.Element);
        this.mElementMap.put("xs:extension", this.Extension);
        this.mElementMap.put("xs:choice", this.Choice);
        this.mElementMap.put("xs:sequence", this.Sequence);
        this.mElementMap.put("xs:attribute", this.Attribute);
        this.mElementMap.put("xs:simpleType", this.SimpleType);
        this.mElementMap.put("xs:restriction", this.Restriction);
        this.mElementMap.put("xs:enumeration", this.Enumeration);
        this.mElementMap.put("xs:group", this.Group);
        this.mTypeMap.put("xs:int", "int");
        this.mTypeMap.put("xs:string", "String");
        this.mTypeMap.put("xs:boolean", "boolean");
    }

    public static void main(String[] args) throws Exception {
        CompileXsdStart cXS = new CompileXsdStart(new BufferedInputStream(new FileInputStream(FREEMIND_ACTIONS_XSD)));
        cXS.generate();
        cXS.print();
    }

    private void print() throws Exception {
        File dir = new File(DESTINATION_DIR);
        dir.mkdirs();
        Iterator it = this.mClassMap.keySet().iterator();
        while (it.hasNext()) {
            String className = (String)it.next();
            if (className == null) continue;
            HashMap classMap = (HashMap)this.mClassMap.get(className);
            FileOutputStream fs = new FileOutputStream(DESTINATION_DIR + "/" + className + ".java");
            Iterator it2 = this.mKeyOrder.iterator();
            while (it2.hasNext()) {
                String orderString = (String)it2.next();
                if (!classMap.containsKey(orderString)) continue;
                String string = (String)classMap.get(orderString);
                fs.write(string.getBytes());
            }
            fs.close();
        }
        FileOutputStream fs = new FileOutputStream(DESTINATION_DIR + "/binding.xml");
        fs.write(this.mBindingXml.toString().getBytes());
        fs.close();
    }

    public void generate() throws ParserConfigurationException, SAXException, IOException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SAXParser saxParser = factory.newSAXParser();
        this.mCurrentHandler = new XsdHandler(null);
        this.mBindingXml.setLength(0);
        this.mBindingXml.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?><binding>\n");
        saxParser.parse(this.mInputStream, (DefaultHandler)this);
        this.mBindingXml.append("</binding>\n");
    }

    public void endElement(String pUri, String pLocalName, String pName) throws SAXException {
        this.mCurrentHandler.endElement(pUri, pLocalName, pName);
    }

    public HashMap createClass(String pName) {
        if (this.mClassMap.containsKey(pName)) {
            return (HashMap)this.mClassMap.get(pName);
        }
        HashMap newValue = new HashMap();
        this.mClassMap.put(pName, newValue);
        return newValue;
    }

    public void startElement(String pUri, String pLocalName, String pName, Attributes pAttributes) throws SAXException {
        this.mCurrentHandler.startElement(pUri, pLocalName, pName, pAttributes);
    }

    public String firstLetterCapitalized(String text) {
        if (text == null || text.length() == 0) {
            return text;
        }
        return text.substring(0, 1).toUpperCase() + text.substring(1, text.length());
    }

    private String getNameFromXml(String pXmlString) {
        StringTokenizer st = new StringTokenizer(pXmlString, "_");
        String result = "";
        while (st.hasMoreTokens()) {
            result = result + this.firstLetterCapitalized(st.nextToken());
        }
        return result;
    }

    private String getType(String type) {
        type = this.mTypeMap.containsKey(type) ? (String)this.mTypeMap.get(type) : "String";
        return type;
    }

    private class AttributeHandler
    extends XsdHandler {
        public AttributeHandler(XsdHandler pParent) {
            super(pParent);
        }

        public void startElement(String arg0, Attributes arg1) {
            super.startElement(arg0, arg1);
            String type = arg1.getValue("type");
            type = CompileXsdStart.this.getType(type);
            String rawName = arg1.getValue("name");
            String usage = arg1.getValue("use");
            String minOccurs = arg1.getValue("minOccurs");
            String name = CompileXsdStart.this.getNameFromXml(rawName);
            String memberName = name.substring(0, 1).toLowerCase() + name.substring(1);
            this.appendToClassMap(CompileXsdStart.KEY_CLASS_PRIVATE_MEMBERS, "  protected " + type + " " + memberName + ";\n");
            this.appendToClassMap(CompileXsdStart.KEY_CLASS_GETTERS, "  public " + type + " get" + name + "(){\n" + "    return " + memberName + ";\n" + "  }\n");
            this.appendToClassMap(CompileXsdStart.KEY_CLASS_SETTERS, "  public void set" + name + "(" + type + " value){\n" + "    this." + memberName + " = value;\n" + "  }\n");
            CompileXsdStart.this.mBindingXml.append("    <value name='" + rawName + "' field='" + memberName + "' " + "usage='" + ("required".equals(usage) ? "required" : "optional") + "' " + ("0".equals(minOccurs) ? "" : "style='attribute'") + "/>\n");
        }
    }

    private class ComplexContentHandler
    extends XsdHandler {
        public ComplexContentHandler(XsdHandler pParent) {
            super(pParent);
        }
    }

    private class ComplexTypeHandler
    extends XsdHandler {
        private boolean mIsClassDefinedHere;
        private String mRawName;

        public ComplexTypeHandler(XsdHandler pParent) {
            super(pParent);
            this.mIsClassDefinedHere = false;
        }

        public void startElement(String arg0, Attributes arg1) {
            super.startElement(arg0, arg1);
            if (this.getClassName() == null) {
                this.mRawName = this.startClass(arg1);
                CompileXsdStart.this.mBindingXml.append("  <mapping class='freemind.controller.actions.generated.instance." + this.mClassName + "' type-name='" + this.mRawName + "_type' abstract='true'>\n");
                this.mIsClassDefinedHere = true;
            }
        }

        public void endElement(String arg0, String arg1, String arg2) throws SAXException {
            if (this.mIsClassDefinedHere) {
                String extendString = "";
                if (this.getExtendsClassName() != null) {
                    extendString = " extends=\"freemind.controller.actions.generated.instance." + this.getExtendsClassName() + "\"";
                }
                CompileXsdStart.this.mBindingXml.append("  </mapping>\n  <mapping name=\"" + this.mRawName + "\"" + extendString + " class=\"" + CompileXsdStart.FREEMIND_PACKAGE + "." + this.mClassName + "\"><structure map-as=\"" + this.mRawName + "_type\"/></mapping>\n" + "\n");
            }
            super.endElement(arg0, arg1, arg2);
        }
    }

    private class SequenceElementHandler
    extends XsdHandler {
        public SequenceElementHandler(XsdHandler pParent) {
            super(pParent);
        }

        public void startElement(String arg0, Attributes arg1) {
            super.startElement(arg0, arg1);
            String rawName = arg1.getValue("name");
            String type = arg1.getValue("type");
            boolean isRef = false;
            if (rawName == null) {
                rawName = arg1.getValue("ref");
                isRef = true;
            }
            String name = CompileXsdStart.this.getNameFromXml(rawName);
            String memberName = name.substring(0, 1).toLowerCase() + name.substring(1);
            type = isRef ? name : CompileXsdStart.this.getType(type);
            String maxOccurs = arg1.getValue("maxOccurs");
            String minOccurs = arg1.getValue("minOccurs");
            if (maxOccurs != null && maxOccurs.trim().equals("1")) {
                this.appendToClassMap(CompileXsdStart.KEY_CLASS_MULTIPLE_CHOICES_MEMBERS, "  protected " + type + " " + memberName + ";\n\n");
                this.appendToClassMap(CompileXsdStart.KEY_CLASS_MULTIPLE_CHOICES_SETGET, "  public " + type + " get" + name + "() {\n    return this." + memberName + ";\n" + "  }\n\n");
                this.appendToClassMap(CompileXsdStart.KEY_CLASS_MULTIPLE_CHOICES_SETGET, "  public void set" + name + "(" + type + " value){\n" + "    this." + memberName + " = value;\n" + "  }\n\n");
                String optReq = "optional";
                if (minOccurs != null && minOccurs.trim().equals("1")) {
                    optReq = "required";
                }
                if (isRef) {
                    CompileXsdStart.this.mBindingXml.append("      <structure field=\"" + memberName + "\" usage=\"" + optReq + "\" map-as=\"" + CompileXsdStart.FREEMIND_PACKAGE + "." + type + "\"/>\n");
                } else {
                    CompileXsdStart.this.mBindingXml.append("      <value name=\"" + rawName + "\" field=\"" + memberName + "\" usage=\"" + optReq + "\"/>\n");
                }
            } else {
                this.appendToClassMap(CompileXsdStart.KEY_CLASS_SEQUENCE, "  public void add" + name + "(" + name + " " + memberName + ") {\n" + "    " + memberName + "List.add(" + memberName + ");\n" + "  }\n" + "\n" + "  public void addAt" + name + "(int position, " + name + " " + memberName + ") {\n" + "    " + memberName + "List.add(position, " + memberName + ");\n" + "  }\n" + "\n" + "  public " + name + " get" + name + "(int index) {\n" + "    return (" + name + ")" + memberName + "List.get( index );\n" + "  }\n" + "\n" + "  public int size" + name + "List() {\n" + "    return " + memberName + "List.size();\n" + "  }\n" + "\n" + "  public void clear" + name + "List() {\n" + "    " + memberName + "List.clear();\n" + "  }\n" + "\n" + "  public java.util.List getList" + name + "List() {\n" + "    return java.util.Collections.unmodifiableList(" + memberName + "List);\n" + "  }\n" + "    protected ArrayList " + memberName + "List = new ArrayList();\n\n");
                this.addArrayListImport();
                CompileXsdStart.this.mBindingXml.append("    <collection field=\"" + memberName + "List\">\n" + "      <structure map-as=\"" + CompileXsdStart.FREEMIND_PACKAGE + "." + name + "\"/>\n" + "    </collection>\n");
            }
        }
    }

    private class SequenceHandler
    extends XsdHandler {
        public SequenceHandler(XsdHandler pParent) {
            super(pParent);
        }

        protected XsdHandler createElementHandler() {
            return new SequenceElementHandler(this);
        }
    }

    private class GroupHandler
    extends XsdHandler {
        public GroupHandler(XsdHandler pParent) {
            super(pParent);
        }

        public void startElement(String arg0, String arg1, String arg2, Attributes arg3) throws SAXException {
            CompileXsdStart.this.mCurrentHandler = new GroupHandler(this);
        }
    }

    private class ChoiceElementHandler
    extends XsdHandler {
        private boolean mIsSingle;

        public ChoiceElementHandler(XsdHandler pParent) {
            super(pParent);
            if (!(pParent instanceof ChoiceHandler)) {
                throw new IllegalArgumentException("Hmm, parent is not a choice.");
            }
            ChoiceHandler choiceParent = (ChoiceHandler)pParent;
            this.mIsSingle = choiceParent.isSingleChoice();
        }

        public void startElement(String arg0, Attributes arg1) {
            super.startElement(arg0, arg1);
            String rawName = arg1.getValue("ref");
            String name = CompileXsdStart.this.getNameFromXml(rawName);
            String memberName = name.substring(0, 1).toLowerCase() + name.substring(1);
            if (this.mIsSingle) {
                CompileXsdStart.this.mBindingXml.append("      <structure usage=\"optional\" map-as=\"freemind.controller.actions.generated.instance." + name + "\"/>\n");
                return;
            }
            this.appendToClassMap(CompileXsdStart.KEY_CLASS_MULTIPLE_CHOICES_MEMBERS, "  protected " + name + " " + memberName + ";\n\n");
            this.appendToClassMap(CompileXsdStart.KEY_CLASS_MULTIPLE_CHOICES_SETGET, "  public " + name + " get" + name + "() {\n    return this." + memberName + ";\n" + "  }\n\n");
            this.appendToClassMap(CompileXsdStart.KEY_CLASS_MULTIPLE_CHOICES_SETGET, "  public void set" + name + "(" + name + " value){\n" + "    this." + memberName + " = value;\n" + "  }\n\n");
            CompileXsdStart.this.mBindingXml.append("    <structure field=\"" + memberName + "\" usage=\"" + "optional" + "\" map-as=\"" + CompileXsdStart.FREEMIND_PACKAGE + "." + name + "\"/>\n");
        }
    }

    private class ChoiceHandler
    extends XsdHandler {
        private boolean isSingleChoice;

        public ChoiceHandler(XsdHandler pParent) {
            super(pParent);
            this.isSingleChoice = false;
        }

        protected XsdHandler createElementHandler() {
            return new ChoiceElementHandler(this);
        }

        protected boolean isSingleChoice() {
            return this.isSingleChoice;
        }

        public void startElement(String arg0, Attributes arg1) {
            super.startElement(arg0, arg1);
            if (arg1.getValue("maxOccurs") != null) {
                this.isSingleChoice = true;
                this.appendToClassMap(CompileXsdStart.KEY_CLASS_SINGLE_CHOICE, "  public void addChoice(Object choice) {\n    choiceList.add(choice);\n  }\n\n  public void addAtChoice(int position, Object choice) {\n    choiceList.add(position, choice);\n  }\n  public Object getChoice(int index) {\n    return (Object)choiceList.get( index );\n  }\n\n  public int sizeChoiceList() {\n    return choiceList.size();\n  }\n\n  public void clearChoiceList() {\n    choiceList.clear();\n  }\n\n  public java.util.List getListChoiceList() {\n    return java.util.Collections.unmodifiableList(choiceList);\n  }\n\n  protected ArrayList choiceList = new ArrayList();\n\n");
                this.addArrayListImport();
                CompileXsdStart.this.mBindingXml.append("    <collection field='choiceList' ordered='false'>\n");
            }
        }

        public void endElement(String arg0, String arg1, String arg2) throws SAXException {
            if (this.isSingleChoice) {
                CompileXsdStart.this.mBindingXml.append("    </collection>\n");
            }
            super.endElement(arg0, arg1, arg2);
        }
    }

    private class SchemaHandler
    extends XsdHandler {
        public SchemaHandler(XsdHandler pParent) {
            super(pParent);
        }
    }

    private class ExtensionHandler
    extends XsdHandler {
        public ExtensionHandler(XsdHandler pParent) {
            super(pParent);
        }

        public void startElement(String arg0, Attributes arg1) {
            super.startElement(arg0, arg1);
            String base = arg1.getValue("base");
            this.mExtendsClassName = CompileXsdStart.this.getNameFromXml(base);
            CompileXsdStart.this.mKeyOrder.add(CompileXsdStart.KEY_CLASS_EXTENSION);
            this.getClassMap().put(CompileXsdStart.KEY_CLASS_EXTENSION, " extends " + this.mExtendsClassName);
            CompileXsdStart.this.mBindingXml.append("    <structure map-as=\"" + base + "_type\"/>\n");
            XsdHandler xsdHandlerHierarchy = this;
            do {
                if (!(xsdHandlerHierarchy instanceof ComplexTypeHandler)) continue;
                ComplexTypeHandler complexHandler = (ComplexTypeHandler)xsdHandlerHierarchy;
                complexHandler.mExtendsClassName = this.mExtendsClassName;
            } while ((xsdHandlerHierarchy = xsdHandlerHierarchy.mParent) != null);
        }
    }

    private class XsdHandler
    extends DefaultHandler {
        XsdHandler mParent;
        String mClassName = null;
        String mExtendsClassName = null;

        public XsdHandler(XsdHandler pParent) {
            this.mParent = pParent;
        }

        String getClassName() {
            if (this.mClassName != null) {
                return this.mClassName;
            }
            if (this.mParent != null) {
                return this.mParent.getClassName();
            }
            return null;
        }

        HashMap getClassMap() {
            String className = this.getClassName();
            return CompileXsdStart.this.createClass(className);
        }

        protected void appendToClassMap(String key, String value) {
            CompileXsdStart.this.mKeyOrder.add(key);
            HashMap classMap = this.getClassMap();
            if (classMap.containsKey(key)) {
                classMap.put(key, classMap.get(key) + value);
            } else {
                classMap.put(key, value);
            }
        }

        protected void addArrayListImport() {
            this.appendToClassMap(CompileXsdStart.KEY_IMPORT_ARRAY_LIST, "import java.util.ArrayList;\n");
        }

        String getExtendsClassName() {
            if (this.mExtendsClassName != null) {
                return this.mExtendsClassName;
            }
            if (this.mParent == null) {
                return null;
            }
            return this.mParent.getExtendsClassName();
        }

        public void startElement(String pName, Attributes pAttributes) {
        }

        public void startElement(String pUri, String pLocalName, String pName, Attributes pAttributes) throws SAXException {
            super.startElement(pUri, pLocalName, pName, pAttributes);
            if (!CompileXsdStart.this.mElementMap.containsKey(pName)) {
                throw new IllegalArgumentException("Element " + pName + " is not matched.");
            }
            ElementTypes defaultHandlerType = (ElementTypes)CompileXsdStart.this.mElementMap.get(pName);
            XsdHandler nextHandler = null;
            switch (defaultHandlerType.getId()) {
                case 6: {
                    nextHandler = this.createElementHandler();
                    break;
                }
                case 1: {
                    nextHandler = new ComplexTypeHandler(this);
                    break;
                }
                case 5: {
                    nextHandler = new ComplexContentHandler(this);
                    break;
                }
                case 0: {
                    nextHandler = new SchemaHandler(this);
                    break;
                }
                case 2: {
                    nextHandler = new SequenceHandler(this);
                    break;
                }
                case 3: {
                    nextHandler = new ChoiceHandler(this);
                    break;
                }
                case 7: {
                    nextHandler = new ExtensionHandler(this);
                    break;
                }
                case 4: {
                    nextHandler = new AttributeHandler(this);
                    break;
                }
                case 11: {
                    nextHandler = new GroupHandler(this);
                    break;
                }
                default: {
                    nextHandler = new XsdHandler(this);
                }
            }
            CompileXsdStart.this.mCurrentHandler = nextHandler;
            nextHandler.startElement(pName, pAttributes);
        }

        protected XsdHandler createElementHandler() {
            return new ComplexTypeHandler(this);
        }

        public void endElement(String pUri, String pLocalName, String pName) throws SAXException {
            super.endElement(pUri, pLocalName, pName);
            CompileXsdStart.this.mCurrentHandler = this.mParent;
        }

        protected String startClass(Attributes arg1) {
            CompileXsdStart.this.mKeyOrder.add(CompileXsdStart.FILE_START);
            CompileXsdStart.this.mKeyOrder.add(CompileXsdStart.KEY_PACKAGE);
            CompileXsdStart.this.mKeyOrder.add(CompileXsdStart.KEY_CLASS_START);
            CompileXsdStart.this.mKeyOrder.add(CompileXsdStart.KEY_CLASS_END);
            String rawName = arg1.getValue("name");
            String name = CompileXsdStart.this.getNameFromXml(rawName);
            HashMap class1 = CompileXsdStart.this.createClass(name);
            this.mClassName = name;
            class1.put(CompileXsdStart.FILE_START, "/* " + name + "...*/\n");
            class1.put(CompileXsdStart.KEY_PACKAGE, "package freemind.controller.actions.generated.instance;\n");
            class1.put(CompileXsdStart.KEY_CLASS_START, "public class " + name);
            CompileXsdStart.this.mKeyOrder.add(CompileXsdStart.KEY_CLASS_START2);
            class1.put(CompileXsdStart.KEY_CLASS_START2, " {\n");
            class1.put(CompileXsdStart.KEY_CLASS_END, "} /* " + name + "*/\n");
            return rawName;
        }
    }

    private class ElementTypes {
        private final int mEnumerationId;

        public ElementTypes(int pEnumerationId) {
            this.mEnumerationId = pEnumerationId;
        }

        public int getId() {
            return this.mEnumerationId;
        }
    }
}

