/*
 * Decompiled with CFR 0.152.
 */
package com.lightdev.app.shtm;

import com.lightdev.app.shtm.AttributeComponent;
import java.awt.Component;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;

abstract class AttributePanel
extends JPanel
implements AttributeComponent,
ContainerListener {
    private Vector components = new Vector();

    public AttributePanel() {
        this.addContainerListener(this);
    }

    public boolean setValue(AttributeSet a) {
        boolean result = true;
        Enumeration elements = this.components.elements();
        while (elements.hasMoreElements()) {
            AttributeComponent ac = (AttributeComponent)elements.nextElement();
            if (ac.setValue(a)) continue;
            result = false;
        }
        return result;
    }

    public AttributeSet getValue() {
        SimpleAttributeSet attributes = new SimpleAttributeSet();
        Enumeration elements = this.components.elements();
        while (elements.hasMoreElements()) {
            AttributeComponent ac = (AttributeComponent)elements.nextElement();
            attributes.addAttributes(ac.getValue());
        }
        return attributes;
    }

    public AttributeSet getValue(boolean includeUnchanged) {
        if (includeUnchanged) {
            SimpleAttributeSet attributes = new SimpleAttributeSet();
            Enumeration elements = this.components.elements();
            while (elements.hasMoreElements()) {
                AttributeComponent ac = (AttributeComponent)elements.nextElement();
                attributes.addAttributes(ac.getValue(includeUnchanged));
            }
            return attributes;
        }
        return this.getValue();
    }

    public void componentAdded(ContainerEvent e) {
        Component component = e.getChild();
        if (component instanceof AttributeComponent) {
            this.components.add(component);
        }
    }

    public void componentRemoved(ContainerEvent e) {
        Component component = e.getChild();
        if (component instanceof AttributeComponent) {
            this.components.remove(component);
        }
    }
}

