/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.browser.impl;

import org.mozilla.browser.MozillaExecutor;
import org.mozilla.browser.XPCOMUtils;
import org.mozilla.browser.impl.ChromeAdapter;
import org.mozilla.interfaces.nsIRequest;
import org.mozilla.interfaces.nsISupports;
import org.mozilla.interfaces.nsIURI;
import org.mozilla.interfaces.nsIWebNavigation;
import org.mozilla.interfaces.nsIWebProgress;
import org.mozilla.interfaces.nsIWebProgressListener;
import org.mozilla.xpcom.Mozilla;

public class ProgressAdapter
implements nsIWebProgressListener {
    private final ChromeAdapter chromeAdapter;

    ProgressAdapter(ChromeAdapter chromeAdapter) {
        this.chromeAdapter = chromeAdapter;
    }

    public void onLocationChange(nsIWebProgress aWebProgress, nsIRequest aRequest, nsIURI aLocation) {
        assert (MozillaExecutor.isMozillaThread());
        final String uri = aLocation.getSpec();
        MozillaExecutor.swingAsyncExec(new Runnable(){

            public void run() {
                ((ProgressAdapter)ProgressAdapter.this).chromeAdapter.panel.onSetUrlbarText(uri);
            }
        });
    }

    public void onProgressChange(nsIWebProgress aWebProgress, nsIRequest aRequest, int aCurSelfProgress, int aMaxSelfProgress, int aCurTotalProgress, int aMaxTotalProgress) {
    }

    public void onStatusChange(nsIWebProgress aWebProgress, nsIRequest aRequest, long aStatus, final String aMessage) {
        assert (MozillaExecutor.isMozillaThread());
        MozillaExecutor.swingAsyncExec(new Runnable(){

            public void run() {
                ((ProgressAdapter)ProgressAdapter.this).chromeAdapter.panel.onSetStatus(aMessage);
            }
        });
    }

    public void onSecurityChange(nsIWebProgress aWebProgress, nsIRequest aRequest, long aState) {
    }

    public void onStateChange(nsIWebProgress aWebProgress, nsIRequest aRequest, long aStateFlags, long aStatus) {
        assert (MozillaExecutor.isMozillaThread());
        if ((aStateFlags & 0x40000L) != 0L && (aStateFlags & 1L) != 0L) {
            MozillaExecutor.swingAsyncExec(new Runnable(){

                public void run() {
                    ((ProgressAdapter)ProgressAdapter.this).chromeAdapter.panel.onEnableStopButton(true);
                    ((ProgressAdapter)ProgressAdapter.this).chromeAdapter.panel.onLoadingStarted();
                }
            });
        }
        if ((aStateFlags & 0x40000L) != 0L && (aStateFlags & 0x10L) != 0L) {
            nsIWebNavigation nav = XPCOMUtils.qi(this.chromeAdapter.getWebBrowser(), nsIWebNavigation.class);
            final boolean isFwd = nav.getCanGoForward();
            final boolean isBack = nav.getCanGoBack();
            MozillaExecutor.swingAsyncExec(new Runnable(){

                public void run() {
                    ((ProgressAdapter)ProgressAdapter.this).chromeAdapter.panel.onEnableForwardButton(isFwd);
                    ((ProgressAdapter)ProgressAdapter.this).chromeAdapter.panel.onEnableBackButton(isBack);
                    ((ProgressAdapter)ProgressAdapter.this).chromeAdapter.panel.onEnableStopButton(false);
                    ((ProgressAdapter)ProgressAdapter.this).chromeAdapter.panel.onEnableReloadButton(true);
                    ((ProgressAdapter)ProgressAdapter.this).chromeAdapter.panel.onLoadingEnded();
                }
            });
            this.chromeAdapter.contentFinishedLoading();
        }
    }

    public nsISupports queryInterface(String uuid) {
        return Mozilla.queryInterface(this, uuid);
    }
}

