/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.browser.impl;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.FocusEvent;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mozilla.browser.MozillaExecutor;
import org.mozilla.browser.impl.MozillaCanvas;

public class FocusWatcher {
    static Log log = LogFactory.getLog(FocusWatcher.class);
    private static Map<Window, List<MozillaCanvas>> xx = new HashMap<Window, List<MozillaCanvas>>();
    private static GlobalFocusListener gfl = new GlobalFocusListener();

    public static void register(final MozillaCanvas c) {
        MozillaExecutor.swingAsyncExec(new Runnable(){

            public void run() {
                Window win = SwingUtilities.getWindowAncestor(c);
                assert (win != null);
                boolean wasEmpty = xx.isEmpty();
                LinkedList<MozillaCanvas> cs = (LinkedList<MozillaCanvas>)xx.get(win);
                if (cs == null) {
                    cs = new LinkedList<MozillaCanvas>();
                    xx.put(win, cs);
                }
                cs.add(c);
                if (wasEmpty) {
                    Toolkit.getDefaultToolkit().addAWTEventListener(gfl, 524292L);
                }
            }
        });
    }

    public static void unregister(final MozillaCanvas c) {
        MozillaExecutor.swingAsyncExec(new Runnable(){

            public void run() {
                for (Window win : xx.keySet()) {
                    List cs = (List)xx.get(win);
                    assert (cs != null);
                    if (!cs.remove(c)) continue;
                    if (!cs.isEmpty()) break;
                    xx.remove(win);
                    break;
                }
                if (xx.isEmpty()) {
                    Toolkit.getDefaultToolkit().removeAWTEventListener(gfl);
                }
            }
        });
    }

    static class GlobalFocusListener
    implements AWTEventListener {
        GlobalFocusListener() {
        }

        public void eventDispatched(AWTEvent ev) {
            log.debug(ev.getSource().getClass().getSimpleName() + " " + ev);
            if (!(ev instanceof FocusEvent)) {
                return;
            }
            FocusEvent fev = (FocusEvent)ev;
            if (fev.getID() == 1004 && ev.getSource() instanceof Component) {
                Component cmp = (Component)ev.getSource();
                if (cmp instanceof MozillaCanvas) {
                    MozillaCanvas c = (MozillaCanvas)cmp;
                    c.onFocusMovedTo(cmp);
                } else {
                    List cs;
                    Window win = SwingUtilities.getWindowAncestor(cmp);
                    if (win != null && (cs = (List)xx.get(win)) != null && !cs.isEmpty()) {
                        MozillaCanvas c = (MozillaCanvas)cs.get(0);
                        c.onFocusMovedTo(cmp);
                    }
                }
            }
        }
    }
}

