/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.browser.impl;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class DOMUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeDOMToFile(Document doc, File f) throws IOException {
        OutputStream os = null;
        try {
            os = new BufferedOutputStream(new FileOutputStream(f));
            DOMUtils.writeDOMToStream(doc, os);
        }
        finally {
            if (os != null) {
                os.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String writeDOMToString(Document doc) {
        String string;
        block6: {
            StringWriter w = new StringWriter();
            try {
                StreamResult sr = new StreamResult(w);
                DOMUtils.writeDOMToSource(doc, sr, "UTF-8");
                string = w.toString();
                if (w == null) break block6;
            }
            catch (Throwable throwable) {
                try {
                    if (w != null) {
                        w.close();
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            w.close();
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String writeDOMToString(Node n) {
        String string;
        block6: {
            StringWriter w = new StringWriter();
            try {
                StreamResult sr = new StreamResult(w);
                DOMUtils.writeDOMToSource(n, sr, "UTF-8");
                string = w.toString();
                if (w == null) break block6;
            }
            catch (Throwable throwable) {
                try {
                    if (w != null) {
                        w.close();
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            w.close();
        }
        return string;
    }

    public static void writeDOMToStream(Document doc, OutputStream os) throws IOException {
        DOMUtils.writeDOMToStream(doc, os, "UTF-8");
    }

    public static void writeDOMToStream(Node n, OutputStream os) throws IOException {
        StreamResult sr = new StreamResult(os);
        DOMUtils.writeDOMToSource(n, sr, "UTF-8");
    }

    public static void writeDOMToStream(Document doc, OutputStream os, String encoding) throws IOException {
        StreamResult sr = new StreamResult(os);
        DOMUtils.writeDOMToSource(doc, sr, encoding);
    }

    public static void writeDOMToSource(Node n, StreamResult sr, String encoding) throws IOException {
        try {
            TransformerFactory trf = TransformerFactory.newInstance();
            Transformer tr = trf.newTransformer();
            tr.setOutputProperty("method", "xml");
            tr.setOutputProperty("encoding", encoding);
            tr.setOutputProperty("indent", "yes");
            tr.transform(new DOMSource(n), sr);
        }
        catch (TransformerException e) {
            IOException ioe = new IOException();
            ioe.initCause(e);
            throw ioe;
        }
    }
}

