/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.browser.impl;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mozilla.browser.XPCOMUtils;
import org.mozilla.browser.impl.ChromeAdapter;
import org.mozilla.interfaces.nsIRequest;
import org.mozilla.interfaces.nsIStreamListener;
import org.mozilla.interfaces.nsISupports;
import org.mozilla.interfaces.nsIURI;
import org.mozilla.interfaces.nsIURIContentListener;
import org.mozilla.interfaces.nsIWebNavigation;
import org.mozilla.interfaces.nsIWebNavigationInfo;
import org.mozilla.xpcom.Mozilla;
import org.mozilla.xpcom.XPCOMException;

public class ContentAdapter
implements nsIURIContentListener {
    static Log log = LogFactory.getLog(ContentAdapter.class);
    private final ChromeAdapter ma;

    public ContentAdapter(ChromeAdapter ma) {
        this.ma = ma;
    }

    public boolean onStartURIOpen(nsIURI aURI) {
        String uri = aURI.getSpec();
        log.trace("Loading " + uri);
        boolean abortOpen = false;
        return abortOpen;
    }

    public boolean doContent(String aContentType, boolean aIsContentPreferred, nsIRequest aRequest, nsIStreamListener[] aContentHandler) {
        throw new XPCOMException(2147500033L);
    }

    public boolean isPreferred(String aContentType, String[] aDesiredContentType) {
        return this.canHandleContent(aContentType, true, aDesiredContentType);
    }

    public boolean canHandleContent(String aContentType, boolean aIsContentPreferred, String[] aDesiredContentType) {
        nsIWebNavigationInfo webNavInfo;
        aDesiredContentType[0] = null;
        if (aContentType != null && (webNavInfo = XPCOMUtils.getService("@mozilla.org/webnavigation-info;1", nsIWebNavigationInfo.class)) != null) {
            nsIWebNavigation webNav = XPCOMUtils.qi(this.ma.getWebBrowser(), nsIWebNavigation.class);
            long canHandle = webNavInfo.isTypeSupported(aContentType, webNav);
            return canHandle != 0L;
        }
        return false;
    }

    public nsISupports getLoadCookie() {
        throw new XPCOMException(2147500033L);
    }

    public void setLoadCookie(nsISupports aLoadCookie) {
        throw new XPCOMException(2147500033L);
    }

    public nsIURIContentListener getParentContentListener() {
        throw new XPCOMException(2147500033L);
    }

    public void setParentContentListener(nsIURIContentListener aParentContentListener) {
        throw new XPCOMException(2147500033L);
    }

    public nsISupports queryInterface(String uuid) {
        return Mozilla.queryInterface(this, uuid);
    }
}

