/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.wizard;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.application.Resource;
import org.jdesktop.swingx.JXButton;
import org.limewire.activation.api.ActivationError;
import org.limewire.activation.api.ActivationEvent;
import org.limewire.activation.api.ActivationManager;
import org.limewire.activation.api.ActivationState;
import org.limewire.core.api.Application;
import org.limewire.core.settings.ActivationSettings;
import org.limewire.listener.EventListener;
import org.limewire.ui.swing.activation.ActivationWarningPanel;
import org.limewire.ui.swing.activation.LabelWithLinkSupport;
import org.limewire.ui.swing.components.HyperlinkButton;
import org.limewire.ui.swing.painter.GreenButtonBackgroundPainter;
import org.limewire.ui.swing.util.BackgroundExecutorService;
import org.limewire.ui.swing.util.GuiUtils;
import org.limewire.ui.swing.util.I18n;
import org.limewire.ui.swing.wizard.WizardPage;

public class SetupActivationPanel
extends JPanel {
    private final ActivationManager activationManager;
    private JTextField licenseField;
    private ActivationWarningPanel iconPanel;
    private JLabel errorMessageLabel;
    private ActivationListener activationListener;
    private LabelWithLinkSupport customerSupportLabel;
    private JXButton okButton;
    private ActivationState state = null;
    private ActivationError error = null;
    @Resource
    private Color errorColor;
    @Resource
    private Color greenButtonForeground;

    public SetupActivationPanel(WizardPage wizardPage, ActivationManager activationManager, Application application) {
        super(new MigLayout("fillx, insets 75 60 10 60, gap 0, gapy 0", "[][grow][]", "[][][][][][][][][][]"));
        GuiUtils.assignResources(this);
        this.activationManager = activationManager;
        this.add(Box.createVerticalStrut(18), "spanx 1, growx, cell 2 1");
        this.add((Component)wizardPage.createAndDecorateHeader(I18n.tr("Activate your LimeWire PRO.")), "cell 2 2");
        HyperlinkButton goProButton = wizardPage.createAndDecorateHyperlink(application.addClientInfoToUrl("http://www.limewire.com/client_redirect/?page=downloadPro"), I18n.tr("Want to go PRO?"));
        goProButton.setToolTipText("");
        this.add((Component)goProButton, "spanx 1, growx, cell 2 2");
        this.add(Box.createVerticalStrut(15), "spanx 1, growx, cell 2 3");
        this.add((Component)wizardPage.createAndDecorateMultiLine(I18n.tr("Enter your activation key below. This was sent to the email address you used when purchasing. You can always do this later on from the File menu.")), "spanx 1, growx, cell 2 4, gapafter 20px");
        this.errorMessageLabel = wizardPage.createAndDecorateMultiLine("");
        this.errorMessageLabel.setForeground(this.errorColor);
        this.errorMessageLabel.setVisible(false);
        this.add((Component)this.errorMessageLabel, "spanx 1, growx, cell 2 5");
        this.add(Box.createRigidArea(new Dimension(1, 33)), "spanx 1, growx, cell 2 5");
        this.iconPanel = new ActivationWarningPanel();
        this.add((Component)this.iconPanel.getComponent(), "cell 1 6, aligny 50%");
        this.add(Box.createHorizontalStrut(3), "cell 1 6, aligny 50%");
        this.add((Component)wizardPage.createAndDecorateHeader(I18n.tr("License Key:")), "aligny 50%");
        this.licenseField = wizardPage.createAndDecorateLicenseKeyField();
        if (!ActivationSettings.ACTIVATION_KEY.isDefault()) {
            this.licenseField.setText(ActivationSettings.ACTIVATION_KEY.getValueAsString());
        }
        this.licenseField.addActionListener(new EnterActionListener());
        this.add((Component)this.licenseField, "cell 2 6, aligny 50%");
        this.okButton = wizardPage.createAndDecorateButton(I18n.tr("Activate"));
        this.okButton.setBackgroundPainter(new GreenButtonBackgroundPainter());
        this.okButton.setForeground(this.greenButtonForeground);
        this.okButton.addActionListener(new EnterActionListener());
        this.okButton.setEnabled(this.licenseField.getText().length() == 14);
        this.licenseField.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("License Complete")) {
                    Boolean enabled = (Boolean)evt.getNewValue();
                    SetupActivationPanel.this.okButton.setEnabled(enabled);
                }
            }
        });
        this.add((Component)this.okButton, "cell 2 6, aligny 50%");
        this.add(Box.createRigidArea(new Dimension(19, 16)), "cell 3 6, aligny 50%");
        this.add(Box.createVerticalStrut(10), "spanx 1, growx, cell 2 7");
        this.add(Box.createHorizontalStrut(88), "cell 2 8, aligny 50%");
        HyperlinkButton unknownKeyButton = wizardPage.createAndDecorateHyperlink(application.addClientInfoToUrl("http://www.limewire.com/client_redirect/?page=accountDetails"), I18n.tr("I don't know my license key"));
        unknownKeyButton.setToolTipText("");
        this.add((Component)unknownKeyButton, "spanx 1, growx, cell 2 8");
        this.add(Box.createVerticalStrut(40), "cell 2 9");
        this.customerSupportLabel = new LabelWithLinkSupport();
        Font font = wizardPage.createAndDecorateLabel("").getFont();
        this.customerSupportLabel.setText("<html><font size=\"3\" face=\"" + font.getFontName() + "\">" + I18n.tr("Please contact {0}customer support{1} for more information.", "<a href='" + application.addClientInfoToUrl("http://www.limewire.com/client_redirect/?page=proSupport") + "'>", "</a>") + "</font></html>");
        this.customerSupportLabel.setToolTipText("");
        this.customerSupportLabel.setVisible(false);
        this.add((Component)this.customerSupportLabel, "align 25% 50%, spanx 1, cell 2 10, hidemode 3");
        this.activationListener = new ActivationListener();
        this.activationManager.addListener(this.activationListener);
    }

    public void applySettings() {
        String licenseKey = this.licenseField.getText();
        if (licenseKey.length() == 14 && (this.state == null || this.state != ActivationState.AUTHORIZED)) {
            new EnterActionListener().actionPerformed(null);
        }
    }

    public void reset() {
        ActivationError activationError = this.activationManager.getActivationError();
        if (activationError != ActivationError.BLOCKED_KEY) {
            this.customerSupportLabel.setVisible(false);
            this.errorMessageLabel.setVisible(false);
            this.iconPanel.setActivationMode(ActivationWarningPanel.Mode.EMPTY);
            this.licenseField.setText("");
        }
    }

    private void setActivationState(ActivationState state, ActivationError error) {
        this.state = state;
        this.error = error;
        this.okButton.setEnabled(true);
        switch (state) {
            case NOT_AUTHORIZED: {
                if (error != ActivationError.COMMUNICATION_ERROR) {
                    this.iconPanel.setActivationMode(ActivationWarningPanel.Mode.WARNING);
                    break;
                }
                this.iconPanel.setActivationMode(ActivationWarningPanel.Mode.EMPTY);
                break;
            }
            case AUTHORIZING: {
                this.okButton.setEnabled(false);
                this.iconPanel.setActivationMode(ActivationWarningPanel.Mode.SPINNER);
                break;
            }
            case REFRESHING: {
                this.iconPanel.setActivationMode(ActivationWarningPanel.Mode.SPINNER);
                break;
            }
            case AUTHORIZED: {
                this.iconPanel.setActivationMode(ActivationWarningPanel.Mode.EMPTY);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown state: " + (Object)((Object)state));
            }
        }
        this.customerSupportLabel.setVisible(false);
        switch (error) {
            case NO_ERROR: {
                this.errorMessageLabel.setVisible(false);
                break;
            }
            case NO_KEY: {
                this.errorMessageLabel.setVisible(false);
                break;
            }
            case INVALID_KEY: {
                this.errorMessageLabel.setText(I18n.tr("Invalid license key."));
                this.errorMessageLabel.setVisible(true);
                break;
            }
            case BLOCKED_KEY: {
                this.errorMessageLabel.setText(I18n.tr("Your license key has been used on too many installations."));
                this.errorMessageLabel.setVisible(true);
                this.customerSupportLabel.setVisible(true);
                break;
            }
            case COMMUNICATION_ERROR: {
                this.errorMessageLabel.setText(I18n.tr("Communication error. Please try again later."));
                this.errorMessageLabel.setVisible(true);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown error: " + (Object)((Object)error));
            }
        }
    }

    private class ActivationListener
    implements EventListener<ActivationEvent> {
        private ActivationListener() {
        }

        @Override
        public void handleEvent(final ActivationEvent event) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SetupActivationPanel.this.setActivationState((ActivationState)((Object)event.getData()), event.getError());
                }
            });
        }
    }

    class EnterActionListener
    implements ActionListener {
        EnterActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            final String key = SetupActivationPanel.this.licenseField.getText();
            if (key != null) {
                BackgroundExecutorService.execute(new Runnable(){

                    @Override
                    public void run() {
                        if (key.equals("")) {
                            SetupActivationPanel.this.setActivationState(ActivationState.NOT_AUTHORIZED, ActivationError.INVALID_KEY);
                            return;
                        }
                        SetupActivationPanel.this.activationManager.activateKey(key.replaceAll("-", ""));
                    }
                });
            }
        }
    }
}

